/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.navigation;

import java.awt.Component;
import java.util.List;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JToggleButtonOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.EditorOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.xhtml.FormNamePanel;

public class NavigatorOperator
extends JComponentOperator {
    private static final String DEFAULT_LINK_ID = "case1";
    private static final String PAGE_NAVIGATION_TITLE = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.navigation.Bundle", "NavigationView");
    private static final String NAVIGATION_BUTTON = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.navigation.Bundle", "ViewNavigation");
    ComponentOperator desktop = null;
    private JToggleButtonOperator _btSource;
    private JToggleButtonOperator _btNavigation;

    public NavigatorOperator(ContainerOperator containerOperator) {
        super(containerOperator, (ComponentChooser)new NavigatorChooser());
        this.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
    }

    public NavigatorOperator() {
        this((ContainerOperator)Util.getMainWindow());
    }

    public JToggleButtonOperator btSource() {
        if (this._btSource == null) {
            TopComponentOperator topComponentOperator = new TopComponentOperator((ContainerOperator)Util.getMainWindow());
            this._btSource = new JToggleButtonOperator((ContainerOperator)topComponentOperator, "XML");
        }
        return this._btSource;
    }

    public JToggleButtonOperator btNavigation() {
        if (this._btNavigation == null) {
            TopComponentOperator topComponentOperator = new TopComponentOperator((ContainerOperator)Util.getMainWindow());
            this._btNavigation = new JToggleButtonOperator((ContainerOperator)topComponentOperator, NAVIGATION_BUTTON);
        }
        return this._btNavigation;
    }

    public void switchToSource() {
        this.btSource().pushNoBlock();
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    public void switchToNavigation() {
        this.btNavigation().pushNoBlock();
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    public static NavigatorOperator show() {
        Util.getMainTab().setSelectedIndex(Util.getMainTab().findPage("Page Navigation"));
        return new NavigatorOperator();
    }

    private ComponentOperator getDesktop() {
        if (this.desktop == null) {
            this.desktop = new NavigatorGraphFrameOperator();
        }
        return this.desktop;
    }

    public void pushPopup(String string) {
        this.getDesktop().clickForPopup(1, 1);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        new JPopupMenuOperator().pushMenuNoBlock(string);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clickForPopup(int n, int n2) {
        this.getDesktop().clickForPopup(n, n2);
    }

    public void clickMouse(int n, int n2) {
        this.getDesktop().clickMouse(n, n2, 1);
    }

    public void clickMouse(int n, int n2, int n3) {
        this.getDesktop().clickMouse(n, n2, n3);
    }

    public void link(String string, String string2) {
        this.linkUsingXmlSource(string, string2);
    }

    public void link(String string, String string2, String string3) {
        this.linkUsingXmlSource(string, string2, string3);
    }

    public void linkUsingXmlSource(List list) {
        this.linkUsingXmlSource(list, DEFAULT_LINK_ID);
    }

    public void linkUsingXmlSource(List list, String string) {
        this.switchToSource();
        Util.wait(1000);
        new QueueTool().waitEmpty();
        EditorOperator editorOperator = this.getEditorOperator();
        for (int i = 0; i < list.size() - 1; ++i) {
            String string2 = (String)list.get(i);
            String string3 = (String)list.get(i + 1);
            this.appendLinkXmlTags(editorOperator, string2, string3, string);
            TestUtils.outMsg("+++ Web page link [" + string + "] from [" + string2 + "] to [" + string3 + "] is created");
        }
        this.switchToNavigation();
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    public void linkUsingXmlSource(String string, String string2) {
        this.linkUsingXmlSource(string, string2, DEFAULT_LINK_ID);
    }

    public void linkUsingXmlSource(String string, String string2, String string3) {
        this.switchToSource();
        Util.wait(1000);
        new QueueTool().waitEmpty();
        EditorOperator editorOperator = this.getEditorOperator();
        this.appendLinkXmlTags(editorOperator, string, string2, string3);
        this.switchToNavigation();
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    private void appendLinkXmlTags(EditorOperator editorOperator, String string, String string2, String string3) {
        this.putCaretToBeginOfLastLine(editorOperator);
        Util.wait(500);
        new QueueTool().waitEmpty();
        String string4 = this.getLinkXmlTags(string, string2, string3);
        TestUtils.outMsg("+++ xml-tags used for link [" + string3 + "] between pages [" + string + "] and [" + string2 + "]: " + string4);
        editorOperator.insert(string4);
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    private void putCaretToBeginOfLastLine(EditorOperator editorOperator) {
        if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            editorOperator.pushKey(35, 256);
        } else {
            editorOperator.pushKey(35, 128);
        }
        Util.wait(1000);
        new QueueTool().waitEmpty();
        editorOperator.pushUpArrowKey();
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    private String getLinkXmlTags(String string, String string2, String string3) {
        String[] stringArray = new String[]{"    <navigation-rule>", "        <from-view-id>/" + string + "</from-view-id>", "            <navigation-case>", "                <from-outcome>" + string3 + "</from-outcome>", "                <to-view-id>/" + string2 + "</to-view-id>", "        </navigation-case>", "    </navigation-rule>"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private EditorOperator getEditorOperator() {
        TopComponentOperator topComponentOperator = new TopComponentOperator((ContainerOperator)Util.getMainWindow());
        EditorOperator editorOperator = new EditorOperator((ContainerOperator)topComponentOperator, PAGE_NAVIGATION_TITLE);
        Util.wait(1000);
        new QueueTool().waitEmpty();
        TestUtils.outMsg("+++ Source editor for [" + PAGE_NAVIGATION_TITLE + "] found");
        return editorOperator;
    }

    public static class NavigatorChooser
    implements ComponentChooser {
        public boolean checkComponent(Component component) {
            return false;
        }

        public String getDescription() {
            return null;
        }
    }

    public class NavigatorGraphFrameChooser
    implements ComponentChooser {
        public boolean checkComponent(Component component) {
            return false;
        }

        public String getDescription() {
            return FormNamePanel.class.getName();
        }
    }

    public class NavigatorGraphFrameOperator
    extends ComponentOperator {
        public NavigatorGraphFrameOperator() {
            super((ContainerOperator)NavigatorOperator.this, (ComponentChooser)new NavigatorGraphFrameChooser());
        }
    }
}

