/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.plugins;

import java.awt.Container;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JFileChooserOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsOperator
extends JDialogOperator {
    private static final String MAIN_MENU_ITEM_TOOLS = "Tools";
    private static final String MAIN_MENU_ITEM_TOOLS_PLUGINS = "Tools|Plugins";
    private static final String DIALOG_TITLE_PLUGINS = "Plugins";
    private static final String DIALOG_TITLE_NETBEANS_IDE_INSTALLER = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.wizards.Bundle", "InstallUnitWizard_Title");
    private static final String DIALOG_TITLE_VALIDATION_WARNING = "Validation Warning";
    private static final String TAB_TITLE_AVAILABLE_PLUGINS = "Available Plugins";
    private static final String TAB_TITLE_DOWNLOADED_PLUGINS = "Downloaded";
    private static final String COLUMN_TITLE_NAME = "Name";
    private static final String COLUMN_TITLE_INSTALL = "Install";
    private static final String RADIO_BUTTON_LICENSE_AGREEMENT_ACCEPT_TEXT = "I accept";
    private static final String BUTTON_LABEL_ADD_PLUGINS = "Add Plugins";
    private static final String BUTTON_LABEL_RELOAD_CATALOG = "Reload Catalog";
    private static final String BUTTON_LABEL_INSTALL = "Install";
    private static final String BUTTON_LABEL_NEXT = "Next";
    private static final String BUTTON_LABEL_CONTINUE = "Continue";
    private static final String BUTTON_LABEL_FINISH = "Finish";
    private static final String BUTTON_LABEL_CLOSE = "Close";
    private JTabbedPaneOperator tabbedPane;
    private JButtonOperator btnClose;
    private boolean pluginsAvailable;

    public static PluginsOperator getInstance() {
        PluginsOperator.display();
        return new PluginsOperator();
    }

    private PluginsOperator() {
        super(DIALOG_TITLE_PLUGINS);
        this.verify();
    }

    public void installAvailablePlugins() {
        this.installAvailablePlugins(Collections.EMPTY_LIST);
    }

    public void installAvailablePlugins(String string) {
        this.installAvailablePlugins(new String[]{string});
    }

    public void installAvailablePlugins(String[] stringArray) {
        this.installAvailablePlugins(Arrays.asList(stringArray));
    }

    public void installAvailablePlugins(List<String> list) {
        ContainerOperator containerOperator = this.waitTabEnabled(TAB_TITLE_AVAILABLE_PLUGINS);
        JTableOperator jTableOperator = new JTableOperator(containerOperator);
        this.fillAvailablePluginsTable(containerOperator, jTableOperator);
        this.selectPlugins(jTableOperator, list);
        if (this.pluginsAvailable) {
            this.installSelectedPlugins(containerOperator);
        } else {
            System.out.println("WARNING: Necessary plugins are absent!");
        }
        this.closeDialog();
    }

    public void installDownloadedPlugins(String string) {
        ContainerOperator containerOperator = this.waitTabEnabled(TAB_TITLE_DOWNLOADED_PLUGINS);
        new JButtonOperator(containerOperator, BUTTON_LABEL_ADD_PLUGINS).pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
        this.addDownloadedPlugins(string, containerOperator);
        JTableOperator jTableOperator = new JTableOperator(containerOperator);
        this.waitPluginsTableFilling(jTableOperator);
        this.installSelectedPlugins(containerOperator);
        this.closeDialog();
    }

    private ContainerOperator waitTabEnabled(String string) {
        int n;
        int n2;
        for (n2 = 0; n2 < 200 && (n = this.tabbedPane.getCursor().getType()) == 3; ++n2) {
            Util.wait(1000);
            new QueueTool().waitEmpty();
        }
        n2 = this.findTab(string);
        if (n2 > -1) {
            this.tabbedPane.setSelectedIndex(n2);
            ContainerOperator containerOperator = new ContainerOperator((Container)this.tabbedPane.getComponentAt(n2));
            Util.wait(500);
            new QueueTool().waitEmpty();
            return containerOperator;
        }
        throw new RuntimeException("Tab with title [" + string + "] isn't found in the dialog [" + this.getTitle() + "]");
    }

    private int findTab(String string) {
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.tabbedPane.getTitleAt(i);
            if (string2.indexOf(string) <= -1) continue;
            return i;
        }
        return -1;
    }

    private int getColumnIndexByName(JTableOperator jTableOperator, String string) {
        int n = jTableOperator.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string2 = jTableOperator.getColumnName(i);
            if (string2.indexOf(string) <= -1) continue;
            return i;
        }
        return -1;
    }

    private void fillAvailablePluginsTable(ContainerOperator containerOperator, JTableOperator jTableOperator) {
        int n = jTableOperator.getRowCount();
        if (n == 0) {
            new JButtonOperator(containerOperator, BUTTON_LABEL_RELOAD_CATALOG).pushNoBlock();
            Util.wait(500);
            new QueueTool().waitEmpty();
            this.waitPluginsTableFilling(jTableOperator);
        }
    }

    private void waitPluginsTableFilling(JTableOperator jTableOperator) {
        int n;
        for (int i = 0; i < 200 && (n = jTableOperator.getRowCount()) < 1; ++i) {
            Util.wait(1000);
            new QueueTool().waitEmpty();
        }
    }

    private void selectPlugins(JTableOperator jTableOperator, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getColumnIndexByName(jTableOperator, COLUMN_TITLE_NAME);
        int n2 = this.getColumnIndexByName(jTableOperator, "Install");
        int n3 = jTableOperator.getRowCount();
        for (int i = 0; i < n3; ++i) {
            Object object = jTableOperator.getValueAt(i, n);
            if (!this.isPluginInList(list, object.toString())) continue;
            int n4 = i;
            jTableOperator.clickOnCell(n4, n2);
            Util.wait(500);
            new QueueTool().waitEmpty();
            arrayList.add(object.toString());
        }
        this.pluginsAvailable = !arrayList.isEmpty();
    }

    private boolean isPluginInList(List<String> list, String string) {
        if (list.isEmpty()) {
            return true;
        }
        return list.contains(string);
    }

    private void addDownloadedPlugins(String string, ContainerOperator containerOperator) {
        new JButtonOperator(containerOperator, BUTTON_LABEL_ADD_PLUGINS).pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
        JFileChooserOperator jFileChooserOperator = new JFileChooserOperator();
        jFileChooserOperator.setSelectedFile(new File(string));
        Util.wait(500);
        new QueueTool().waitEmpty();
        jFileChooserOperator.approve();
        Util.wait(500);
        new QueueTool().waitEmpty();
    }

    private void installSelectedPlugins(ContainerOperator containerOperator) {
        JButtonOperator jButtonOperator = new JButtonOperator(containerOperator, "Install");
        if (!jButtonOperator.isEnabled()) {
            throw new RuntimeException("The button [Install] isn't enabled in the dialog [Plugins]");
        }
        jButtonOperator.pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
        this.workInstallerDialog();
    }

    private void workInstallerDialog() {
        JDialogOperator jDialogOperator = new JDialogOperator(DIALOG_TITLE_NETBEANS_IDE_INSTALLER);
        Util.wait(3000);
        new QueueTool().waitEmpty();
        String string = "ComponentOperator.WaitComponentTimeout";
        long l = JemmyProperties.getCurrentTimeout((String)string);
        long l2 = 1000L;
        JemmyProperties.getCurrentTimeouts().setTimeout(string, l2);
        try {
            new JButtonOperator((ContainerOperator)jDialogOperator, BUTTON_LABEL_NEXT).pushNoBlock();
            Util.wait(1000);
            new QueueTool().waitEmpty();
            JCheckBoxOperator jCheckBoxOperator = new JCheckBoxOperator((ContainerOperator)jDialogOperator, RADIO_BUTTON_LICENSE_AGREEMENT_ACCEPT_TEXT);
            jCheckBoxOperator.changeSelection(true);
            Util.wait(500);
            new QueueTool().waitEmpty();
            Util.wait(500);
            new QueueTool().waitEmpty();
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            timeoutExpiredException.printStackTrace(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new RuntimeException(exception);
        }
        finally {
            JemmyProperties.getCurrentTimeouts().setTimeout(string, l);
        }
        new JButtonOperator((ContainerOperator)jDialogOperator, "Install").pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
        this.waitInstallationFinish(jDialogOperator);
    }

    private void waitInstallationFinish(JDialogOperator jDialogOperator) {
        String string = "DialogWaiter.WaitDialogTimeout";
        long l = JemmyProperties.getCurrentTimeout((String)string);
        long l2 = 1000L;
        JemmyProperties.getCurrentTimeouts().setTimeout(string, l2);
        JButtonOperator jButtonOperator = null;
        for (int i = 0; !(i >= 600 || (jButtonOperator = this.checkButtonFinishAppearance(jDialogOperator)) != null && jButtonOperator.isEnabled()); ++i) {
        }
        JemmyProperties.getCurrentTimeouts().setTimeout(string, l > 0L ? l : 60000L);
        if (jButtonOperator == null || !jButtonOperator.isEnabled()) {
            throw new RuntimeException("The button [Finish] is not found or disabled in the dialog [" + DIALOG_TITLE_NETBEANS_IDE_INSTALLER + "]");
        }
        jButtonOperator.pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
    }

    private JButtonOperator checkButtonFinishAppearance(JDialogOperator jDialogOperator) {
        String string = "ComponentOperator.WaitComponentTimeout";
        long l = JemmyProperties.getCurrentTimeout((String)string);
        long l2 = 1000L;
        JemmyProperties.getCurrentTimeouts().setTimeout(string, l2);
        JButtonOperator jButtonOperator = null;
        try {
            JButtonOperator jButtonOperator2 = jButtonOperator = new JButtonOperator((ContainerOperator)jDialogOperator, BUTTON_LABEL_FINISH);
            return jButtonOperator2;
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            Util.wait(500);
            new QueueTool().waitEmpty();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new RuntimeException(exception);
        }
        finally {
            JemmyProperties.getCurrentTimeouts().setTimeout(string, l);
        }
        return null;
    }

    private void closeDialog() {
        this.btnClose.pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
    }

    /*
     * Loose catch block
     */
    public static void display() {
        String string = "DialogWaiter.WaitDialogTimeout";
        long l = JemmyProperties.getCurrentTimeout((String)string);
        long l2 = 1500L;
        JemmyProperties.getCurrentTimeouts().setTimeout(string, l2);
        try {
            new JDialogOperator(DIALOG_TITLE_PLUGINS);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            Util.getMainMenu().pushMenuNoBlock(MAIN_MENU_ITEM_TOOLS_PLUGINS);
            Util.wait(1000);
            new QueueTool().waitEmpty();
            JemmyProperties.getCurrentTimeouts().setTimeout(string, l > 0L ? l : 60000L);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new RuntimeException(exception);
            {
                catch (Throwable throwable) {
                    JemmyProperties.getCurrentTimeouts().setTimeout(string, l > 0L ? l : 60000L);
                    throw throwable;
                }
            }
        }
        JemmyProperties.getCurrentTimeouts().setTimeout(string, l > 0L ? l : 60000L);
    }

    public JTabbedPaneOperator checkTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPaneOperator((ContainerOperator)this);
        }
        return this.tabbedPane;
    }

    private JButtonOperator checkButtonClose() {
        if (this.btnClose == null) {
            this.btnClose = new JButtonOperator((ContainerOperator)this, BUTTON_LABEL_CLOSE);
        }
        return this.btnClose;
    }

    public void verify() {
        this.checkTabbedPane();
        this.checkButtonClose();
    }

    private void debugOutput(Object ... objectArray) {
        System.out.println();
        for (Object object : objectArray) {
            System.out.println(object.toString());
        }
        System.out.println();
    }

    private class DialogWatcher
    implements Runnable {
        private String dialogTitle;
        private String buttonLabel;
        private boolean stopWatch = true;
        private Thread watchThread = new Thread(this);

        public DialogWatcher(String string, String string2) {
            this.dialogTitle = string;
            this.buttonLabel = string2;
        }

        public void startWatch() {
            this.stopWatch = false;
            this.watchThread.start();
        }

        public void stopWatch() {
            this.stopWatch = true;
            do {
                Util.wait(500);
            } while (this.watchThread.isAlive());
            Util.wait(1000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stopWatch) {
                DialogWatcher dialogWatcher = this;
                synchronized (dialogWatcher) {
                    try {
                        this.wait(1000L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                        throw new RuntimeException(exception);
                    }
                }
                dialogWatcher = this.checkDialogAppearance();
                if (dialogWatcher == null) continue;
                new JButtonOperator((ContainerOperator)dialogWatcher, this.buttonLabel).pushNoBlock();
                Util.wait(500);
                new QueueTool().waitEmpty();
                this.stopWatch = true;
            }
            return;
        }

        private JDialogOperator checkDialogAppearance() {
            String string = "DialogWaiter.WaitDialogTimeout";
            long l = JemmyProperties.getCurrentTimeout((String)string);
            long l2 = 1000L;
            JemmyProperties.getCurrentTimeouts().setTimeout(string, l2);
            try {
                JDialogOperator jDialogOperator;
                JDialogOperator jDialogOperator2 = jDialogOperator = new JDialogOperator(this.dialogTitle);
                return jDialogOperator2;
            }
            catch (TimeoutExpiredException timeoutExpiredException) {
                Util.wait(500);
                new QueueTool().waitEmpty();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                throw new RuntimeException(exception);
            }
            finally {
                JemmyProperties.getCurrentTimeouts().setTimeout(string, l);
            }
            return null;
        }
    }
}

