/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.screen.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditedScreenSupport {
    private static final WeakHashMap<DesignDocument, EditedScreenSupport> instances = new WeakHashMap();
    private long editedScreenComponentID = -1L;
    private final ArrayList<Listener> listeners = new ArrayList();

    private EditedScreenSupport() {
    }

    public static synchronized EditedScreenSupport getSupportForDocument(DesignDocument designDocument) {
        EditedScreenSupport editedScreenSupport = instances.get(designDocument);
        if (editedScreenSupport == null) {
            editedScreenSupport = new EditedScreenSupport();
            instances.put(designDocument, editedScreenSupport);
        }
        return editedScreenSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public long getEditedScreenComponentID() {
        return this.editedScreenComponentID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditedScreenComponentID(long l) {
        this.editedScreenComponentID = l;
        Listener[] listenerArray = this.listeners;
        synchronized (this.listeners) {
            Listener[] listenerArray2 = this.listeners.toArray(new Listener[this.listeners.size()]);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            for (Listener listener : listenerArray2) {
                listener.editedScreenChanged(l);
            }
            return;
        }
    }

    public static List<DesignComponent> getAllEditableScreensInDocument(DesignDocument designDocument) {
        assert (designDocument.getTransactionManager().isAccess());
        ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>();
        for (DesignComponent designComponent : DocumentSupport.gatherAllComponentsContainingPresenterClass((DesignDocument)designDocument, ScreenDisplayPresenter.class)) {
            if (!((ScreenDisplayPresenter)designComponent.getPresenter(ScreenDisplayPresenter.class)).isTopLevelDisplay()) continue;
            arrayList.add(designComponent);
        }
        return arrayList;
    }

    public static interface Listener {
        public void editedScreenChanged(long var1);
    }
}

