/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.model.AccessController;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfoPresenter;
import org.netbeans.modules.vmd.api.screen.editor.EditedScreenSupport;
import org.netbeans.modules.vmd.screen.MainPanel;
import org.netbeans.modules.vmd.screen.device.DevicePanel;
import org.netbeans.modules.vmd.screen.resource.ResourcePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScreenAccessController
implements AccessController,
EditedScreenSupport.Listener {
    private final DesignDocument document;
    private JPanel mainPanel;
    private DevicePanel devicePanel;
    private final ResourcePanel resourcePanel;
    private final JComboBox editedScreenCombo;
    private final ActionListener editedScreenComboListener;
    private DesignComponent editedScreen;
    private List<DesignComponent> allEditableScreens = Collections.emptyList();

    public ScreenAccessController(final DesignDocument designDocument) {
        this.document = designDocument;
        this.resourcePanel = new ResourcePanel(this);
        this.editedScreenCombo = new JComboBox();
        this.editedScreenCombo.setRenderer(new EditedComboRenderer());
        this.editedScreenComboListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                designDocument.getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        DesignComponent designComponent = (DesignComponent)ScreenAccessController.this.editedScreenCombo.getSelectedItem();
                        EditedScreenSupport.getSupportForDocument(designDocument).setEditedScreenComponentID(designComponent != null ? designComponent.getComponentID() : -1L);
                    }
                });
            }
        };
        this.editedScreenCombo.addActionListener(this.editedScreenComboListener);
        EditedScreenSupport.getSupportForDocument(designDocument).addListener(this);
    }

    @Override
    public void editedScreenChanged(long l) {
        this.editedScreen = this.document.getComponentByUID(EditedScreenSupport.getSupportForDocument(this.document).getEditedScreenComponentID());
        this.editedScreenCombo.removeActionListener(this.editedScreenComboListener);
        this.editedScreenCombo.setSelectedItem(this.editedScreen);
        this.editedScreenCombo.addActionListener(this.editedScreenComboListener);
        this.refreshPanels();
    }

    public void writeAccess(Runnable runnable) {
        runnable.run();
    }

    public void notifyEventFiring(DesignEvent designEvent) {
    }

    public void notifyEventFired(DesignEvent designEvent) {
        if (!this.isDeviceInfoExists()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScreenAccessController.this.document.getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        ScreenAccessController.this.refreshModel();
                    }
                });
            }
        });
    }

    private void refreshModel() {
        if (this.devicePanel == null) {
            this.devicePanel = new DevicePanel(this);
            this.mainPanel = new MainPanel(this.devicePanel, this.resourcePanel);
        }
        this.allEditableScreens = EditedScreenSupport.getAllEditableScreensInDocument(this.document);
        this.editedScreenCombo.removeActionListener(this.editedScreenComboListener);
        this.editedScreenCombo.setModel(new DefaultComboBoxModel<Object>(this.allEditableScreens.toArray()));
        if (!this.allEditableScreens.contains(this.editedScreen)) {
            this.editedScreen = null;
        }
        this.editedScreenCombo.setSelectedItem(this.editedScreen);
        this.editedScreenCombo.addActionListener(this.editedScreenComboListener);
        if (this.editedScreen == null && this.allEditableScreens.size() > 0) {
            this.editedScreen = this.allEditableScreens.get(0);
            EditedScreenSupport.getSupportForDocument(this.document).setEditedScreenComponentID(this.editedScreen.getComponentID());
            return;
        }
        this.refreshPanels();
    }

    public void refreshPanels() {
        if (this.devicePanel == null) {
            return;
        }
        this.devicePanel.reload();
        this.resourcePanel.reload();
        this.mainPanel.validate();
    }

    public void notifyComponentsCreated(Collection<DesignComponent> collection) {
    }

    void showNotify() {
    }

    void hideNotify() {
    }

    JComponent getMainPanel() {
        return this.mainPanel;
    }

    JComponent getToolBar() {
        return this.editedScreenCombo;
    }

    public DesignDocument getDocument() {
        return this.document;
    }

    public DesignComponent getEditedScreen() {
        assert (SwingUtilities.isEventDispatchThread());
        assert (this.document.getTransactionManager().isAccess());
        return this.editedScreen;
    }

    public void setScreenSize(Dimension dimension) {
        if (this.devicePanel != null) {
            this.devicePanel.setScreenSize(dimension);
        }
    }

    private boolean isDeviceInfoExists() {
        DesignComponent designComponent = this.document.getRootComponent();
        if (designComponent == null) {
            return false;
        }
        ScreenDeviceInfoPresenter screenDeviceInfoPresenter = (ScreenDeviceInfoPresenter)designComponent.getPresenter(ScreenDeviceInfoPresenter.class);
        return screenDeviceInfoPresenter != null && screenDeviceInfoPresenter.getScreenDeviceInfo() != null;
    }

    private class EditedComboRenderer
    extends DefaultListCellRenderer {
        private EditedComboRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            final Image[] imageArray = new Image[1];
            final String[] stringArray = new String[1];
            if (object != null) {
                final DesignComponent designComponent = (DesignComponent)object;
                ScreenAccessController.this.document.getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        InfoPresenter infoPresenter = (InfoPresenter)designComponent.getPresenter(InfoPresenter.class);
                        stringArray[0] = infoPresenter.getDisplayName(InfoPresenter.NameType.PRIMARY);
                        imageArray[0] = infoPresenter.getIcon(InfoPresenter.IconType.COLOR_16x16);
                    }
                });
            }
            super.getListCellRendererComponent((JList<?>)jList, stringArray[0], n, bl, bl2);
            if (imageArray[0] != null) {
                this.setIcon(new ImageIcon(imageArray[0]));
            }
            return this;
        }
    }
}

