/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.Component;
import java.awt.Container;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;

public class ComponentSearcher
implements Outputable {
    private int ordinalIndex;
    private Container container;
    private TestOut out;
    private QueueTool queueTool;
    private String containerToString;

    public ComponentSearcher(Container container) {
        this.container = container;
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.queueTool = new QueueTool();
    }

    public static ComponentChooser getTrueChooser(String string) {
        class TrueChooser
        implements ComponentChooser {
            private String description;

            public TrueChooser(String string) {
                this.description = string;
            }

            public boolean checkComponent(Component component) {
                return true;
            }

            public String getDescription() {
                return this.description;
            }
        }
        return new TrueChooser(string);
    }

    public void setOutput(TestOut testOut) {
        this.out = testOut;
    }

    public TestOut getOutput() {
        return this.out;
    }

    private String containerToString() {
        if (this.containerToString == null) {
            this.containerToString = this.container == null ? "null" : (String)this.queueTool.invokeSmoothly(new QueueTool.QueueAction("container.toString()"){

                public Object launch() {
                    return ComponentSearcher.this.container.toString();
                }
            });
        }
        return this.containerToString;
    }

    public Component findComponent(ComponentChooser componentChooser, int n) {
        this.ordinalIndex = 0;
        final Component component = this.findComponentInContainer(this.container, componentChooser, n);
        if (component != null) {
            String string = (String)this.queueTool.invokeSmoothly(new QueueTool.QueueAction("result.toString()"){

                public Object launch() {
                    return component.toString();
                }
            });
            this.out.printTrace("Component " + componentChooser.getDescription() + "\n    was found in container " + this.containerToString() + "\n    " + string);
            this.out.printGolden("Component \"" + componentChooser.getDescription() + "\" was found");
        } else {
            this.out.printTrace("Component " + componentChooser.getDescription() + "\n    was not found in container " + this.containerToString());
            this.out.printGolden("Component \"" + componentChooser.getDescription() + "\" was not found");
        }
        return component;
    }

    public Component findComponent(ComponentChooser componentChooser) {
        return this.findComponent(componentChooser, 0);
    }

    private Component findComponentInContainer(Container container, ComponentChooser componentChooser, int n) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component;
            if (componentArray[i] == null) continue;
            if (componentChooser.checkComponent(componentArray[i])) {
                if (this.ordinalIndex == n) {
                    return componentArray[i];
                }
                ++this.ordinalIndex;
            }
            if (!(componentArray[i] instanceof Container) || (component = this.findComponentInContainer((Container)componentArray[i], componentChooser, n)) == null) continue;
            return component;
        }
        return null;
    }
}

