/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.Component;
import java.awt.Frame;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.WindowWaiter;

public class FrameWaiter
extends WindowWaiter
implements Timeoutable,
Outputable {
    private static final long WAIT_TIME = 60000L;
    private static final long AFTER_WAIT_TIME = 0L;
    private Timeouts timeouts;
    private TestOut output;

    public FrameWaiter() {
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
    }

    public static Frame getFrame(ComponentChooser componentChooser) {
        return (Frame)WindowWaiter.getWindow(new FrameSubChooser(componentChooser));
    }

    public static Frame getFrame(ComponentChooser componentChooser, int n) {
        return (Frame)WindowWaiter.getWindow(new FrameSubChooser(componentChooser), n);
    }

    public static Frame getFrame(String string, boolean bl, boolean bl2) {
        return (Frame)WindowWaiter.getWindow(new FrameByTitleChooser(string, bl, bl2));
    }

    public static Frame getFrame(String string, boolean bl, boolean bl2, int n) {
        return (Frame)WindowWaiter.getWindow(new FrameByTitleChooser(string, bl, bl2), n);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        Timeouts timeouts2 = timeouts.cloneThis();
        timeouts2.setTimeout("WindowWaiter.WaitWindowTimeout", timeouts.getTimeout("FrameWaiter.WaitFrameTimeout"));
        timeouts2.setTimeout("WindowWaiter.AfterWindowTimeout", timeouts.getTimeout("FrameWaiter.AfterFrameTimeout"));
        super.setTimeouts(timeouts2);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(testOut);
    }

    public TestOut getOutput() {
        return this.output;
    }

    public Frame waitFrame(ComponentChooser componentChooser, int n) throws InterruptedException {
        this.setTimeouts(this.timeouts);
        return (Frame)this.waitWindow(new FrameSubChooser(componentChooser), n);
    }

    public Frame waitFrame(ComponentChooser componentChooser) throws InterruptedException {
        return this.waitFrame(componentChooser, 0);
    }

    public Frame waitFrame(String string, boolean bl, boolean bl2, int n) throws InterruptedException {
        return this.waitFrame(new FrameByTitleChooser(string, bl, bl2), n);
    }

    public Frame waitFrame(String string, boolean bl, boolean bl2) throws InterruptedException {
        return this.waitFrame(string, bl, bl2, 0);
    }

    protected String getWaitingStartedMessage() {
        return "Start to wait frame \"" + this.getComponentChooser().getDescription() + "\" opened";
    }

    protected String getTimeoutExpiredMessage(long l) {
        return "Frame \"" + this.getComponentChooser().getDescription() + "\" has not been opened in " + new Long(l).toString() + " milliseconds";
    }

    protected String getActionProducedMessage(long l, final Object object) {
        String string = null;
        string = object instanceof Component ? (String)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("result.toString()"){

            public Object launch() {
                return object.toString();
            }
        }) : object.toString();
        return "Frame \"" + this.getComponentChooser().getDescription() + "\" has been opened in " + new Long(l).toString() + " milliseconds" + "\n    " + string;
    }

    protected String getGoldenWaitingStartedMessage() {
        return "Start to wait frame \"" + this.getComponentChooser().getDescription() + "\" opened";
    }

    protected String getGoldenTimeoutExpiredMessage() {
        return "Frame \"" + this.getComponentChooser().getDescription() + "\" has not been opened";
    }

    protected String getGoldenActionProducedMessage() {
        return "Frame \"" + this.getComponentChooser().getDescription() + "\" has been opened";
    }

    static {
        Timeouts.initDefault("FrameWaiter.WaitFrameTimeout", 60000L);
        Timeouts.initDefault("FrameWaiter.AfterFrameTimeout", 0L);
    }

    private static class FrameByTitleChooser
    implements ComponentChooser {
        String title;
        boolean compareExactly;
        boolean compareCaseSensitive;

        public FrameByTitleChooser(String string, boolean bl, boolean bl2) {
            this.title = string;
            this.compareExactly = bl;
            this.compareCaseSensitive = bl2;
        }

        public boolean checkComponent(Component component) {
            if (component instanceof Frame && ((Frame)component).isShowing() && component.isVisible() && ((Frame)component).getTitle() != null) {
                String string = ((Frame)component).getTitle();
                String string2 = this.title;
                if (this.compareCaseSensitive) {
                    string = string.toUpperCase();
                    string2 = string2.toUpperCase();
                }
                if (this.compareExactly) {
                    return string.equals(string2);
                }
                return string.indexOf(string2) != -1;
            }
            return false;
        }

        public String getDescription() {
            return this.title;
        }
    }

    private static class FrameSubChooser
    implements ComponentChooser {
        private ComponentChooser chooser;

        public FrameSubChooser(ComponentChooser componentChooser) {
            this.chooser = componentChooser;
        }

        public boolean checkComponent(Component component) {
            if (component instanceof Frame) {
                return component.isShowing() && component.isVisible() && this.chooser.checkComponent(component);
            }
            return false;
        }

        public String getDescription() {
            return this.chooser.getDescription();
        }
    }
}

