/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import org.netbeans.jemmy.BundleManager;
import org.netbeans.jemmy.CharBindingMap;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.DefaultCharBindingMap;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.APIDriverInstaller;
import org.netbeans.jemmy.drivers.DefaultDriverInstaller;
import org.netbeans.jemmy.drivers.DriverInstaller;
import org.netbeans.jemmy.drivers.InputDriverInstaller;

public class JemmyProperties {
    public static int QUEUE_MODEL_MASK = 1;
    public static int ROBOT_MODEL_MASK = 2;
    public static int SHORTCUT_MODEL_MASK = 4;
    public static int SMOOTH_ROBOT_MODEL_MASK = 8;
    private static final int DEFAULT_DRAG_AND_DROP_STEP_LENGTH = 100;
    private static Stack propStack = null;
    Hashtable properties = new Hashtable();

    protected JemmyProperties() {
        this.setProperty("timeouts", new Timeouts());
        this.setProperty("output", new TestOut());
        this.setProperty("resources", new BundleManager());
        this.setProperty("binding.map", new DefaultCharBindingMap());
        this.setProperty("dispatching.model", new Integer(JemmyProperties.getDefaultDispatchingModel()));
        this.setProperty("drag_and_drop.step_length", new Integer(100));
    }

    public static String getMajorVersion() {
        return JemmyProperties.extractValue(JemmyProperties.getProperties().getClass().getClassLoader().getResourceAsStream("org/netbeans/jemmy/version_info"), "Jemmy-MajorVersion");
    }

    public static String getMinorVersion() {
        return JemmyProperties.extractValue(JemmyProperties.getProperties().getClass().getClassLoader().getResourceAsStream("org/netbeans/jemmy/version_info"), "Jemmy-MinorVersion");
    }

    public static String getBuild() {
        return JemmyProperties.extractValue(JemmyProperties.getProperties().getClass().getClassLoader().getResourceAsStream("org/netbeans/jemmy/version_info"), "Jemmy-Build");
    }

    public static String getFullVersion() {
        return JemmyProperties.getMajorVersion() + "." + JemmyProperties.getMinorVersion() + "-" + JemmyProperties.getBuild();
    }

    public static String getVersion() {
        return JemmyProperties.getMajorVersion() + "." + JemmyProperties.getMinorVersion();
    }

    public static JemmyProperties push() {
        return JemmyProperties.push(JemmyProperties.getProperties().cloneThis());
    }

    public static JemmyProperties pop() {
        JemmyProperties jemmyProperties = (JemmyProperties)propStack.pop();
        if (propStack.isEmpty()) {
            propStack.push(jemmyProperties);
        }
        return jemmyProperties;
    }

    public static Object getCurrentProperty(String string) {
        return JemmyProperties.getProperties().getProperty(string);
    }

    public static Object setCurrentProperty(String string, Object object) {
        return JemmyProperties.getProperties().setProperty(string, object);
    }

    public static Object removeCurrentProperty(String string) {
        return JemmyProperties.getProperties().removeProperty(string);
    }

    public static String[] getCurrentKeys() {
        return JemmyProperties.getProperties().getKeys();
    }

    public static Timeouts getCurrentTimeouts() {
        return JemmyProperties.getProperties().getTimeouts();
    }

    public static Timeouts setCurrentTimeouts(Timeouts timeouts) {
        return JemmyProperties.getProperties().setTimeouts(timeouts);
    }

    public static long setCurrentTimeout(String string, long l) {
        return JemmyProperties.getProperties().getTimeouts().setTimeout(string, l);
    }

    public static long getCurrentTimeout(String string) {
        return JemmyProperties.getProperties().getTimeouts().getTimeout(string);
    }

    public static long initCurrentTimeout(String string, long l) {
        return JemmyProperties.getProperties().getTimeouts().initTimeout(string, l);
    }

    public static TestOut getCurrentOutput() {
        return JemmyProperties.getProperties().getOutput();
    }

    public static TestOut setCurrentOutput(TestOut testOut) {
        return JemmyProperties.getProperties().setOutput(testOut);
    }

    public static BundleManager getCurrentBundleManager() {
        return JemmyProperties.getProperties().getBundleManager();
    }

    public static BundleManager setCurrentBundleManager(BundleManager bundleManager) {
        return JemmyProperties.getProperties().setBundleManager(bundleManager);
    }

    public static String getCurrentResource(String string) {
        return JemmyProperties.getProperties().getBundleManager().getResource(string);
    }

    public static String getCurrentResource(String string, String string2) {
        return JemmyProperties.getProperties().getBundleManager().getResource(string, string2);
    }

    public static CharBindingMap getCurrentCharBindingMap() {
        return JemmyProperties.getProperties().getCharBindingMap();
    }

    public static CharBindingMap setCurrentCharBindingMap(CharBindingMap charBindingMap) {
        return JemmyProperties.getProperties().setCharBindingMap(charBindingMap);
    }

    public static int getCurrentDispatchingModel() {
        return JemmyProperties.getProperties().getDispatchingModel();
    }

    public static int setCurrentDispatchingModel(int n) {
        return JemmyProperties.getProperties().setDispatchingModel(n);
    }

    public static int getDefaultDispatchingModel() {
        return SHORTCUT_MODEL_MASK | QUEUE_MODEL_MASK;
    }

    public static int getCurrentDragAndDropStepLength() {
        return JemmyProperties.getProperties().getDragAndDropStepLength();
    }

    public static int setCurrentDragAndDropStepLength(int n) {
        return JemmyProperties.getProperties().setDragAndDropStepLength(n);
    }

    public static JemmyProperties getProperties() {
        if (propStack == null) {
            propStack = new Stack();
        }
        if (propStack.empty()) {
            propStack.add(new JemmyProperties());
        }
        return (JemmyProperties)propStack.peek();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Jemmy version : " + JemmyProperties.getVersion());
        } else if (stringArray.length == 1 && stringArray[0].equals("-f")) {
            System.out.println("Jemmy full version : " + JemmyProperties.getFullVersion());
        } else {
            System.out.println("Parameters: ");
            System.out.println("<no parameters> - report Jemmy version.");
            System.out.println("\"-f\" - report full jemmy version.");
        }
        System.exit(0);
    }

    protected static JemmyProperties push(JemmyProperties jemmyProperties) {
        return propStack.push(jemmyProperties);
    }

    public void initProperties(String string) {
        try {
            this.getOutput().printLine("Loading properties from " + string + " file");
            Properties properties = new Properties();
            properties.load(new FileInputStream(string));
            if (properties.getProperty("TIMEOUTS_FILE") != null && !properties.getProperty("TIMEOUTS_FILE").equals("")) {
                this.getOutput().printLine("Loading timeouts from " + properties.getProperty("TIMEOUTS_FILE") + " file");
                this.getTimeouts().loadDefaults(properties.getProperty("TIMEOUTS_FILE"));
            }
            if (properties.getProperty("RESOURCE_FILE") != null && !properties.getProperty("RESOURCE_FILE").equals("")) {
                this.getOutput().printLine("Loading resources from " + properties.getProperty("RESOURCE_FILE") + " file");
                this.getBundleManager().loadBundleFromFile(properties.getProperty("RESOURCE_FILE"), "");
            }
        }
        catch (IOException iOException) {
            this.getOutput().printStackTrace(iOException);
        }
    }

    public void initProperties() {
        if (System.getProperty("jemmy.properties") != null && !System.getProperty("jemmy.properties").equals("")) {
            this.initProperties(System.getProperty("jemmy.properties"));
        } else {
            try {
                this.getTimeouts().load();
                this.getBundleManager().load();
            }
            catch (IOException iOException) {
                this.getOutput().printStackTrace(iOException);
            }
        }
    }

    public void initDispatchingModel(boolean bl, boolean bl2, boolean bl3) {
        this.initDispatchingModel(bl, bl2, bl3, false);
    }

    public void initDispatchingModel(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = JemmyProperties.getDefaultDispatchingModel();
        this.getOutput().print("Reproduce user actions ");
        if (bl) {
            n = QUEUE_MODEL_MASK;
            this.getOutput().printLine("through event queue.");
        } else {
            n -= n & QUEUE_MODEL_MASK;
            this.getOutput().printLine("directly.");
        }
        this.getOutput().print("Use ");
        if (bl2) {
            n |= ROBOT_MODEL_MASK;
            this.getOutput().print("java.awt.Robot class");
        } else {
            n -= n & ROBOT_MODEL_MASK;
            this.getOutput().print("event dispatching");
        }
        n = bl4 ? (n |= SMOOTH_ROBOT_MODEL_MASK) : (n -= n & SMOOTH_ROBOT_MODEL_MASK);
        this.getOutput().printLine(" to reproduce user actions");
        if (bl3) {
            n |= SHORTCUT_MODEL_MASK;
            this.getOutput().print("Shortcut");
        } else {
            n -= n & SHORTCUT_MODEL_MASK;
            this.getOutput().print("Dispatch");
        }
        this.getOutput().printLine(" test events");
        this.setDispatchingModel(n);
    }

    public void initDispatchingModel(boolean bl, boolean bl2) {
        this.initDispatchingModel(bl, bl2, false);
    }

    public void initDispatchingModel() {
        boolean bl;
        boolean bl2 = (JemmyProperties.getDefaultDispatchingModel() & QUEUE_MODEL_MASK) != 0;
        boolean bl3 = (JemmyProperties.getDefaultDispatchingModel() & ROBOT_MODEL_MASK) != 0;
        boolean bl4 = (JemmyProperties.getDefaultDispatchingModel() & SMOOTH_ROBOT_MODEL_MASK) != 0;
        boolean bl5 = bl = (JemmyProperties.getDefaultDispatchingModel() & SHORTCUT_MODEL_MASK) != 0;
        if (System.getProperty("jemmy.queue_dispatching") != null && !System.getProperty("jemmy.queue_dispatching").equals("")) {
            bl2 = System.getProperty("jemmy.queue_dispatching").equals("on");
        }
        if (System.getProperty("jemmy.robot_dispatching") != null && !System.getProperty("jemmy.robot_dispatching").equals("")) {
            bl3 = System.getProperty("jemmy.robot_dispatching").equals("on");
        }
        if (System.getProperty("jemmy.smooth_robot_dispatching") != null && !System.getProperty("jemmy.smooth_robot_dispatching").equals("")) {
            bl4 = System.getProperty("jemmy.smooth_robot_dispatching").equals("on");
        }
        if (System.getProperty("jemmy.shortcut_events") != null && !System.getProperty("jemmy.shortcut_events").equals("")) {
            bl = System.getProperty("jemmy.shortcut_events").equals("on");
        }
        this.initDispatchingModel(bl2, bl3, bl, bl4);
    }

    public void init() {
        this.initProperties();
        this.initDispatchingModel();
    }

    public Timeouts getTimeouts() {
        return (Timeouts)this.getProperty("timeouts");
    }

    public Timeouts setTimeouts(Timeouts timeouts) {
        return (Timeouts)this.setProperty("timeouts", timeouts);
    }

    public long setTimeout(String string, long l) {
        return this.getTimeouts().setTimeout(string, l);
    }

    public long getTimeout(String string) {
        return this.getTimeouts().getTimeout(string);
    }

    public long initTimeout(String string, long l) {
        return this.getTimeouts().initTimeout(string, l);
    }

    public TestOut getOutput() {
        return (TestOut)this.getProperty("output");
    }

    public TestOut setOutput(TestOut testOut) {
        return (TestOut)this.setProperty("output", testOut);
    }

    public BundleManager getBundleManager() {
        return (BundleManager)this.getProperty("resources");
    }

    public BundleManager setBundleManager(BundleManager bundleManager) {
        return (BundleManager)this.setProperty("resources", bundleManager);
    }

    public String getResource(String string) {
        return this.getBundleManager().getResource(string);
    }

    public String getResource(String string, String string2) {
        return this.getBundleManager().getResource(string, string2);
    }

    public CharBindingMap getCharBindingMap() {
        return (CharBindingMap)this.getProperty("binding.map");
    }

    public CharBindingMap setCharBindingMap(CharBindingMap charBindingMap) {
        return (CharBindingMap)this.setProperty("binding.map", charBindingMap);
    }

    public int getDispatchingModel() {
        return (Integer)this.getProperty("dispatching.model");
    }

    private static DriverInstaller getDriverInstaller(int n) {
        String string = System.getProperty("jemmy.drivers.installer");
        Object object = null;
        try {
            if (string != null && string.length() != 0) {
                object = (DriverInstaller)new ClassReference(string).newInstance(null, null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            JemmyProperties.getCurrentOutput().printLine("Cannot init driver installer:");
            JemmyProperties.getCurrentOutput().printStackTrace(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            JemmyProperties.getCurrentOutput().printLine("Cannot init driver installer:");
            JemmyProperties.getCurrentOutput().printStackTrace(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            JemmyProperties.getCurrentOutput().printLine("Cannot init driver installer:");
            JemmyProperties.getCurrentOutput().printStackTrace(noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            JemmyProperties.getCurrentOutput().printLine("Cannot init driver installer:");
            JemmyProperties.getCurrentOutput().printStackTrace(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            JemmyProperties.getCurrentOutput().printLine("Cannot init driver installer:");
            JemmyProperties.getCurrentOutput().printStackTrace(invocationTargetException);
        }
        if (object == null) {
            object = System.getProperty("os.name").startsWith("Mac OS X") ? new APIDriverInstaller((n & SHORTCUT_MODEL_MASK) != 0) : new DefaultDriverInstaller((n & SHORTCUT_MODEL_MASK) != 0);
        }
        JemmyProperties.getCurrentOutput().printLine("Using " + object.getClass().getName() + " driver installer");
        return object;
    }

    public int setDispatchingModel(int n) {
        new InputDriverInstaller((n & ROBOT_MODEL_MASK) == 0, (n & SMOOTH_ROBOT_MODEL_MASK) != 0).install();
        JemmyProperties.getDriverInstaller(n).install();
        return (Integer)this.setProperty("dispatching.model", new Integer(n));
    }

    public int getDragAndDropStepLength() {
        return (Integer)this.getProperty("drag_and_drop.step_length");
    }

    public int setDragAndDropStepLength(int n) {
        return (Integer)this.setProperty("drag_and_drop.step_length", new Integer(n));
    }

    public boolean contains(String string) {
        return this.properties.containsKey(string);
    }

    public Object setProperty(String string, Object object) {
        Object var3_3 = null;
        if (this.contains(string)) {
            var3_3 = this.properties.get(string);
            this.properties.remove(string);
        }
        this.properties.put(string, object);
        return var3_3;
    }

    public Object getProperty(String string) {
        if (this.contains(string)) {
            return this.properties.get(string);
        }
        return null;
    }

    public Object removeProperty(String string) {
        if (this.contains(string)) {
            return this.properties.remove(string);
        }
        return null;
    }

    public String[] getKeys() {
        Enumeration enumeration = this.properties.keys();
        String[] stringArray = new String[this.properties.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public void copyTo(JemmyProperties jemmyProperties) {
        String[] stringArray = this.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            jemmyProperties.setProperty(stringArray[i], this.getProperty(stringArray[i]));
        }
        jemmyProperties.setTimeouts(this.getTimeouts().cloneThis());
        jemmyProperties.setBundleManager(this.getBundleManager().cloneThis());
    }

    protected JemmyProperties cloneThis() {
        JemmyProperties jemmyProperties = new JemmyProperties();
        this.copyTo(jemmyProperties);
        return jemmyProperties;
    }

    private static String extractValue(InputStream inputStream, String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || !string3.trim().equals(string)) continue;
                return stringTokenizer.nextToken().trim();
            }
            return "";
        }
        catch (IOException iOException) {
            JemmyProperties.getCurrentOutput().printStackTrace(iOException);
            return "";
        }
    }

    static {
        JemmyProperties.setCurrentDispatchingModel(JemmyProperties.getDefaultDispatchingModel());
    }
}

