/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.jemmy.ActionProducer;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.Scenario;
import org.netbeans.jemmy.TestCompletedException;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;

public class Test
extends ActionProducer
implements Timeoutable,
Outputable,
Scenario {
    private static final long WHOLE_TEST_TIMEOUT = 3600000L;
    public static int WRONG_PARAMETERS_STATUS = 101;
    public static int SCENARIO_EXCEPTION_STATUS = 102;
    public static int TEST_PASSED_STATUS = 0;
    protected Timeouts timeouts;
    protected TestOut output;
    private Scenario scenario;
    private static int TEST_FAILED_STATUS = 1;

    public Test(String string) {
        super(true);
        this.setOutput(JemmyProperties.getCurrentOutput());
        this.setTimeouts(JemmyProperties.getCurrentTimeouts());
        this.scenario = this.testForName(string);
    }

    public Test(Scenario scenario) {
        super(true);
        this.setOutput(JemmyProperties.getCurrentOutput());
        this.setTimeouts(JemmyProperties.getCurrentTimeouts());
        this.scenario = scenario;
    }

    protected Test() {
        super(true);
        this.setOutput(JemmyProperties.getCurrentOutput());
        this.setTimeouts(JemmyProperties.getCurrentTimeouts());
    }

    public static void closeDown(int n) {
        if (n == 0) {
            throw new TestCompletedException(n, "Test passed");
        }
        throw new TestCompletedException(n, "Test failed with status " + Integer.toString(n));
    }

    public static int run(String[] stringArray) {
        String[] stringArray2 = stringArray;
        JemmyProperties.getProperties().init();
        if (stringArray.length < 1) {
            JemmyProperties.getCurrentOutput().printErrLine("First element of String array should be test classname");
            return WRONG_PARAMETERS_STATUS;
        }
        JemmyProperties.getCurrentOutput().printLine("Executed test " + stringArray[0]);
        Test test = new Test(stringArray[0]);
        if (stringArray.length >= 1) {
            stringArray2 = Test.shiftArray(stringArray2);
        }
        if (stringArray.length >= 2) {
            JemmyProperties.getCurrentOutput().printLine("Work directory: " + stringArray[1]);
            System.setProperty("user.dir", stringArray[1]);
            stringArray2 = Test.shiftArray(stringArray2);
        }
        int n = TEST_FAILED_STATUS;
        if (test != null) {
            n = test.startTest(stringArray2);
        }
        JemmyProperties.getCurrentOutput().flush();
        return n;
    }

    public static int run(String[] stringArray, PrintStream printStream) {
        JemmyProperties.setCurrentOutput(new TestOut(System.in, printStream, printStream));
        return Test.run(stringArray);
    }

    public static int run(String[] stringArray, PrintStream printStream, PrintStream printStream2) {
        JemmyProperties.setCurrentOutput(new TestOut(System.in, printStream, printStream2));
        return Test.run(stringArray);
    }

    public static int run(String[] stringArray, PrintWriter printWriter) {
        JemmyProperties.setCurrentOutput(new TestOut(System.in, printWriter, printWriter));
        return Test.run(stringArray);
    }

    public static int run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        JemmyProperties.setCurrentOutput(new TestOut(System.in, printWriter, printWriter2));
        return Test.run(stringArray);
    }

    public static void main(String[] stringArray) {
        System.exit(Test.run(stringArray, System.out));
    }

    public Scenario testForName(String string) {
        try {
            return (Scenario)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.output.printErrLine("Class " + string + " does not exist!");
            this.output.printStackTrace(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.output.printErrLine("Class " + string + " has not constructor!");
            this.output.printStackTrace(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.output.printErrLine("Exception inside " + string + " constructor:");
            this.output.printStackTrace(invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.output.printErrLine("Cannot access to " + string + " constructor!");
            this.output.printStackTrace(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            this.output.printErrLine("Cannot instantiate " + string + " class!");
            this.output.printStackTrace(instantiationException);
        }
        return null;
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        Timeouts timeouts2 = timeouts.cloneThis();
        timeouts2.setTimeout("ActionProducer.MaxActionTime", timeouts.getTimeout("Test.WholeTestTimeout"));
        super.setTimeouts(timeouts2);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(testOut);
    }

    public TestOut getOutput() {
        return this.output;
    }

    public int startTest(Object object) {
        if (this.scenario != null) {
            this.output.printLine("Test " + this.scenario.getClass().getName() + " has been started");
        } else {
            this.output.printLine("Test " + this.getClass().getName() + " has been started");
        }
        try {
            return (Integer)this.produceAction(object);
        }
        catch (InterruptedException interruptedException) {
            this.output.printErrLine("Test was interrupted.");
            this.output.printStackTrace(interruptedException);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            this.output.printErrLine("Test was not finished in " + Long.toString(this.timeouts.getTimeout("Test.WholeTestTimeout")) + " milliseconds");
            this.output.printStackTrace(timeoutExpiredException);
        }
        catch (Exception exception) {
            this.output.printStackTrace(exception);
        }
        return 1;
    }

    public final Object launch(Object object) {
        this.setTimeouts(this.timeouts);
        try {
            if (this.scenario != null) {
                Test.closeDown(this.scenario.runIt(object));
            } else {
                Test.closeDown(this.runIt(object));
            }
        }
        catch (TestCompletedException testCompletedException) {
            this.output.printStackTrace(testCompletedException);
            return new Integer(testCompletedException.getStatus());
        }
        catch (Throwable throwable) {
            this.output.printStackTrace(throwable);
            return new Integer(SCENARIO_EXCEPTION_STATUS);
        }
        return new Integer(TEST_PASSED_STATUS);
    }

    public void printSynopsis() {
        this.output.printLine("Here should be a test synopsis.");
    }

    public final String getDescription() {
        return "Test " + this.scenario.getClass().getName() + " finished";
    }

    public int runIt(Object object) {
        return 0;
    }

    protected void doSleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String[] shiftArray(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length - 1];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i + 1];
        }
        return stringArray2;
    }

    static {
        Timeouts.initDefault("Test.WholeTestTimeout", 3600000L);
    }
}

