/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.demo;

import org.netbeans.jemmy.EventDispatcher;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.demo.CommentWindow;
import org.netbeans.jemmy.demo.DefaultCommentWindow;
import org.netbeans.jemmy.demo.DemoInterruptedException;

public class Demonstrator {
    private static CommentWindow displayer;
    private static CommentWindow nonDisplayer;

    public static void setTitle(String string) {
        displayer.setTitle(string);
    }

    public static void setCommentWindow(CommentWindow commentWindow) {
        displayer = commentWindow;
    }

    public static void nextStep(String string) {
        Demonstrator.getDisplayer().nextStep(string);
        while (Demonstrator.getDisplayer().isStopped()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (Demonstrator.getDisplayer() != nonDisplayer) {
            try {
                EventDispatcher.waitQueueEmpty(TestOut.getNullOutput(), JemmyProperties.getCurrentTimeouts());
            }
            catch (TimeoutExpiredException timeoutExpiredException) {
                timeoutExpiredException.printStackTrace();
            }
        }
        if (Demonstrator.getDisplayer().isInterrupted()) {
            Demonstrator.getDisplayer().close();
            throw new DemoInterruptedException(Demonstrator.getDisplayer().getInterruptMessage());
        }
    }

    public static void showFinalComment(String string) {
        Demonstrator.getDisplayer().showFinalComment(string);
        while (Demonstrator.getDisplayer().isStopped()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Demonstrator.getDisplayer().close();
        if (Demonstrator.getDisplayer() != nonDisplayer) {
            try {
                EventDispatcher.waitQueueEmpty(TestOut.getNullOutput(), JemmyProperties.getCurrentTimeouts());
            }
            catch (TimeoutExpiredException timeoutExpiredException) {
                timeoutExpiredException.printStackTrace();
            }
        }
    }

    private static CommentWindow getDisplayer() {
        if (System.getProperty("jemmy.demo") != null && System.getProperty("jemmy.demo").equals("on")) {
            return displayer;
        }
        return nonDisplayer;
    }

    static {
        Demonstrator.setCommentWindow(new DefaultCommentWindow());
        Demonstrator.setTitle("Step comments");
        nonDisplayer = new NonWindow();
    }

    private static class NonWindow
    implements CommentWindow {
        private NonWindow() {
        }

        public void setTitle(String string) {
        }

        public boolean isStopped() {
            return false;
        }

        public void nextStep(String string) {
            JemmyProperties.getCurrentOutput().printLine("Step comments:\n" + string);
        }

        public void showFinalComment(String string) {
            JemmyProperties.getCurrentOutput().printLine("Final comments:\n" + string);
        }

        public boolean isInterrupted() {
            return false;
        }

        public String getInterruptMessage() {
            return "";
        }

        public void close() {
        }
    }
}

