/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.scrolling;

import java.awt.Point;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.scrolling.AbstractScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JScrollBarOperator;

public class JScrollBarAPIDriver
extends AbstractScrollDriver {
    private static final int SMALL_INCREMENT = 1;
    private static final int MINIMAL_DRAGGER_SIZE = 5;
    private static final int RELATIVE_DRAG_STEP_LENGTH = 20;
    private QueueTool queueTool = new QueueTool();

    public JScrollBarAPIDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JScrollBarOperator"});
    }

    public void scrollToMinimum(ComponentOperator componentOperator, int n) {
        JScrollBarOperator jScrollBarOperator = (JScrollBarOperator)componentOperator;
        this.setValue(componentOperator, jScrollBarOperator.getMinimum());
    }

    public void scrollToMaximum(ComponentOperator componentOperator, int n) {
        JScrollBarOperator jScrollBarOperator = (JScrollBarOperator)componentOperator;
        this.setValue(componentOperator, jScrollBarOperator.getMaximum() - jScrollBarOperator.getVisibleAmount());
    }

    protected void step(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
        JScrollBarOperator jScrollBarOperator = (JScrollBarOperator)componentOperator;
        int n = -1;
        if (scrollAdjuster.getScrollDirection() == -1) {
            n = jScrollBarOperator.getValue() > jScrollBarOperator.getMinimum() + jScrollBarOperator.getUnitIncrement() ? jScrollBarOperator.getValue() - jScrollBarOperator.getUnitIncrement() : jScrollBarOperator.getMinimum();
        } else if (scrollAdjuster.getScrollDirection() == 1) {
            n = jScrollBarOperator.getValue() < jScrollBarOperator.getMaximum() - jScrollBarOperator.getVisibleAmount() - jScrollBarOperator.getUnitIncrement() ? jScrollBarOperator.getValue() + jScrollBarOperator.getUnitIncrement() : jScrollBarOperator.getMaximum();
        }
        this.setValue(componentOperator, n);
    }

    private void setValue(ComponentOperator componentOperator, int n) {
        if (n != -1) {
            ((JScrollBarOperator)componentOperator).setValue(n);
        }
    }

    protected Timeout getScrollDeltaTimeout(ComponentOperator componentOperator) {
        return componentOperator.getTimeouts().create("JScrollBarOperator.DragAndDropScrollingDelta");
    }

    protected void jump(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
        JScrollBarOperator jScrollBarOperator = (JScrollBarOperator)componentOperator;
        int n = -1;
        if (scrollAdjuster.getScrollDirection() == -1) {
            n = jScrollBarOperator.getValue() > jScrollBarOperator.getMinimum() + jScrollBarOperator.getBlockIncrement() ? jScrollBarOperator.getValue() - jScrollBarOperator.getBlockIncrement() : jScrollBarOperator.getMinimum();
        } else if (scrollAdjuster.getScrollDirection() == 1) {
            n = jScrollBarOperator.getValue() < jScrollBarOperator.getMaximum() - jScrollBarOperator.getVisibleAmount() - jScrollBarOperator.getBlockIncrement() ? jScrollBarOperator.getValue() + jScrollBarOperator.getBlockIncrement() : jScrollBarOperator.getMaximum();
        }
        this.setValue(componentOperator, n);
    }

    protected void startPushAndWait(ComponentOperator componentOperator, int n, int n2) {
    }

    protected void stopPushAndWait(ComponentOperator componentOperator, int n, int n2) {
    }

    protected Point startDragging(ComponentOperator componentOperator) {
        return null;
    }

    protected void drop(ComponentOperator componentOperator, Point point) {
    }

    protected void drag(ComponentOperator componentOperator, Point point) {
    }

    protected boolean canDragAndDrop(ComponentOperator componentOperator) {
        return false;
    }

    protected boolean canJump(ComponentOperator componentOperator) {
        return this.isSmallIncrement((JScrollBarOperator)componentOperator);
    }

    protected boolean canPushAndWait(ComponentOperator componentOperator) {
        return false;
    }

    protected int getDragAndDropStepLength(ComponentOperator componentOperator) {
        return 1;
    }

    private boolean isSmallIncrement(JScrollBarOperator jScrollBarOperator) {
        return jScrollBarOperator.getUnitIncrement(-1) <= 1 && jScrollBarOperator.getUnitIncrement(1) <= 1;
    }
}

