/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.scrolling;

import java.awt.Point;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.MouseDriver;
import org.netbeans.jemmy.drivers.scrolling.AbstractScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JSliderOperator;
import org.netbeans.jemmy.operators.Operator;

public class JSliderDriver
extends AbstractScrollDriver {
    private QueueTool queueTool = new QueueTool();

    public JSliderDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JSliderOperator"});
    }

    public void scrollToMinimum(final ComponentOperator componentOperator, int n) {
        this.checkSupported(componentOperator);
        this.scroll(componentOperator, new ScrollAdjuster(){

            public int getScrollDirection() {
                return ((JSliderOperator)componentOperator).getMinimum() < ((JSliderOperator)componentOperator).getValue() ? -1 : 0;
            }

            public int getScrollOrientation() {
                return ((JSliderOperator)componentOperator).getOrientation();
            }

            public String getDescription() {
                return "Scroll to minimum";
            }
        });
    }

    public void scrollToMaximum(final ComponentOperator componentOperator, int n) {
        this.checkSupported(componentOperator);
        this.scroll(componentOperator, new ScrollAdjuster(){

            public int getScrollDirection() {
                return ((JSliderOperator)componentOperator).getMaximum() > ((JSliderOperator)componentOperator).getValue() ? 1 : 0;
            }

            public int getScrollOrientation() {
                return ((JSliderOperator)componentOperator).getOrientation();
            }

            public String getDescription() {
                return "Scroll to maximum";
            }
        });
    }

    protected void step(final ComponentOperator componentOperator, final ScrollAdjuster scrollAdjuster) {
        if (scrollAdjuster.getScrollDirection() != 0) {
            this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Choise expanding"){

                public Object launch() {
                    Point point = JSliderDriver.this.getClickPoint(componentOperator, scrollAdjuster.getScrollDirection(), scrollAdjuster.getScrollOrientation());
                    if (point != null) {
                        DriverManager.getMouseDriver(componentOperator).clickMouse(componentOperator, point.x, point.y, 1, Operator.getDefaultMouseButton(), 0, componentOperator.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
                    }
                    return null;
                }
            });
        }
    }

    protected void jump(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
    }

    protected void startPushAndWait(final ComponentOperator componentOperator, final int n, final int n2) {
        this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Start scrolling"){

            public Object launch() {
                Point point = JSliderDriver.this.getClickPoint(componentOperator, n, n2);
                if (point != null) {
                    MouseDriver mouseDriver = DriverManager.getMouseDriver(componentOperator);
                    mouseDriver.moveMouse(componentOperator, point.x, point.y);
                    mouseDriver.pressMouse(componentOperator, point.x, point.y, Operator.getDefaultMouseButton(), 0);
                }
                return null;
            }
        });
    }

    protected void stopPushAndWait(final ComponentOperator componentOperator, final int n, final int n2) {
        this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Stop scrolling"){

            public Object launch() {
                Point point = JSliderDriver.this.getClickPoint(componentOperator, n, n2);
                if (point != null) {
                    MouseDriver mouseDriver = DriverManager.getMouseDriver(componentOperator);
                    mouseDriver.releaseMouse(componentOperator, point.x, point.y, Operator.getDefaultMouseButton(), 0);
                }
                return null;
            }
        });
    }

    protected Point startDragging(ComponentOperator componentOperator) {
        return null;
    }

    protected void drop(ComponentOperator componentOperator, Point point) {
    }

    protected void drag(ComponentOperator componentOperator, Point point) {
    }

    protected Timeout getScrollDeltaTimeout(ComponentOperator componentOperator) {
        return componentOperator.getTimeouts().create("JSliderOperator.ScrollingDelta");
    }

    protected boolean canDragAndDrop(ComponentOperator componentOperator) {
        return false;
    }

    protected boolean canJump(ComponentOperator componentOperator) {
        return false;
    }

    protected boolean canPushAndWait(ComponentOperator componentOperator) {
        return true;
    }

    protected int getDragAndDropStepLength(ComponentOperator componentOperator) {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Point getClickPoint(ComponentOperator componentOperator, int n, int n2) {
        int n3;
        int n4;
        boolean bl = ((JSliderOperator)componentOperator).getInverted();
        int n5 = 0;
        if (bl) {
            if (n == 1) {
                n5 = -1;
            } else {
                if (n != -1) return null;
                n5 = 1;
            }
        } else {
            n5 = n;
        }
        if (n2 == 0) {
            if (n5 == 1) {
                n4 = componentOperator.getWidth() - 1;
            } else {
                if (n5 != -1) return null;
                n4 = 0;
            }
            n3 = componentOperator.getHeight() / 2;
            return new Point(n4, n3);
        } else {
            if (n2 != 1) return null;
            if (n5 == 1) {
                n3 = 0;
            } else {
                if (n5 != -1) return null;
                n3 = componentOperator.getHeight() - 1;
            }
            n4 = componentOperator.getWidth() / 2;
        }
        return new Point(n4, n3);
    }
}

