/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.text;

import org.netbeans.jemmy.CharBindingMap;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.KeyDriver;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.TextDriver;
import org.netbeans.jemmy.drivers.text.GoAndBackKey;
import org.netbeans.jemmy.drivers.text.NavigationKey;
import org.netbeans.jemmy.drivers.text.OffsetKey;
import org.netbeans.jemmy.operators.ComponentOperator;

public abstract class TextKeyboardDriver
extends LightSupportiveDriver
implements TextDriver {
    public TextKeyboardDriver(String[] stringArray) {
        super(stringArray);
    }

    public void changeCaretPosition(ComponentOperator componentOperator, int n) {
        DriverManager.getFocusDriver(componentOperator).giveFocus(componentOperator);
        this.checkSupported(componentOperator);
        this.changeCaretPosition(componentOperator, n, 0);
    }

    public void selectText(ComponentOperator componentOperator, int n, int n2) {
        this.changeCaretPosition(componentOperator, n);
        DriverManager.getKeyDriver(componentOperator).pressKey(componentOperator, 16, 0);
        this.changeCaretPosition(componentOperator, n2, 1);
        DriverManager.getKeyDriver(componentOperator).releaseKey(componentOperator, 16, 0);
    }

    public void clearText(ComponentOperator componentOperator) {
        DriverManager.getFocusDriver(componentOperator).giveFocus(componentOperator);
        this.checkSupported(componentOperator);
        KeyDriver keyDriver = DriverManager.getKeyDriver(componentOperator);
        Timeout timeout = componentOperator.getTimeouts().create("ComponentOperator.PushKeyTimeout");
        Timeout timeout2 = this.getBetweenTimeout(componentOperator);
        while (this.getCaretPosition(componentOperator) > 0) {
            keyDriver.typeKey(componentOperator, 8, '\b', 0, timeout);
            timeout2.sleep();
        }
        while (this.getText(componentOperator).length() > 0) {
            keyDriver.pushKey(componentOperator, 127, 0, timeout);
            timeout2.sleep();
        }
    }

    public void typeText(ComponentOperator componentOperator, String string, int n) {
        this.changeCaretPosition(componentOperator, n);
        KeyDriver keyDriver = DriverManager.getKeyDriver(componentOperator);
        CharBindingMap charBindingMap = componentOperator.getCharBindingMap();
        Timeout timeout = componentOperator.getTimeouts().create("ComponentOperator.PushKeyTimeout");
        Timeout timeout2 = this.getBetweenTimeout(componentOperator);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            keyDriver.typeKey(componentOperator, charBindingMap.getCharKey(cArray[i]), cArray[i], charBindingMap.getCharModifiers(cArray[i]), timeout);
            timeout2.sleep();
        }
    }

    public void changeText(ComponentOperator componentOperator, String string) {
        this.clearText(componentOperator);
        this.typeText(componentOperator, string, 0);
    }

    public void enterText(ComponentOperator componentOperator, String string) {
        this.changeText(componentOperator, string);
        DriverManager.getKeyDriver(componentOperator).pushKey(componentOperator, 10, 0, new Timeout("", 0L));
    }

    public abstract String getText(ComponentOperator var1);

    public abstract int getCaretPosition(ComponentOperator var1);

    public abstract int getSelectionStart(ComponentOperator var1);

    public abstract int getSelectionEnd(ComponentOperator var1);

    public abstract NavigationKey[] getKeys(ComponentOperator var1);

    public abstract Timeout getBetweenTimeout(ComponentOperator var1);

    protected void changeCaretPosition(ComponentOperator componentOperator, int n, int n2) {
        NavigationKey[] navigationKeyArray = this.getKeys(componentOperator);
        for (int i = navigationKeyArray.length - 1; i >= 0; --i) {
            if (navigationKeyArray[i] instanceof OffsetKey) {
                this.moveCaret(componentOperator, (OffsetKey)navigationKeyArray[i], n, n2);
                continue;
            }
            this.moveCaret(componentOperator, (GoAndBackKey)navigationKeyArray[i], n, n2);
        }
    }

    private int difference(int n, int n2) {
        if (n >= n2) {
            return n - n2;
        }
        return n2 - n;
    }

    private void push(ComponentOperator componentOperator, NavigationKey navigationKey, int n) {
        DriverManager.getKeyDriver(componentOperator).pushKey(componentOperator, navigationKey.getKeyCode(), navigationKey.getModifiers() | n, componentOperator.getTimeouts().create("ComponentOperator.PushKeyTimeout"));
        this.getBetweenTimeout(componentOperator).sleep();
    }

    private final void moveCaret(ComponentOperator componentOperator, GoAndBackKey goAndBackKey, int n, int n2) {
        int n3;
        int n4 = n3 = this.difference(n, this.getCaretPosition(componentOperator));
        QueueTool queueTool = new QueueTool();
        queueTool.setOutput(componentOperator.getOutput().createErrorOutput());
        while (goAndBackKey.getDirection() * (n - this.getCaretPosition(componentOperator)) > 0) {
            n4 = n3;
            this.push(componentOperator, goAndBackKey, n2);
            queueTool.waitEmpty();
            n3 = this.difference(n, this.getCaretPosition(componentOperator));
            if (n3 != n4) continue;
            return;
        }
        if (n3 > n4) {
            this.push(componentOperator, goAndBackKey.getBackKey(), n2);
        }
    }

    private final void moveCaret(ComponentOperator componentOperator, OffsetKey offsetKey, int n, int n2) {
        if (this.gotToGo(componentOperator, n, offsetKey.getExpectedPosition())) {
            this.push(componentOperator, offsetKey, n2);
        }
    }

    private boolean gotToGo(ComponentOperator componentOperator, int n, int n2) {
        return this.difference(n, n2) < this.difference(n, this.getCaretPosition(componentOperator));
    }
}

