/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.explorer;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.explorer.TrialListenerManager;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.Dumper;

public class GUIBrowser
extends JFrame {
    private static String WINDOWS_TAB = "Subwindows";
    private static String COMPONENTS_TAB = "Hierarchy";
    private static String PROPERTIES_TAB = "Properties";
    private static String REFLECTION_TAB = "Reflection";
    private static String EVENT_TAB = "Events";
    private static String IMAGE_TAB = "Image";
    boolean exit;
    PropertyDialog propDialog;
    RootNode root;
    QueueTool qt;
    JTextField refreshDelay;
    JTree mainTree;
    JLabel status;
    JButton viewButton;
    JButton expandButton;
    JSplitPane split;
    ByteArrayOutputStream dumpData = new ByteArrayOutputStream();
    PrintWriter dumpWriter = new PrintWriter(new OutputStreamWriter(this.dumpData));
    boolean shown = false;

    private GUIBrowser(boolean bl) {
        super("GUI Browser");
        this.exit = bl;
        this.propDialog = new PropertyDialog(this);
        this.qt = new QueueTool();
        this.qt.setOutput(TestOut.getNullOutput());
        this.root = new RootNode();
        this.mainTree = new JTree(this.root.getWindowModel());
        this.mainTree.setCellRenderer(new WindowRenderer());
        this.mainTree.setEditable(false);
        this.refreshDelay = new JTextField(3);
        this.refreshDelay.setText("0");
        this.viewButton = new JButton("View");
        this.viewButton.setEnabled(false);
        this.viewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new ComponentBrowser(GUIBrowser.this.getOwnr(), (ClassNode)((ComponentNode)GUIBrowser.this.mainTree.getSelectionPath().getLastPathComponent())).show();
            }
        });
        this.expandButton = new JButton("Expand All");
        this.expandButton.setEnabled(false);
        this.expandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIBrowser.this.expandAll(GUIBrowser.this.mainTree, GUIBrowser.this.mainTree.getSelectionPath());
            }
        });
        JButton jButton = new JButton("Reload in ...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIBrowser.this.reload(new Integer(GUIBrowser.this.refreshDelay.getText()));
            }
        });
        JButton jButton2 = new JButton("Dump");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.home"));
                jFileChooser.addChoosableFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.getName().endsWith(".xml");
                    }

                    public String getDescription() {
                        return "xml files";
                    }
                });
                jFileChooser.showSaveDialog(GUIBrowser.this);
                try {
                    File file = jFileChooser.getSelectedFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ((OutputStream)fileOutputStream).write(GUIBrowser.this.dumpData.toByteArray());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.viewButton);
        jPanel.add(this.expandButton);
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel(""));
        jPanel.add(jButton);
        jPanel.add(this.refreshDelay);
        jPanel.add(new JLabel("seconds     "));
        jPanel.add(jButton2);
        this.split = this.createUnderPane(this.mainTree);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "South");
        jPanel2.add((Component)this.split, "Center");
        this.split.setDividerLocation(0.8);
        this.status = new JLabel("Reloaded");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.status, "Center");
        jPanel3.setBorder(new BevelBorder(1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel3, "North");
        jPanel4.add((Component)jPanel3, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel4, "South");
        this.getContentPane().add((Component)jPanel2, "Center");
        Component[] componentArray = new Component[]{this.viewButton, this.expandButton};
        this.mainTree.addTreeSelectionListener(new SelectionManager(componentArray));
        this.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent windowEvent) {
            }

            public void windowClosed(WindowEvent windowEvent) {
                GUIBrowser.this.setVisible(false);
                if (GUIBrowser.this.exit) {
                    System.exit(0);
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
            }

            public void windowDeactivated(WindowEvent windowEvent) {
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                GUIBrowser.this.split.setDividerLocation(0.8);
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        this.setSize(800, 400);
    }

    public void show() {
        super.show();
        this.viewButton.setEnabled(false);
        if (!this.shown) {
            this.split.setDividerLocation(0.8);
            this.shown = true;
        }
    }

    public void setStatus(String string) {
        this.status.setText(string);
    }

    public static void showBrowser() {
        GUIBrowser.showBrowser(new String[0], false);
    }

    public static void main(String[] stringArray) {
        GUIBrowser.showBrowser(stringArray, true);
    }

    private static void showBrowser(String[] stringArray, boolean bl) {
        if (stringArray.length >= 1) {
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray2[i - 1] = stringArray[i];
            }
            try {
                new ClassReference(stringArray[0]).startApplication(stringArray2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        new GUIBrowser(bl).show();
    }

    private void reload(final int n) {
        this.viewButton.setEnabled(false);
        this.expandButton.setEnabled(false);
        new Thread(new Runnable(){

            public void run() {
                try {
                    for (int i = n - 1; i >= 0; --i) {
                        GUIBrowser.this.setStatus("Reloading after " + Integer.toString(i) + " second");
                        Thread.sleep(1000L);
                    }
                    GUIBrowser.this.setStatus("Reloading ...");
                    Dumper.dumpAll(GUIBrowser.this.dumpWriter);
                    GUIBrowser.this.qt.lock();
                    GUIBrowser.this.root = new RootNode();
                    GUIBrowser.this.qt.unlock();
                    GUIBrowser.this.mainTree.setModel(GUIBrowser.this.root.getWindowModel());
                    GUIBrowser.this.setStatus("Reloaded");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }).start();
    }

    private JFrame getOwnr() {
        return this;
    }

    private void expandAll(JTree jTree, TreePath treePath) {
        jTree.expandPath(treePath);
        TreeModel treeModel = jTree.getModel();
        Object object = treePath.getLastPathComponent();
        for (int i = 0; i < treeModel.getChildCount(object); ++i) {
            this.expandAll(jTree, treePath.pathByAddingChild(treeModel.getChild(object, i)));
        }
    }

    private JSplitPane createUnderPane(JTree jTree) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTree.addTreeSelectionListener(new ToStringListener(jTextArea));
        JSplitPane jSplitPane = new JSplitPane(0, new JScrollPane(jTree), new JScrollPane(jTextArea));
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerSize(8);
        jSplitPane.setDividerLocation(0.8);
        return jSplitPane;
    }

    private class ComponentImageProvider {
        BufferedImage image;
        int x;
        int y;

        public ComponentImageProvider(BufferedImage bufferedImage, int n, int n2) {
            this.image = bufferedImage;
            this.x = n;
            this.y = n2;
        }

        public BufferedImage getImage(int n, int n2, int n3, int n4) {
            return this.image.getSubimage(n - this.x, n2 - this.y, n3, n4);
        }
    }

    private class ImagePane
    extends JPanel {
        BufferedImage image;

        public ImagePane(BufferedImage bufferedImage) {
            this.image = bufferedImage;
            this.setPreferredSize(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()));
        }

        public void paint(Graphics graphics) {
            graphics.drawImage(this.image, 0, 0, null);
        }
    }

    private class ListListener
    extends TrialListenerManager {
        DefaultListModel model;

        public ListListener(DefaultListModel defaultListModel, Component component) {
            super(component);
            this.model = defaultListModel;
        }

        void printEvent(AWTEvent aWTEvent) {
            this.model.addElement(aWTEvent);
        }
    }

    private class MyModel
    extends DefaultTableModel {
        public MyModel(Hashtable hashtable) {
            Object[] objectArray = hashtable.keySet().toArray();
            if (objectArray.length > 0) {
                this.addColumn("Name");
                this.addColumn("Value");
                this.setNumRows(objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    this.setValueAt(objectArray[i].toString(), i, 0);
                    this.setValueAt(hashtable.get(objectArray[i]).toString(), i, 1);
                }
                String[] stringArray = new String[]{"Name", "Value"};
                Collections.sort(this.getDataVector(), new Comparator(){

                    public int compare(Object object, Object object2) {
                        return ((Vector)object).get(0).toString().compareTo(((Vector)object2).get(0).toString());
                    }

                    public boolean equals(Object object) {
                        return false;
                    }
                });
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private class ToStringListener
    implements TreeSelectionListener {
        JTextArea area;

        public ToStringListener(JTextArea jTextArea) {
            this.area = jTextArea;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (treeSelectionEvent.getPath() != null && treeSelectionEvent.getPath().getLastPathComponent() instanceof ComponentNode) {
                this.area.setText("toString(): " + ((ComponentNode)treeSelectionEvent.getPath().getLastPathComponent()).getToString());
            } else {
                this.area.setText("");
            }
        }
    }

    private class SelectionManager
    implements TreeSelectionListener,
    ListSelectionListener {
        Component[] comps;

        public SelectionManager(Component[] componentArray) {
            this.comps = componentArray;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            for (int i = 0; i < this.comps.length; ++i) {
                this.comps[i].setEnabled(treeSelectionEvent.getPath() != null);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            for (int i = 0; i < this.comps.length; ++i) {
                this.comps[i].setEnabled(listSelectionEvent.getFirstIndex() != -1);
            }
        }
    }

    private class ComponentBrowser
    extends JFrame {
        JTree winTree;
        JTree componentTree;
        JTree methodTree;
        ClassNode compNode;
        JTabbedPane tbd;
        JList fList;
        JButton viewButton;
        JButton expandButton;
        JSplitPane winSplit;
        JSplitPane componentSplit;
        WindowRenderer renderer;
        SelectionManager selManager;
        JList eventList;
        ListListener listListener;
        DefaultListModel eventModel;
        JCheckBox mouseEvents;
        JCheckBox mouseMotionEvents;
        JCheckBox keyEvents;

        public ComponentBrowser(JFrame jFrame, ClassNode classNode) {
            super("Component " + classNode.toString());
            this.winSplit = null;
            this.componentSplit = null;
            this.fill(classNode);
        }

        public ComponentBrowser(JDialog jDialog, ClassNode classNode) {
            super("Component " + classNode.toString());
            this.winSplit = null;
            this.componentSplit = null;
            this.fill(classNode);
        }

        private void fill(ClassNode classNode) {
            this.compNode = classNode;
            this.viewButton = new JButton("View");
            this.viewButton.setEnabled(false);
            this.viewButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new ComponentBrowser(ComponentBrowser.this.getOwnr(), ComponentBrowser.this.getSelectedNode()).show();
                }
            });
            this.expandButton = new JButton("Expand All");
            this.expandButton.setEnabled(false);
            this.expandButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GUIBrowser.this.expandAll(ComponentBrowser.this.getSelectedTree(), ComponentBrowser.this.getSelectionPath());
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(this.viewButton);
            jPanel.add(this.expandButton);
            Component[] componentArray = new Component[]{this.viewButton, this.expandButton};
            this.selManager = new SelectionManager(componentArray);
            this.renderer = new WindowRenderer();
            this.tbd = new JTabbedPane();
            for (int i = 0; i < GUIBrowser.this.propDialog.viewTabs.size(); ++i) {
                String string = (String)GUIBrowser.this.propDialog.viewTabs.elementAt(i);
                if (string.equals(PROPERTIES_TAB)) {
                    this.addPropertiesTab();
                    continue;
                }
                if (string.equals(WINDOWS_TAB)) {
                    this.addWindowTab();
                    continue;
                }
                if (string.equals(COMPONENTS_TAB)) {
                    this.addComponentTab();
                    continue;
                }
                if (string.equals(REFLECTION_TAB)) {
                    this.addReflectionTab();
                    continue;
                }
                if (string.equals(EVENT_TAB)) {
                    this.addEventTab();
                    continue;
                }
                if (!string.equals(IMAGE_TAB)) continue;
                this.addImageTab();
            }
            this.tbd.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    ComponentBrowser.this.viewButton.setEnabled(ComponentBrowser.this.getSelectedNode() != null);
                }
            });
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)jPanel, "South");
            this.getContentPane().add((Component)this.tbd, "Center");
            this.addComponentListener(new ComponentListener(){

                public void componentHidden(ComponentEvent componentEvent) {
                }

                public void componentMoved(ComponentEvent componentEvent) {
                }

                public void componentResized(ComponentEvent componentEvent) {
                    if (ComponentBrowser.this.winSplit != null) {
                        ComponentBrowser.this.winSplit.setDividerLocation(0.8);
                    }
                    if (ComponentBrowser.this.componentSplit != null) {
                        ComponentBrowser.this.componentSplit.setDividerLocation(0.8);
                    }
                }

                public void componentShown(ComponentEvent componentEvent) {
                }
            });
            this.setSize(800, 400);
        }

        private void addImageTab() {
            BufferedImage bufferedImage = null;
            if (this.compNode instanceof ComponentNode) {
                bufferedImage = ((ComponentNode)this.compNode).getImage();
            }
            if (bufferedImage != null) {
                ImagePane imagePane = new ImagePane(bufferedImage);
                imagePane.prepareImage(bufferedImage, imagePane);
                JScrollPane jScrollPane = new JScrollPane(imagePane);
                this.tbd.add(IMAGE_TAB, jScrollPane);
            }
        }

        private void addWindowTab() {
            if (this.compNode instanceof WindowNode && ((WindowNode)this.compNode).getWindows().length > 0) {
                this.winTree = new JTree(((WindowNode)this.compNode).getWindowModel());
                this.winTree.setCellRenderer(this.renderer);
                this.winTree.setEditable(false);
                this.winTree.addTreeSelectionListener(this.selManager);
                this.winSplit = GUIBrowser.this.createUnderPane(this.winTree);
                this.tbd.add(WINDOWS_TAB, this.winSplit);
            }
        }

        private void addComponentTab() {
            if (this.compNode instanceof ContainerNode && ((ContainerNode)this.compNode).getComponents().length > 0) {
                this.componentTree = new JTree(((ContainerNode)this.compNode).getComponentModel());
                this.componentTree.setCellRenderer(this.renderer);
                this.componentTree.setEditable(false);
                this.componentTree.addTreeSelectionListener(this.selManager);
                this.componentSplit = GUIBrowser.this.createUnderPane(this.componentTree);
                this.tbd.add(COMPONENTS_TAB, this.componentSplit);
            }
        }

        private void addReflectionTab() {
            this.methodTree = new JTree(this.compNode.getMethodsModel());
            this.methodTree.setCellRenderer(this.renderer);
            this.methodTree.setEditable(false);
            this.methodTree.addTreeSelectionListener(this.selManager);
            this.tbd.add(REFLECTION_TAB, new JScrollPane(this.methodTree));
        }

        private void addPropertiesTab() {
            Hashtable hashtable;
            if (this.compNode instanceof ComponentNode && (hashtable = ((ContainerNode)this.compNode).getProperties()).size() > 0) {
                JTable jTable = new JTable(new MyModel(hashtable));
                jTable.setAutoResizeMode(3);
                this.tbd.add(PROPERTIES_TAB, new JScrollPane(jTable));
            }
        }

        private void addEventTab() {
            if (this.compNode instanceof ComponentNode) {
                this.eventModel = new DefaultListModel();
                this.eventList = new JList(this.eventModel);
                this.listListener = new ListListener(this.eventModel, ((ComponentNode)this.compNode).comp);
                this.mouseEvents = new JCheckBox("Mouse events");
                this.mouseEvents.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ComponentBrowser.this.mouseEvents.isSelected()) {
                            ComponentBrowser.this.listListener.addMouseListener();
                        } else {
                            ComponentBrowser.this.listListener.removeMouseListener();
                        }
                    }
                });
                this.mouseMotionEvents = new JCheckBox("Mouse motion events");
                this.mouseMotionEvents.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ComponentBrowser.this.mouseMotionEvents.isSelected()) {
                            ComponentBrowser.this.listListener.addMouseMotionListener();
                        } else {
                            ComponentBrowser.this.listListener.removeMouseMotionListener();
                        }
                    }
                });
                this.keyEvents = new JCheckBox("Key events");
                this.keyEvents.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ComponentBrowser.this.keyEvents.isSelected()) {
                            ComponentBrowser.this.listListener.addKeyListener();
                        } else {
                            ComponentBrowser.this.listListener.removeKeyListener();
                        }
                    }
                });
                JButton jButton = new JButton("Clear list");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ComponentBrowser.this.eventModel.removeAllElements();
                    }
                });
                JPanel jPanel = new JPanel();
                jPanel.add(this.mouseEvents);
                jPanel.add(this.mouseMotionEvents);
                jPanel.add(this.keyEvents);
                jPanel.add(jButton);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BorderLayout());
                jPanel2.add((Component)jPanel, "South");
                jPanel2.add((Component)new JScrollPane(this.eventList), "Center");
                this.tbd.add(EVENT_TAB, jPanel2);
            }
        }

        private JFrame getOwnr() {
            return this;
        }

        private JTree getSelectedTree() {
            String string = this.tbd.getTitleAt(this.tbd.getSelectedIndex());
            if (string.equals(WINDOWS_TAB)) {
                return this.winTree;
            }
            if (string.equals(COMPONENTS_TAB)) {
                return this.componentTree;
            }
            if (string.equals(REFLECTION_TAB)) {
                return this.methodTree;
            }
            return null;
        }

        private TreePath getSelectionPath() {
            JTree jTree = this.getSelectedTree();
            if (jTree != null) {
                return jTree.getSelectionPath();
            }
            return null;
        }

        private ClassNode getSelectedNode() {
            TreePath treePath = this.getSelectionPath();
            if (treePath != null) {
                return (ClassNode)treePath.getLastPathComponent();
            }
            return null;
        }
    }

    private class PropertyDialog
    extends JDialog {
        public boolean showAll;
        JComboBox visibleCombo;
        JCheckBox showToString;
        JCheckBox showReflection;
        JCheckBox showEvents;
        DefaultListModel viewTabs;
        JList orderList;
        JButton up;
        JButton down;
        Properties props;
        File propFile;

        public PropertyDialog(JFrame jFrame) {
            super(jFrame, "Properties", true);
            this.showAll = false;
            this.propFile = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".guibrowser");
            this.props = new Properties();
            String[] stringArray = new String[]{"Showing", "All"};
            this.visibleCombo = new JComboBox<String>(stringArray);
            this.visibleCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyDialog.this.showAll = PropertyDialog.this.visibleCombo.getSelectedIndex() == 1;
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Show "));
            jPanel.add(this.visibleCombo);
            this.showToString = new JCheckBox("Show toString() method result");
            this.showToString.setSelected(true);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jPanel);
            this.viewTabs = new DefaultListModel();
            this.viewTabs.addElement(WINDOWS_TAB);
            this.viewTabs.addElement(COMPONENTS_TAB);
            this.viewTabs.addElement(PROPERTIES_TAB);
            this.viewTabs.addElement(REFLECTION_TAB);
            this.viewTabs.addElement(IMAGE_TAB);
            this.orderList = new JList(this.viewTabs);
            this.orderList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    PropertyDialog.this.up.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                    PropertyDialog.this.down.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                }
            });
            this.showReflection = new JCheckBox("Show reflection tab");
            this.showReflection.setSelected(true);
            this.showReflection.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (PropertyDialog.this.showReflection.isSelected()) {
                        PropertyDialog.this.viewTabs.addElement(REFLECTION_TAB);
                    } else {
                        PropertyDialog.this.viewTabs.remove(PropertyDialog.this.viewTabs.indexOf(REFLECTION_TAB));
                    }
                    PropertyDialog.this.up.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                    PropertyDialog.this.down.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                }
            });
            this.showEvents = new JCheckBox("Show event tab");
            this.showEvents.setSelected(true);
            this.showEvents.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (PropertyDialog.this.showEvents.isSelected()) {
                        PropertyDialog.this.viewTabs.addElement(EVENT_TAB);
                    } else {
                        PropertyDialog.this.viewTabs.remove(PropertyDialog.this.viewTabs.indexOf(EVENT_TAB));
                    }
                    PropertyDialog.this.up.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                    PropertyDialog.this.down.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                }
            });
            this.up = new JButton("Move Up");
            this.up.setEnabled(false);
            this.up.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = PropertyDialog.this.orderList.getSelectedIndex();
                    if (n > 0) {
                        PropertyDialog.this.viewTabs.add(n - 1, PropertyDialog.this.viewTabs.remove(n));
                        PropertyDialog.this.orderList.setSelectedIndex(n - 1);
                    }
                }
            });
            this.down = new JButton("Move Down");
            this.down.setEnabled(false);
            this.down.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = PropertyDialog.this.orderList.getSelectedIndex();
                    if (n < PropertyDialog.this.viewTabs.size() - 1) {
                        PropertyDialog.this.viewTabs.add(n + 1, PropertyDialog.this.viewTabs.remove(n));
                        PropertyDialog.this.orderList.setSelectedIndex(n + 1);
                    }
                }
            });
            JPanel jPanel3 = new JPanel();
            jPanel3.add(this.showEvents);
            jPanel3.add(this.showReflection);
            jPanel3.add(this.up);
            jPanel3.add(this.down);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)new JLabel("Tab order:"), "North");
            jPanel4.add((Component)jPanel3, "South");
            jPanel4.add((Component)this.orderList, "Center");
            JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.add("Component Tree", jPanel2);
            jTabbedPane.add("Component View", jPanel4);
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyDialog.this.save();
                    PropertyDialog.this.setVisible(false);
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyDialog.this.setVisible(false);
                    PropertyDialog.this.load();
                }
            });
            JPanel jPanel5 = new JPanel();
            jPanel5.add(jButton);
            jPanel5.add(jButton2);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)jPanel5, "South");
            this.getContentPane().add((Component)jTabbedPane, "Center");
            this.load();
            this.setSize(400, 400);
        }

        private void save() {
            try {
                this.props.setProperty("guibrowser.showall", this.showAll ? "on" : "off");
                for (int i = 0; i < this.viewTabs.size(); ++i) {
                    this.props.setProperty("guibrowser.viewpage_" + Integer.toString(i), (String)this.viewTabs.elementAt(i));
                }
                this.props.store(new FileOutputStream(this.propFile), "Jemmy GUIBrowser");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private void load() {
            if (this.propFile.exists()) {
                try {
                    this.props.load(new FileInputStream(this.propFile));
                    this.showAll = this.props.getProperty("guibrowser.showall") == null || this.props.getProperty("guibrowser.showall").equals("") || this.props.getProperty("guibrowser.showall").equals("on");
                    this.visibleCombo.setSelectedIndex(this.showAll ? 1 : 0);
                    if (this.props.getProperty("guibrowser.viewpage_0") != null && !this.props.getProperty("guibrowser.viewpage_0").equals("")) {
                        this.viewTabs.removeAllElements();
                        this.viewTabs.addElement(this.props.getProperty("guibrowser.viewpage_0"));
                        this.viewTabs.addElement(this.props.getProperty("guibrowser.viewpage_1"));
                        this.viewTabs.addElement(this.props.getProperty("guibrowser.viewpage_2"));
                        if (this.props.getProperty("guibrowser.viewpage_3") != null && !this.props.getProperty("guibrowser.viewpage_3").equals("")) {
                            this.viewTabs.addElement(this.props.getProperty("guibrowser.viewpage_3"));
                        }
                        if (this.props.getProperty("guibrowser.viewpage_4") != null && !this.props.getProperty("guibrowser.viewpage_4").equals("")) {
                            this.viewTabs.addElement(this.props.getProperty("guibrowser.viewpage_4"));
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.showReflection.setSelected(this.viewTabs.indexOf(REFLECTION_TAB) > -1);
                this.showEvents.setSelected(this.viewTabs.indexOf(EVENT_TAB) > -1);
            }
        }
    }

    private class WindowRenderer
    implements TreeCellRenderer,
    ListCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            return this.get(object, bl);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return this.get(object, bl);
        }

        private Component get(Object object, boolean bl) {
            JLabel jLabel = new JLabel(((ClassNode)object).toString());
            if (bl) {
                ((Component)jLabel).setBackground(Color.blue);
                ((Component)jLabel).setForeground(Color.white);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)jLabel, "Center");
                return jPanel;
            }
            return jLabel;
        }
    }

    private class ComponentModel
    implements TreeModel {
        ContainerNode cont;

        ComponentModel(ContainerNode containerNode) {
            this.cont = containerNode;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
        }

        public Object getChild(Object object, int n) {
            if (object instanceof ContainerNode) {
                return ((ContainerNode)object).getComponents()[n];
            }
            return "";
        }

        public int getChildCount(Object object) {
            if (object instanceof ContainerNode) {
                return ((ContainerNode)object).getComponents().length;
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object instanceof ContainerNode) {
                return ((ContainerNode)object).getComponentIndex((ComponentNode)object2);
            }
            return -1;
        }

        public Object getRoot() {
            return this.cont;
        }

        public boolean isLeaf(Object object) {
            if (object instanceof ContainerNode) {
                return ((ContainerNode)object).getComponents().length == 0;
            }
            return true;
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }
    }

    private class WindowModel
    implements TreeModel {
        WindowNode win;

        WindowModel(WindowNode windowNode) {
            this.win = windowNode;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
        }

        public Object getChild(Object object, int n) {
            return ((WindowNode)object).getWindows()[n];
        }

        public int getChildCount(Object object) {
            return ((WindowNode)object).getWindows().length;
        }

        public int getIndexOfChild(Object object, Object object2) {
            return ((WindowNode)object).getWindowIndex((WindowNode)object2);
        }

        public Object getRoot() {
            return this.win;
        }

        public boolean isLeaf(Object object) {
            return ((WindowNode)object).getWindows().length == 0;
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }
    }

    private class ClassModel
    implements TreeModel {
        ClassNode clsn;

        ClassModel(ClassNode classNode) {
            this.clsn = classNode;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
        }

        public Object getChild(Object object, int n) {
            if (object == this.clsn) {
                return this.clsn.getSuperClasses()[n];
            }
            if (object instanceof SuperClassNode || object instanceof InterfaceNode) {
                return ((ClassNode)object).getSubNodes()[n];
            }
            if (object instanceof MethodNode) {
                return ((MethodNode)object).getParameters()[n];
            }
            return null;
        }

        public int getChildCount(Object object) {
            if (object == this.clsn) {
                return this.clsn.getSuperClasses().length;
            }
            if (object instanceof SuperClassNode || object instanceof InterfaceNode) {
                return ((ClassNode)object).getSubNodes().length;
            }
            if (object instanceof MethodNode) {
                return ((MethodNode)object).getParameters().length;
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object == this.clsn || object instanceof MethodNode || object instanceof SuperClassNode || object instanceof InterfaceNode) {
                ClassNode[] classNodeArray = object instanceof SuperClassNode || object instanceof InterfaceNode ? ((ClassNode)object).getSuperClasses() : (object instanceof MethodNode ? ((MethodNode)object).getParameters() : this.clsn.getSuperClasses());
                for (int i = 0; i < classNodeArray.length; ++i) {
                    if (!classNodeArray.equals(object2)) continue;
                    return i;
                }
            }
            return 0;
        }

        public Object getRoot() {
            return this.clsn;
        }

        public boolean isLeaf(Object object) {
            return this.getChildCount(object) == 0;
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }
    }

    private class RootNode
    extends WindowNode {
        public RootNode() {
            int n;
            Frame[] frameArray = Frame.getFrames();
            this.wins = new WindowNode[frameArray.length];
            int n2 = 0;
            for (n = 0; n < frameArray.length; ++n) {
                if (!GUIBrowser.this.propDialog.showAll && !frameArray[n].isVisible()) continue;
                ++n2;
            }
            this.wins = new WindowNode[n2];
            n2 = 0;
            for (n = 0; n < frameArray.length; ++n) {
                if (!GUIBrowser.this.propDialog.showAll && !frameArray[n].isVisible()) continue;
                this.wins[n2] = new WindowNode(frameArray[n]);
                ++n2;
            }
        }
    }

    private class WindowNode
    extends ContainerNode {
        protected WindowNode[] wins;
        String title;

        protected WindowNode() {
            this.wins = new WindowNode[0];
            this.title = "All Frames";
            this.clss = "";
        }

        public WindowNode(Window window) {
            int n;
            super(window);
            Window[] windowArray = window.getOwnedWindows();
            Vector<WindowNode> vector = new Vector<WindowNode>();
            for (n = 0; n < windowArray.length; ++n) {
                if (!GUIBrowser.this.propDialog.showAll && !windowArray[n].isVisible()) continue;
                vector.add(new WindowNode(windowArray[n]));
            }
            this.wins = new WindowNode[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                this.wins[n] = (WindowNode)vector.get(n);
            }
            this.title = window.toString();
            this.clss = window.getClass().getName();
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = new Robot().createScreenCapture(new Rectangle(window.getLocationOnScreen(), window.getSize()));
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
            this.setComponentImageProvider(new ComponentImageProvider(bufferedImage, this.x, this.y));
        }

        public WindowNode[] getWindows() {
            return this.wins;
        }

        public int getWindowIndex(WindowNode windowNode) {
            for (int i = 0; i < this.wins.length; ++i) {
                if (!this.wins[i].equals(windowNode)) continue;
                return i;
            }
            return -1;
        }

        public WindowModel getWindowModel() {
            return new WindowModel(this);
        }

        public String toString() {
            return this.clss + " \"" + this.title + "\"";
        }
    }

    private class ContainerNode
    extends ComponentNode {
        protected ComponentNode[] comps;

        protected ContainerNode() {
            this.comps = new ComponentNode[0];
        }

        public ContainerNode(Container container) {
            int n;
            super(container);
            Component[] componentArray = container.getComponents();
            Vector<ComponentNode> vector = new Vector<ComponentNode>();
            for (n = 0; n < componentArray.length; ++n) {
                if (componentArray[n] == null || !GUIBrowser.this.propDialog.showAll && !componentArray[n].isVisible()) continue;
                if (componentArray[n] instanceof Container) {
                    vector.add(new ContainerNode((Container)componentArray[n]));
                    continue;
                }
                vector.add(new ComponentNode(componentArray[n]));
            }
            this.comps = new ComponentNode[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                this.comps[n] = (ComponentNode)vector.get(n);
            }
        }

        public ComponentNode[] getComponents() {
            return this.comps;
        }

        public int getComponentIndex(ComponentNode componentNode) {
            for (int i = 0; i < this.comps.length; ++i) {
                if (!this.comps[i].equals(componentNode)) continue;
                return i;
            }
            return -1;
        }

        public void setComponentImageProvider(ComponentImageProvider componentImageProvider) {
            super.setComponentImageProvider(componentImageProvider);
            for (int i = 0; i < this.comps.length; ++i) {
                this.comps[i].setComponentImageProvider(componentImageProvider);
            }
        }

        public ComponentModel getComponentModel() {
            return new ComponentModel(this);
        }
    }

    private class ComponentNode
    extends ClassNode {
        protected Hashtable props;
        protected String clss;
        protected String compToString;
        Component comp;
        ComponentImageProvider image;
        protected int x;
        protected int y;
        protected int w;
        protected int h;

        protected ComponentNode() {
            this.clss = "";
            this.compToString = "";
            this.props = new Hashtable();
        }

        public ComponentNode(Component component) {
            super(component.getClass());
            this.clss = "";
            this.compToString = "";
            this.props = Operator.createOperator(component).getDump();
            this.clss = component.getClass().getName();
            this.compToString = component.toString();
            this.comp = component;
            this.x = component.getLocationOnScreen().x;
            this.y = component.getLocationOnScreen().y;
            this.w = component.getWidth();
            this.h = component.getHeight();
        }

        public String toString() {
            return this.clss;
        }

        public Hashtable getProperties() {
            return this.props;
        }

        public String getToString() {
            return this.compToString;
        }

        public void setComponentImageProvider(ComponentImageProvider componentImageProvider) {
            this.image = componentImageProvider;
        }

        public BufferedImage getImage() {
            if (this.image != null) {
                return this.image.getImage(this.x, this.y, this.w, this.h);
            }
            return null;
        }
    }

    private class MethodNode
    extends ClassNode {
        Method method;

        public MethodNode(Method method) {
            super(method.getReturnType());
            this.method = method;
        }

        public String toString() {
            return "Method: " + Modifier.toString(this.method.getModifiers()) + " " + super.toString() + " " + this.method.getName();
        }

        public ClassNode[] getParameters() {
            Class<?>[] classArray = this.method.getParameterTypes();
            ClassNode[] classNodeArray = new ClassNode[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                classNodeArray[i] = new ClassNode(classArray[i]);
            }
            return classNodeArray;
        }
    }

    private class FieldNode
    extends ClassNode {
        Field field;

        public FieldNode(Field field) {
            super(field.getType());
            this.field = field;
        }

        public String toString() {
            return "Field: " + Modifier.toString(this.field.getModifiers()) + " " + super.toString() + " " + this.field.getName();
        }
    }

    private class InterfaceNode
    extends ClassNode {
        protected InterfaceNode() {
        }

        public InterfaceNode(Class clazz) {
            super(clazz);
        }

        public String toString() {
            return "Interfac: " + super.toString();
        }
    }

    private class SuperClassNode
    extends ClassNode {
        protected SuperClassNode() {
        }

        public SuperClassNode(Class clazz) {
            super(clazz);
        }

        public String toString() {
            return "Class: " + super.toString();
        }
    }

    private class ClassNode {
        Class clzz;

        protected ClassNode() {
            this.clzz = null;
        }

        public ClassNode(Class clazz) {
            this.clzz = clazz;
        }

        public ClassNode[] getSuperClasses() {
            int n = 0;
            Class clazz = this.clzz;
            while ((clazz = clazz.getSuperclass()) != null) {
                ++n;
            }
            Class<?>[] classArray = this.clzz.getInterfaces();
            ClassNode[] classNodeArray = new ClassNode[n + classArray.length + 1];
            classNodeArray[0] = new SuperClassNode(this.clzz);
            n = 1;
            clazz = this.clzz;
            while ((clazz = clazz.getSuperclass()) != null) {
                classNodeArray[n] = new SuperClassNode(clazz);
                ++n;
            }
            for (int i = n; i < n + classArray.length; ++i) {
                classNodeArray[i] = new InterfaceNode(classArray[i - n]);
            }
            return classNodeArray;
        }

        public String toString() {
            if (this.clzz.isArray()) {
                return this.clzz.getComponentType().getName() + "[]";
            }
            return this.clzz.getName();
        }

        public TreeModel getMethodsModel() {
            return new ClassModel(this);
        }

        public ClassNode[] getSubNodes() {
            int n;
            Vector<ClassNode> vector = new Vector<ClassNode>();
            Field[] fieldArray = this.clzz.getFields();
            Arrays.sort(fieldArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Field)object).getName().compareTo(((Field)object2).getName());
                }
            });
            Method[] methodArray = this.clzz.getMethods();
            Arrays.sort(methodArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Method)object).getName().compareTo(((Method)object2).getName());
                }
            });
            for (n = 0; n < fieldArray.length; ++n) {
                if (!fieldArray[n].getDeclaringClass().getName().equals(this.clzz.getName())) continue;
                vector.add(new FieldNode(fieldArray[n]));
            }
            for (n = 0; n < methodArray.length; ++n) {
                if (!methodArray[n].getDeclaringClass().getName().equals(this.clzz.getName())) continue;
                vector.add(new MethodNode(methodArray[n]));
            }
            ClassNode[] classNodeArray = new ClassNode[vector.size()];
            for (int i = 0; i < classNodeArray.length; ++i) {
                classNodeArray[i] = (ClassNode)vector.get(i);
            }
            return classNodeArray;
        }
    }
}

