/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.image;

import java.awt.image.BufferedImage;
import org.netbeans.jemmy.image.ImageComparator;
import org.netbeans.jemmy.image.StrictImageComparator;

public class ColorImageComparator
extends StrictImageComparator {
    ColorMap leftMap;
    ColorMap rightMap;
    ImageComparator comparator = null;

    public ColorImageComparator(ColorMap colorMap) {
        this.leftMap = colorMap;
        this.rightMap = colorMap;
    }

    public ColorImageComparator(ColorMap colorMap, ImageComparator imageComparator) {
        this(colorMap);
        this.comparator = imageComparator;
    }

    public ColorImageComparator(ColorMap colorMap, ColorMap colorMap2) {
        this.leftMap = colorMap;
        this.rightMap = colorMap2;
    }

    public ColorImageComparator(ColorMap colorMap, ColorMap colorMap2, ImageComparator imageComparator) {
        this(colorMap, colorMap2);
        this.comparator = imageComparator;
    }

    public boolean compare(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.comparator != null) {
            return this.comparator.compare(this.recolor(bufferedImage, this.leftMap), this.recolor(bufferedImage2, this.rightMap));
        }
        return super.compare(bufferedImage, bufferedImage2);
    }

    private BufferedImage recolor(BufferedImage bufferedImage, ColorMap colorMap) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                bufferedImage2.setRGB(i, j, colorMap.mapColor(bufferedImage.getRGB(i, j)));
            }
        }
        return bufferedImage2;
    }

    protected final boolean compareColors(int n, int n2) {
        return this.leftMap.mapColor(n) == this.rightMap.mapColor(n2);
    }

    public static class BackgroundColorMap
    implements ColorMap {
        int background;

        public BackgroundColorMap(int n) {
            this.background = n;
        }

        public int mapColor(int n) {
            return n == this.background ? 0 : n;
        }
    }

    public static class ForegroundColorMap
    implements ColorMap {
        int foreground;

        public ForegroundColorMap(int n) {
            this.foreground = n;
        }

        public int mapColor(int n) {
            return n == this.foreground ? 0xFFFFFF : 0;
        }
    }

    public static interface ColorMap {
        public int mapColor(int var1);
    }
}

