/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ListDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class ChoiceOperator
extends ComponentOperator
implements Outputable {
    public static final String SELECTED_ITEM_DPROP = "Selected item";
    public static final String ITEM_PREFIX_DPROP = "Item";
    private TestOut output;
    private ListDriver driver = DriverManager.getListDriver(this.getClass());
    static /* synthetic */ Class class$java$awt$Choice;

    public ChoiceOperator(Choice choice) {
        super(choice);
    }

    public ChoiceOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((Choice)containerOperator.waitSubComponent(new ChoiceFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public ChoiceOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public ChoiceOperator(ContainerOperator containerOperator, String string, int n) {
        this((Choice)ChoiceOperator.waitComponent(containerOperator, (ComponentChooser)new ChoiceBySelectedItemFinder(string, containerOperator.getComparator()), n));
        this.copyEnvironment(containerOperator);
    }

    public ChoiceOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public ChoiceOperator(ContainerOperator containerOperator, int n) {
        this((Choice)ChoiceOperator.waitComponent(containerOperator, (ComponentChooser)new ChoiceFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public ChoiceOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static Choice findChoice(Container container, ComponentChooser componentChooser, int n) {
        return (Choice)ChoiceOperator.findComponent(container, new ChoiceFinder(componentChooser), n);
    }

    public static Choice findChoice(Container container, ComponentChooser componentChooser) {
        return ChoiceOperator.findChoice(container, componentChooser, 0);
    }

    public static Choice findChoice(Container container, String string, boolean bl, boolean bl2, int n) {
        return ChoiceOperator.findChoice(container, new ChoiceBySelectedItemFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static Choice findChoice(Container container, String string, boolean bl, boolean bl2) {
        return ChoiceOperator.findChoice(container, string, bl, bl2, 0);
    }

    public static Choice waitChoice(Container container, ComponentChooser componentChooser, int n) {
        return (Choice)ChoiceOperator.waitComponent(container, (ComponentChooser)new ChoiceFinder(componentChooser), n);
    }

    public static Choice waitChoice(Container container, ComponentChooser componentChooser) {
        return ChoiceOperator.waitChoice(container, componentChooser, 0);
    }

    public static Choice waitChoice(Container container, String string, boolean bl, boolean bl2, int n) {
        return ChoiceOperator.waitChoice(container, new ChoiceBySelectedItemFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static Choice waitChoice(Container container, String string, boolean bl, boolean bl2) {
        return ChoiceOperator.waitChoice(container, string, bl, bl2, 0);
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (ListDriver)DriverManager.getDriver("drivers.list", this.getClass(), operator.getProperties());
    }

    public int findItemIndex(String string, int n) {
        return this.findItemIndex(string, this.getComparator(), n);
    }

    public int findItemIndex(String string) {
        return this.findItemIndex(string, 0);
    }

    public void selectItem(String string, int n) {
        this.selectItem(string, this.getComparator(), n);
    }

    public void selectItem(String string) {
        this.selectItem(string, 0);
    }

    public void selectItem(int n) {
        this.output.printLine("Select " + Integer.toString(n) + "`th item in combobox\n    : " + this.toStringSource());
        this.output.printGolden("Select " + Integer.toString(n) + "`th item in combobox");
        this.makeComponentVisible();
        try {
            this.waitComponentEnabled();
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted!", interruptedException);
        }
        this.driver.selectItem(this, n);
        if (this.getVerification()) {
            this.waitItemSelected(n);
        }
    }

    public void waitItemSelected(final int n) {
        this.getOutput().printLine("Wait " + Integer.toString(n) + "'th item to be selected in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait " + Integer.toString(n) + "'th item to be selected");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return ChoiceOperator.this.getSelectedIndex() == n;
            }

            public String getDescription() {
                return "Has " + Integer.toString(n) + "'th item selected";
            }
        });
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        if (((Choice)this.getSource()).getSelectedItem() != null) {
            hashtable.put(SELECTED_ITEM_DPROP, ((Choice)this.getSource()).getSelectedItem());
        }
        Object[] objectArray = new String[((Choice)this.getSource()).getItemCount()];
        for (int i = 0; i < ((Choice)this.getSource()).getItemCount(); ++i) {
            objectArray[i] = ((Choice)this.getSource()).getItem(i);
        }
        this.addToDump(hashtable, ITEM_PREFIX_DPROP, objectArray);
        return hashtable;
    }

    public void add(final String string) {
        this.runMapping(new Operator.MapVoidAction("add"){

            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).add(string);
            }
        });
    }

    public void addItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("addItemListener"){

            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).addItemListener(itemListener);
            }
        });
    }

    public void addNotify() {
        this.runMapping(new Operator.MapVoidAction("addNotify"){

            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).addNotify();
            }
        });
    }

    public String getItem(final int n) {
        return (String)this.runMapping(new Operator.MapAction("getItem"){

            public Object map() {
                return ((Choice)ChoiceOperator.this.getSource()).getItem(n);
            }
        });
    }

    public int getItemCount() {
        return this.runMapping(new Operator.MapIntegerAction("getItemCount"){

            public int map() {
                return ((Choice)ChoiceOperator.this.getSource()).getItemCount();
            }
        });
    }

    public int getSelectedIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedIndex"){

            public int map() {
                return ((Choice)ChoiceOperator.this.getSource()).getSelectedIndex();
            }
        });
    }

    public String getSelectedItem() {
        return (String)this.runMapping(new Operator.MapAction("getSelectedItem"){

            public Object map() {
                return ((Choice)ChoiceOperator.this.getSource()).getSelectedItem();
            }
        });
    }

    public void insert(final String string, final int n) {
        this.runMapping(new Operator.MapVoidAction("insert"){

            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).insert(string, n);
            }
        });
    }

    public void remove(final int n) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).remove(n);
            }
        });
    }

    public void remove(final String string) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).remove(string);
            }
        });
    }

    public void removeAll() {
        this.runMapping(new Operator.MapVoidAction("removeAll"){

            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).removeAll();
            }
        });
    }

    public void removeItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("removeItemListener"){

            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).removeItemListener(itemListener);
            }
        });
    }

    public void select(final int n) {
        this.runMapping(new Operator.MapVoidAction("select"){

            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).select(n);
            }
        });
    }

    public void setState(final String string) {
        this.runMapping(new Operator.MapVoidAction("select"){

            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).select(string);
            }
        });
    }

    private int findItemIndex(String string, Operator.StringComparator stringComparator, int n) {
        int n2 = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!stringComparator.equals(this.getItem(i), string)) continue;
            if (n2 == n) {
                return i;
            }
            ++n2;
        }
        return -1;
    }

    private void selectItem(String string, Operator.StringComparator stringComparator, int n) {
        this.selectItem(this.findItemIndex(string, stringComparator, n));
    }

    public static class ChoiceFinder
    extends Operator.Finder {
        public ChoiceFinder(ComponentChooser componentChooser) {
            super(class$java$awt$Choice == null ? (class$java$awt$Choice = ChoiceOperator.class$("java.awt.Choice")) : class$java$awt$Choice, componentChooser);
        }

        public ChoiceFinder() {
            super(class$java$awt$Choice == null ? (class$java$awt$Choice = ChoiceOperator.class$("java.awt.Choice")) : class$java$awt$Choice);
        }
    }

    public static class ChoiceBySelectedItemFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public ChoiceBySelectedItemFinder(String string, Operator.StringComparator stringComparator) {
            this.label = string;
            this.comparator = stringComparator;
        }

        public ChoiceBySelectedItemFinder(String string) {
            this(string, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof Choice && ((Choice)component).getSelectedItem() != null) {
                return this.comparator.equals(((Choice)component).getSelectedItem(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "Choice with label \"" + this.label + "\"";
        }
    }
}

