/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollPaneUI;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JScrollBarOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JScrollPaneOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    private static int X_POINT_RECT_SIZE = 6;
    private static int Y_POINT_RECT_SIZE = 4;
    private Timeouts timeouts;
    private TestOut output;
    private JScrollBarOperator hScrollBarOper = null;
    private JScrollBarOperator vScrollBarOper = null;
    static /* synthetic */ Class class$javax$swing$JScrollPane;

    public JScrollPaneOperator(JScrollPane jScrollPane) {
        super(jScrollPane);
    }

    public JScrollPaneOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JScrollPane)containerOperator.waitSubComponent(new JScrollPaneFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JScrollPaneOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JScrollPaneOperator(ContainerOperator containerOperator, int n) {
        this((JScrollPane)JScrollPaneOperator.waitComponent(containerOperator, (ComponentChooser)new JScrollPaneFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public JScrollPaneOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JScrollPane findJScrollPane(Container container, ComponentChooser componentChooser, int n) {
        return (JScrollPane)JScrollPaneOperator.findComponent(container, new JScrollPaneFinder(componentChooser), n);
    }

    public static JScrollPane findJScrollPane(Container container, ComponentChooser componentChooser) {
        return JScrollPaneOperator.findJScrollPane(container, componentChooser, 0);
    }

    public static JScrollPane findJScrollPane(Container container, int n) {
        return JScrollPaneOperator.findJScrollPane(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JScrollPane instance"), n);
    }

    public static JScrollPane findJScrollPane(Container container) {
        return JScrollPaneOperator.findJScrollPane(container, 0);
    }

    public static JScrollPane findJScrollPaneUnder(Component component, ComponentChooser componentChooser) {
        return (JScrollPane)JScrollPaneOperator.findContainerUnder(component, new JScrollPaneFinder(componentChooser));
    }

    public static JScrollPane findJScrollPaneUnder(Component component) {
        return JScrollPaneOperator.findJScrollPaneUnder(component, new JScrollPaneFinder());
    }

    public static JScrollPane waitJScrollPane(Container container, ComponentChooser componentChooser, int n) {
        return (JScrollPane)JScrollPaneOperator.waitComponent(container, (ComponentChooser)new JScrollPaneFinder(componentChooser), n);
    }

    public static JScrollPane waitJScrollPane(Container container, ComponentChooser componentChooser) {
        return JScrollPaneOperator.waitJScrollPane(container, componentChooser, 0);
    }

    public static JScrollPane waitJScrollPane(Container container, int n) {
        return JScrollPaneOperator.waitJScrollPane(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JScrollPane instance"), n);
    }

    public static JScrollPane waitJScrollPane(Container container) {
        return JScrollPaneOperator.waitJScrollPane(container, 0);
    }

    public void setValues(int n, int n2) {
        this.initOperators();
        this.hScrollBarOper.setValue(n);
        this.vScrollBarOper.setValue(n2);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void scrollToHorizontalValue(int n) {
        this.output.printTrace("Scroll JScrollPane to " + Integer.toString(n) + " horizontal value \n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to " + Integer.toString(n) + " horizontal value");
        this.initOperators();
        this.makeComponentVisible();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            this.hScrollBarOper.scrollToValue(n);
        }
    }

    public void scrollToHorizontalValue(double d) {
        this.output.printTrace("Scroll JScrollPane to " + Double.toString(d) + " proportional horizontal value \n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to " + Double.toString(d) + " proportional horizontal value");
        this.initOperators();
        this.makeComponentVisible();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            this.hScrollBarOper.scrollToValue(d);
        }
    }

    public void scrollToVerticalValue(int n) {
        this.output.printTrace("Scroll JScrollPane to " + Integer.toString(n) + " vertical value \n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to " + Integer.toString(n) + " vertical value");
        this.initOperators();
        this.makeComponentVisible();
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            this.vScrollBarOper.scrollToValue(n);
        }
    }

    public void scrollToVerticalValue(double d) {
        this.output.printTrace("Scroll JScrollPane to " + Double.toString(d) + " proportional vertical value \n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to " + Double.toString(d) + " proportional vertical value");
        this.initOperators();
        this.makeComponentVisible();
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            this.vScrollBarOper.scrollToValue(d);
        }
    }

    public void scrollToValues(int n, int n2) {
        this.scrollToVerticalValue(n);
        this.scrollToHorizontalValue(n);
    }

    public void scrollToValues(double d, double d2) {
        this.scrollToVerticalValue(d);
        this.scrollToHorizontalValue(d2);
    }

    public void scrollToTop() {
        this.output.printTrace("Scroll JScrollPane to top\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to top");
        this.initOperators();
        this.makeComponentVisible();
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            this.vScrollBarOper.scrollToMinimum();
        }
    }

    public void scrollToBottom() {
        this.output.printTrace("Scroll JScrollPane to bottom\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to bottom");
        this.initOperators();
        this.makeComponentVisible();
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            this.vScrollBarOper.scrollToMaximum();
        }
    }

    public void scrollToLeft() {
        this.output.printTrace("Scroll JScrollPane to left\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to left");
        this.initOperators();
        this.makeComponentVisible();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            this.hScrollBarOper.scrollToMinimum();
        }
    }

    public void scrollToRight() {
        this.output.printTrace("Scroll JScrollPane to right\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to right");
        this.initOperators();
        this.makeComponentVisible();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            this.hScrollBarOper.scrollToMaximum();
        }
    }

    public void scrollToComponentRectangle(Component component, int n, int n2, int n3, int n4) {
        this.initOperators();
        this.makeComponentVisible();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            this.hScrollBarOper.scrollTo(new ComponentRectChecker(component, n, n2, n3, n4, 0));
        }
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            this.vScrollBarOper.scrollTo(new ComponentRectChecker(component, n, n2, n3, n4, 1));
        }
    }

    public void scrollToComponentPoint(Component component, int n, int n2) {
        this.scrollToComponentRectangle(component, n - X_POINT_RECT_SIZE, n2 - Y_POINT_RECT_SIZE, 2 * X_POINT_RECT_SIZE, 2 * Y_POINT_RECT_SIZE);
    }

    public void scrollToComponent(final Component component) {
        String string = (String)this.runMapping(new Operator.MapAction("comp.toString()"){

            public Object map() {
                return component.toString();
            }
        });
        this.output.printTrace("Scroll JScrollPane " + this.toStringSource() + "\nto component " + string);
        this.output.printGolden("Scroll JScrollPane to " + component.getClass().getName() + " component.");
        this.scrollToComponentRectangle(component, 0, 0, component.getWidth(), component.getHeight());
    }

    public JScrollBarOperator getHScrollBarOperator() {
        this.initOperators();
        return this.hScrollBarOper;
    }

    public JScrollBarOperator getVScrollBarOperator() {
        this.initOperators();
        return this.vScrollBarOper;
    }

    public boolean checkInside(Component component, int n, int n2, int n3, int n4) {
        Component component2 = this.getViewport().getView();
        Point point = SwingUtilities.convertPoint(component, n, n2, this.getViewport().getView());
        this.initOperators();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            if (point.x < this.hScrollBarOper.getValue()) {
                return false;
            }
            if (component.getWidth() > component2.getWidth()) {
                return point.x > 0;
            }
            return point.x + component.getWidth() > this.hScrollBarOper.getValue() + component2.getWidth();
        }
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            if (point.y < this.vScrollBarOper.getValue()) {
                return false;
            }
            if (component.getHeight() > component2.getHeight()) {
                return point.y > 0;
            }
            return point.y + component.getHeight() > this.vScrollBarOper.getValue() + component2.getHeight();
        }
        return true;
    }

    public boolean checkInside(Component component) {
        return this.checkInside(component, 0, 0, component.getWidth(), component.getHeight());
    }

    public JScrollBar createHorizontalScrollBar() {
        return (JScrollBar)this.runMapping(new Operator.MapAction("createHorizontalScrollBar"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).createHorizontalScrollBar();
            }
        });
    }

    public JScrollBar createVerticalScrollBar() {
        return (JScrollBar)this.runMapping(new Operator.MapAction("createVerticalScrollBar"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).createVerticalScrollBar();
            }
        });
    }

    public JViewport getColumnHeader() {
        return (JViewport)this.runMapping(new Operator.MapAction("getColumnHeader"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getColumnHeader();
            }
        });
    }

    public Component getCorner(final String string) {
        return (Component)this.runMapping(new Operator.MapAction("getCorner"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getCorner(string);
            }
        });
    }

    public JScrollBar getHorizontalScrollBar() {
        return (JScrollBar)this.runMapping(new Operator.MapAction("getHorizontalScrollBar"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getHorizontalScrollBar();
            }
        });
    }

    public int getHorizontalScrollBarPolicy() {
        return this.runMapping(new Operator.MapIntegerAction("getHorizontalScrollBarPolicy"){

            public int map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getHorizontalScrollBarPolicy();
            }
        });
    }

    public JViewport getRowHeader() {
        return (JViewport)this.runMapping(new Operator.MapAction("getRowHeader"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getRowHeader();
            }
        });
    }

    public ScrollPaneUI getUI() {
        return (ScrollPaneUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getUI();
            }
        });
    }

    public JScrollBar getVerticalScrollBar() {
        return (JScrollBar)this.runMapping(new Operator.MapAction("getVerticalScrollBar"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getVerticalScrollBar();
            }
        });
    }

    public int getVerticalScrollBarPolicy() {
        return this.runMapping(new Operator.MapIntegerAction("getVerticalScrollBarPolicy"){

            public int map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getVerticalScrollBarPolicy();
            }
        });
    }

    public JViewport getViewport() {
        return (JViewport)this.runMapping(new Operator.MapAction("getViewport"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getViewport();
            }
        });
    }

    public Border getViewportBorder() {
        return (Border)this.runMapping(new Operator.MapAction("getViewportBorder"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getViewportBorder();
            }
        });
    }

    public Rectangle getViewportBorderBounds() {
        return (Rectangle)this.runMapping(new Operator.MapAction("getViewportBorderBounds"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getViewportBorderBounds();
            }
        });
    }

    public void setColumnHeader(final JViewport jViewport) {
        this.runMapping(new Operator.MapVoidAction("setColumnHeader"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setColumnHeader(jViewport);
            }
        });
    }

    public void setColumnHeaderView(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setColumnHeaderView"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setColumnHeaderView(component);
            }
        });
    }

    public void setCorner(final String string, final Component component) {
        this.runMapping(new Operator.MapVoidAction("setCorner"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setCorner(string, component);
            }
        });
    }

    public void setHorizontalScrollBar(final JScrollBar jScrollBar) {
        this.runMapping(new Operator.MapVoidAction("setHorizontalScrollBar"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setHorizontalScrollBar(jScrollBar);
            }
        });
    }

    public void setHorizontalScrollBarPolicy(final int n) {
        this.runMapping(new Operator.MapVoidAction("setHorizontalScrollBarPolicy"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setHorizontalScrollBarPolicy(n);
            }
        });
    }

    public void setRowHeader(final JViewport jViewport) {
        this.runMapping(new Operator.MapVoidAction("setRowHeader"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setRowHeader(jViewport);
            }
        });
    }

    public void setRowHeaderView(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setRowHeaderView"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setRowHeaderView(component);
            }
        });
    }

    public void setUI(final ScrollPaneUI scrollPaneUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setUI(scrollPaneUI);
            }
        });
    }

    public void setVerticalScrollBar(final JScrollBar jScrollBar) {
        this.runMapping(new Operator.MapVoidAction("setVerticalScrollBar"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setVerticalScrollBar(jScrollBar);
            }
        });
    }

    public void setVerticalScrollBarPolicy(final int n) {
        this.runMapping(new Operator.MapVoidAction("setVerticalScrollBarPolicy"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setVerticalScrollBarPolicy(n);
            }
        });
    }

    public void setViewport(final JViewport jViewport) {
        this.runMapping(new Operator.MapVoidAction("setViewport"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setViewport(jViewport);
            }
        });
    }

    public void setViewportBorder(final Border border) {
        this.runMapping(new Operator.MapVoidAction("setViewportBorder"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setViewportBorder(border);
            }
        });
    }

    public void setViewportView(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setViewportView"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setViewportView(component);
            }
        });
    }

    private void initOperators() {
        if (this.hScrollBarOper == null && this.getHorizontalScrollBar() != null && this.getHorizontalScrollBar().isVisible()) {
            this.hScrollBarOper = new JScrollBarOperator(this.getHorizontalScrollBar());
            this.hScrollBarOper.copyEnvironment(this);
            this.hScrollBarOper.setVisualizer(new EmptyVisualizer());
        }
        if (this.vScrollBarOper == null && this.getVerticalScrollBar() != null && this.getVerticalScrollBar().isVisible()) {
            this.vScrollBarOper = new JScrollBarOperator(this.getVerticalScrollBar());
            this.vScrollBarOper.copyEnvironment(this);
            this.vScrollBarOper.setVisualizer(new EmptyVisualizer());
        }
    }

    public static class JScrollPaneFinder
    extends Operator.Finder {
        public JScrollPaneFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = JScrollPaneOperator.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, componentChooser);
        }

        public JScrollPaneFinder() {
            super(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = JScrollPaneOperator.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane);
        }
    }

    private class ComponentRectChecker
    implements JScrollBarOperator.ScrollChecker {
        Component comp;
        int x;
        int y;
        int width;
        int height;
        int orientation;

        public ComponentRectChecker(Component component, int n, int n2, int n3, int n4, int n5) {
            this.comp = component;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.orientation = n5;
        }

        public int getScrollDirection(JScrollBarOperator jScrollBarOperator) {
            Point point = SwingUtilities.convertPoint(this.comp, this.x, this.y, JScrollPaneOperator.this.getViewport().getView());
            int n = this.orientation == 0 ? point.x : point.y;
            int n2 = this.orientation == 0 ? this.width : this.height;
            int n3 = this.orientation == 0 ? JScrollPaneOperator.this.getViewport().getWidth() : JScrollPaneOperator.this.getViewport().getHeight();
            int n4 = jScrollBarOperator.getValue();
            if (n < n4) {
                return -1;
            }
            if (n + n2 - 1 > n4 + n3 && n > n4) {
                return 1;
            }
            return 0;
        }

        public String getDescription() {
            return "";
        }
    }
}

