/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.ScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class ScrollPaneOperator
extends ContainerOperator
implements Timeoutable,
Outputable {
    private static int X_POINT_RECT_SIZE = 6;
    private static int Y_POINT_RECT_SIZE = 4;
    private Timeouts timeouts;
    private TestOut output;
    private ScrollDriver driver = DriverManager.getScrollDriver(this.getClass());
    static /* synthetic */ Class class$java$awt$ScrollPane;

    public ScrollPaneOperator(ScrollPane scrollPane) {
        super(scrollPane);
    }

    public ScrollPaneOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((ScrollPane)containerOperator.waitSubComponent(new ScrollPaneFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public ScrollPaneOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public ScrollPaneOperator(ContainerOperator containerOperator, int n) {
        this((ScrollPane)ScrollPaneOperator.waitComponent(containerOperator, (ComponentChooser)new ScrollPaneFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public ScrollPaneOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static ScrollPane findScrollPane(Container container, ComponentChooser componentChooser, int n) {
        return (ScrollPane)ScrollPaneOperator.findComponent(container, new ScrollPaneFinder(componentChooser), n);
    }

    public static ScrollPane findScrollPane(Container container, ComponentChooser componentChooser) {
        return ScrollPaneOperator.findScrollPane(container, componentChooser, 0);
    }

    public static ScrollPane findScrollPane(Container container, int n) {
        return ScrollPaneOperator.findScrollPane(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th ScrollPane instance"), n);
    }

    public static ScrollPane findScrollPane(Container container) {
        return ScrollPaneOperator.findScrollPane(container, 0);
    }

    public static ScrollPane findScrollPaneUnder(Component component, ComponentChooser componentChooser) {
        return (ScrollPane)ScrollPaneOperator.findContainerUnder(component, new ScrollPaneFinder(componentChooser));
    }

    public static ScrollPane findScrollPaneUnder(Component component) {
        return ScrollPaneOperator.findScrollPaneUnder(component, new ScrollPaneFinder());
    }

    public static ScrollPane waitScrollPane(Container container, ComponentChooser componentChooser, int n) {
        return (ScrollPane)ScrollPaneOperator.waitComponent(container, (ComponentChooser)new ScrollPaneFinder(componentChooser), n);
    }

    public static ScrollPane waitScrollPane(Container container, ComponentChooser componentChooser) {
        return ScrollPaneOperator.waitScrollPane(container, componentChooser, 0);
    }

    public static ScrollPane waitScrollPane(Container container, int n) {
        return ScrollPaneOperator.waitScrollPane(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th ScrollPane instance"), n);
    }

    public static ScrollPane waitScrollPane(Container container) {
        return ScrollPaneOperator.waitScrollPane(container, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (ScrollDriver)DriverManager.getDriver("drivers.scroll", this.getClass(), operator.getProperties());
    }

    public void setValues(int n, int n2) {
        this.getHAdjustable().setValue(n);
        this.getVAdjustable().setValue(n2);
    }

    public void scrollTo(final ScrollAdjuster scrollAdjuster) {
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                ScrollPaneOperator.this.driver.scroll(ScrollPaneOperator.this, scrollAdjuster);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToHorizontalValue(int n) {
        this.output.printTrace("Scroll ScrollPane to " + Integer.toString(n) + " horizontal value \n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to " + Integer.toString(n) + " horizontal value");
        this.scrollTo(new ValueScrollAdjuster(n, 0, this.getHAdjustable()));
    }

    public void scrollToHorizontalValue(double d) {
        this.output.printTrace("Scroll ScrollPane to " + Double.toString(d) + " proportional horizontal value \n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to " + Double.toString(d) + " proportional horizontal value");
        Adjustable adjustable = this.getHAdjustable();
        this.scrollTo(new ValueScrollAdjuster((int)((double)adjustable.getMinimum() + (double)(adjustable.getMaximum() - adjustable.getVisibleAmount() - adjustable.getMinimum()) * d), 1, this.getVAdjustable()));
    }

    public void scrollToVerticalValue(int n) {
        this.output.printTrace("Scroll ScrollPane to " + Integer.toString(n) + " vertical value \n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to " + Integer.toString(n) + " vertical value");
        this.scrollTo(new ValueScrollAdjuster(n, 1, this.getVAdjustable()));
    }

    public void scrollToVerticalValue(double d) {
        this.output.printTrace("Scroll ScrollPane to " + Double.toString(d) + " proportional vertical value \n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to " + Double.toString(d) + " proportional vertical value");
        Adjustable adjustable = this.getVAdjustable();
        this.scrollTo(new ValueScrollAdjuster((int)((double)adjustable.getMinimum() + (double)(adjustable.getMaximum() - adjustable.getVisibleAmount() - adjustable.getMinimum()) * d), 1, this.getVAdjustable()));
    }

    public void scrollToValues(int n, int n2) {
        this.scrollToVerticalValue(n);
        this.scrollToHorizontalValue(n);
    }

    public void scrollToValues(double d, double d2) {
        this.scrollToVerticalValue(d);
        this.scrollToHorizontalValue(d2);
    }

    public void scrollToTop() {
        this.output.printTrace("Scroll ScrollPane to top\n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to top");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                ScrollPaneOperator.this.driver.scrollToMinimum(ScrollPaneOperator.this, 1);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToBottom() {
        this.output.printTrace("Scroll ScrollPane to bottom\n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to bottom");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                ScrollPaneOperator.this.driver.scrollToMaximum(ScrollPaneOperator.this, 1);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToLeft() {
        this.output.printTrace("Scroll ScrollPane to left\n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to left");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                ScrollPaneOperator.this.driver.scrollToMinimum(ScrollPaneOperator.this, 0);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToRight() {
        this.output.printTrace("Scroll ScrollPane to right\n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to right");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                ScrollPaneOperator.this.driver.scrollToMaximum(ScrollPaneOperator.this, 0);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToComponentRectangle(Component component, int n, int n2, int n3, int n4) {
        this.scrollTo(new ComponentRectChecker(component, n, n2, n3, n4, 0));
        this.scrollTo(new ComponentRectChecker(component, n, n2, n3, n4, 1));
    }

    public void scrollToComponentPoint(Component component, int n, int n2) {
        this.scrollToComponentRectangle(component, n - X_POINT_RECT_SIZE, n2 - Y_POINT_RECT_SIZE, 2 * X_POINT_RECT_SIZE, 2 * Y_POINT_RECT_SIZE);
    }

    public void scrollToComponent(final Component component) {
        String string = (String)this.runMapping(new Operator.MapAction("comp.toString()"){

            public Object map() {
                return component.toString();
            }
        });
        this.output.printTrace("Scroll ScrollPane " + this.toStringSource() + "\nto component " + string);
        this.output.printGolden("Scroll ScrollPane to " + component.getClass().getName() + " component.");
        this.scrollToComponentRectangle(component, 0, 0, component.getWidth(), component.getHeight());
    }

    public boolean checkInside(Component component, int n, int n2, int n3, int n4) {
        Point point = SwingUtilities.convertPoint(component, n, n2, this.getSource());
        if (point.x < this.getHAdjustable().getValue()) {
            return false;
        }
        if (component.getWidth() > this.getSource().getWidth() ? point.x > 0 : point.x + component.getWidth() > this.getHAdjustable().getValue() + this.getSource().getWidth()) {
            return false;
        }
        if (point.y < this.getVAdjustable().getValue()) {
            return false;
        }
        return !(component.getHeight() > this.getSource().getHeight() ? point.y > 0 : point.y + component.getHeight() > this.getVAdjustable().getValue() + this.getSource().getHeight());
    }

    public boolean checkInside(Component component) {
        return this.checkInside(component, 0, 0, component.getWidth(), component.getHeight());
    }

    public boolean isScrollbarVisible(int n) {
        if (n == 0) {
            return this.getViewportSize().getHeight() < (double)(this.getHeight() - this.getHScrollbarHeight());
        }
        if (n == 1) {
            return this.getViewportSize().getWidth() < (double)(this.getWidth() - this.getVScrollbarWidth());
        }
        return false;
    }

    public Adjustable getHAdjustable() {
        return (Adjustable)this.runMapping(new Operator.MapAction("getHAdjustable"){

            public Object map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getHAdjustable();
            }
        });
    }

    public int getHScrollbarHeight() {
        return this.runMapping(new Operator.MapIntegerAction("getHScrollbarHeight"){

            public int map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getHScrollbarHeight();
            }
        });
    }

    public Point getScrollPosition() {
        return (Point)this.runMapping(new Operator.MapAction("getScrollPosition"){

            public Object map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getScrollPosition();
            }
        });
    }

    public int getScrollbarDisplayPolicy() {
        return this.runMapping(new Operator.MapIntegerAction("getScrollbarDisplayPolicy"){

            public int map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getScrollbarDisplayPolicy();
            }
        });
    }

    public Adjustable getVAdjustable() {
        return (Adjustable)this.runMapping(new Operator.MapAction("getVAdjustable"){

            public Object map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getVAdjustable();
            }
        });
    }

    public int getVScrollbarWidth() {
        return this.runMapping(new Operator.MapIntegerAction("getVScrollbarWidth"){

            public int map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getVScrollbarWidth();
            }
        });
    }

    public Dimension getViewportSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getViewportSize"){

            public Object map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getViewportSize();
            }
        });
    }

    public String paramString() {
        return (String)this.runMapping(new Operator.MapAction("paramString"){

            public Object map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).paramString();
            }
        });
    }

    public void setScrollPosition(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("setScrollPosition"){

            public void map() {
                ((ScrollPane)ScrollPaneOperator.this.getSource()).setScrollPosition(n, n2);
            }
        });
    }

    public void setScrollPosition(final Point point) {
        this.runMapping(new Operator.MapVoidAction("setScrollPosition"){

            public void map() {
                ((ScrollPane)ScrollPaneOperator.this.getSource()).setScrollPosition(point);
            }
        });
    }

    static {
        try {
            Class.forName("org.netbeans.jemmy.operators.ScrollbarOperator");
        }
        catch (Exception exception) {
            throw new JemmyException("Exception", exception);
        }
    }

    public static class ScrollPaneFinder
    extends Operator.Finder {
        public ScrollPaneFinder(ComponentChooser componentChooser) {
            super(class$java$awt$ScrollPane == null ? (class$java$awt$ScrollPane = ScrollPaneOperator.class$("java.awt.ScrollPane")) : class$java$awt$ScrollPane, componentChooser);
        }

        public ScrollPaneFinder() {
            super(class$java$awt$ScrollPane == null ? (class$java$awt$ScrollPane = ScrollPaneOperator.class$("java.awt.ScrollPane")) : class$java$awt$ScrollPane);
        }
    }

    private class ComponentRectChecker
    implements ScrollAdjuster {
        Component comp;
        int x;
        int y;
        int width;
        int height;
        int orientation;

        public ComponentRectChecker(Component component, int n, int n2, int n3, int n4, int n5) {
            this.comp = component;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.orientation = n5;
        }

        public int getScrollDirection() {
            int n;
            int n2 = this.orientation == 0 ? (int)ScrollPaneOperator.this.getScrollPosition().getX() : (int)ScrollPaneOperator.this.getScrollPosition().getY();
            Point point = SwingUtilities.convertPoint(this.comp, this.x, this.y, ((Container)ScrollPaneOperator.this.getSource()).getComponents()[0]);
            int n3 = this.orientation == 0 ? point.x : point.y;
            int n4 = this.orientation == 0 ? (int)ScrollPaneOperator.this.getViewportSize().getWidth() : (int)ScrollPaneOperator.this.getViewportSize().getHeight();
            int n5 = n = this.orientation == 0 ? this.width : this.height;
            if (n3 <= n2) {
                return -1;
            }
            if (n3 + n > n2 + n4 && n3 > n2) {
                return 1;
            }
            return 0;
        }

        public int getScrollOrientation() {
            return this.orientation;
        }

        public String getDescription() {
            return "";
        }
    }

    private class ValueScrollAdjuster
    implements ScrollAdjuster {
        int value;
        int orientation;
        Adjustable adj;

        public ValueScrollAdjuster(int n, int n2, Adjustable adjustable) {
            this.value = n;
            this.orientation = n2;
            this.adj = adjustable;
        }

        public int getScrollDirection() {
            if (this.adj.getValue() == this.value) {
                return 0;
            }
            return this.adj.getValue() < this.value ? 1 : -1;
        }

        public int getScrollOrientation() {
            return this.orientation;
        }

        public String getDescription() {
            return "Scroll to " + Integer.toString(this.value) + " value";
        }
    }
}

