/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.WindowWaiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.WindowDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class WindowOperator
extends ContainerOperator
implements Outputable {
    TestOut output;
    WindowDriver driver = DriverManager.getWindowDriver(this.getClass());

    public WindowOperator(Window window) {
        super(window);
    }

    public WindowOperator(WindowOperator windowOperator, ComponentChooser componentChooser, int n) {
        this(windowOperator.waitSubWindow(componentChooser, n));
        this.copyEnvironment(windowOperator);
    }

    public WindowOperator(WindowOperator windowOperator, ComponentChooser componentChooser) {
        this(windowOperator, componentChooser, 0);
    }

    public WindowOperator(WindowOperator windowOperator, int n) {
        this(WindowOperator.waitWindow(windowOperator, ComponentSearcher.getTrueChooser("Any Window"), n));
        this.copyEnvironment(windowOperator);
    }

    public WindowOperator(WindowOperator windowOperator) {
        this(windowOperator, 0);
    }

    public WindowOperator(int n, Operator operator) {
        this(WindowOperator.waitWindow(ComponentSearcher.getTrueChooser("Any Window"), n, operator.getTimeouts(), operator.getOutput()));
        this.copyEnvironment(operator);
    }

    public WindowOperator(int n) {
        this(n, WindowOperator.getEnvironmentOperator());
    }

    public WindowOperator() {
        this(0);
    }

    public static Window findWindow(ComponentChooser componentChooser, int n) {
        return WindowWaiter.getWindow(componentChooser, n);
    }

    public static Window findWindow(ComponentChooser componentChooser) {
        return WindowOperator.findWindow(componentChooser, 0);
    }

    public static Window findWindow(Window window, ComponentChooser componentChooser, int n) {
        return WindowWaiter.getWindow(window, componentChooser, n);
    }

    public static Window findWindow(Window window, ComponentChooser componentChooser) {
        return WindowOperator.findWindow(window, componentChooser, 0);
    }

    public static Window waitWindow(ComponentChooser componentChooser, int n) {
        return WindowOperator.waitWindow(componentChooser, n, JemmyProperties.getCurrentTimeouts(), JemmyProperties.getCurrentOutput());
    }

    public static Window waitWindow(ComponentChooser componentChooser) {
        return WindowOperator.waitWindow(componentChooser, 0);
    }

    public static Window waitWindow(Window window, ComponentChooser componentChooser, int n) {
        return WindowOperator.waitWindow(window, componentChooser, n, JemmyProperties.getCurrentTimeouts(), JemmyProperties.getCurrentOutput());
    }

    public static Window waitWindow(Window window, ComponentChooser componentChooser) {
        return WindowOperator.waitWindow(window, componentChooser, 0);
    }

    public void setOutput(TestOut testOut) {
        super.setOutput(testOut);
        this.output = testOut;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (WindowDriver)DriverManager.getDriver("drivers.window", this.getClass(), operator.getProperties());
    }

    public void activate() {
        this.output.printLine("Activate window\n    " + this.getSource().toString());
        this.output.printGolden("Activate window");
        this.driver.activate(this);
    }

    public void close() {
        this.output.printLine("Closing window\n    " + this.getSource().toString());
        this.output.printGolden("Closing window");
        this.driver.close(this);
        if (this.getVerification()) {
            this.waitClosed();
        }
    }

    public void move(int n, int n2) {
        this.output.printLine("Moving frame\n    " + this.getSource().toString());
        this.output.printGolden("Moving frame");
        this.driver.move(this, n, n2);
    }

    public void resize(int n, int n2) {
        this.output.printLine("Resizing frame\n    " + this.getSource().toString());
        this.output.printGolden("Resizing frame");
        this.driver.resize(this, n, n2);
    }

    public Window findSubWindow(ComponentChooser componentChooser, int n) {
        this.getOutput().printLine("Looking for \"" + componentChooser.getDescription() + "\" subwindow");
        return WindowOperator.findWindow((Window)this.getSource(), componentChooser, n);
    }

    public Window findSubWindow(ComponentChooser componentChooser) {
        return this.findSubWindow(componentChooser, 0);
    }

    public Window waitSubWindow(ComponentChooser componentChooser, int n) {
        this.getOutput().printLine("Waiting for \"" + componentChooser.getDescription() + "\" subwindow");
        WindowWaiter windowWaiter = new WindowWaiter();
        windowWaiter.setOutput(this.getOutput());
        windowWaiter.setTimeouts(this.getTimeouts());
        try {
            return windowWaiter.waitWindow((Window)this.getSource(), componentChooser, n);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Waiting for \"" + componentChooser.getDescription() + "\" window has been interrupted", interruptedException);
        }
    }

    public Window waitSubWindow(ComponentChooser componentChooser) {
        return this.waitSubWindow(componentChooser, 0);
    }

    public void waitClosed() {
        this.getOutput().printLine("Wait window to be closed \n    : " + this.getSource().toString());
        this.getOutput().printGolden("Wait window to be closed");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return !component.isVisible();
            }

            public String getDescription() {
                return "Closed window";
            }
        });
    }

    public void addWindowListener(final WindowListener windowListener) {
        this.runMapping(new Operator.MapVoidAction("addWindowListener"){

            public void map() {
                ((Window)WindowOperator.this.getSource()).addWindowListener(windowListener);
            }
        });
    }

    public void applyResourceBundle(final String string) {
        this.runMapping(new Operator.MapVoidAction("applyResourceBundle"){

            public void map() {
                ((Window)WindowOperator.this.getSource()).applyResourceBundle(string);
            }
        });
    }

    public void applyResourceBundle(final ResourceBundle resourceBundle) {
        this.runMapping(new Operator.MapVoidAction("applyResourceBundle"){

            public void map() {
                ((Window)WindowOperator.this.getSource()).applyResourceBundle(resourceBundle);
            }
        });
    }

    public void dispose() {
        this.runMapping(new Operator.MapVoidAction("dispose"){

            public void map() {
                ((Window)WindowOperator.this.getSource()).dispose();
            }
        });
    }

    public Component getFocusOwner() {
        return (Component)this.runMapping(new Operator.MapAction("getFocusOwner"){

            public Object map() {
                return ((Window)WindowOperator.this.getSource()).getFocusOwner();
            }
        });
    }

    public Window[] getOwnedWindows() {
        return (Window[])this.runMapping(new Operator.MapAction("getOwnedWindows"){

            public Object map() {
                return ((Window)WindowOperator.this.getSource()).getOwnedWindows();
            }
        });
    }

    public Window getOwner() {
        return (Window)this.runMapping(new Operator.MapAction("getOwner"){

            public Object map() {
                return ((Window)WindowOperator.this.getSource()).getOwner();
            }
        });
    }

    public String getWarningString() {
        return (String)this.runMapping(new Operator.MapAction("getWarningString"){

            public Object map() {
                return ((Window)WindowOperator.this.getSource()).getWarningString();
            }
        });
    }

    public void pack() {
        this.runMapping(new Operator.MapVoidAction("pack"){

            public void map() {
                ((Window)WindowOperator.this.getSource()).pack();
            }
        });
    }

    public void removeWindowListener(final WindowListener windowListener) {
        this.runMapping(new Operator.MapVoidAction("removeWindowListener"){

            public void map() {
                ((Window)WindowOperator.this.getSource()).removeWindowListener(windowListener);
            }
        });
    }

    public void toBack() {
        this.runMapping(new Operator.MapVoidAction("toBack"){

            public void map() {
                ((Window)WindowOperator.this.getSource()).toBack();
            }
        });
    }

    public void toFront() {
        this.runMapping(new Operator.MapVoidAction("toFront"){

            public void map() {
                ((Window)WindowOperator.this.getSource()).toFront();
            }
        });
    }

    public boolean isFocused() {
        if (System.getProperty("java.specification.version").compareTo("1.3") > 0) {
            return this.runMapping(new Operator.MapBooleanAction("isFocused"){

                public boolean map() {
                    try {
                        return (Boolean)new ClassReference(WindowOperator.this.getSource()).invokeMethod("isFocused", null, null);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        return false;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return false;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        return false;
                    }
                }
            });
        }
        return this.getFocusOwner() != null;
    }

    public boolean isActive() {
        if (System.getProperty("java.specification.version").compareTo("1.3") > 0) {
            return this.runMapping(new Operator.MapBooleanAction("isActive"){

                public boolean map() {
                    try {
                        return (Boolean)new ClassReference(WindowOperator.this.getSource()).invokeMethod("isActive", null, null);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        return false;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return false;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        return false;
                    }
                }
            });
        }
        return this.isShowing();
    }

    protected static Window waitWindow(ComponentChooser componentChooser, int n, Timeouts timeouts, TestOut testOut) {
        try {
            WindowWaiter windowWaiter = new WindowWaiter();
            windowWaiter.setTimeouts(timeouts);
            windowWaiter.setOutput(testOut);
            return windowWaiter.waitWindow(componentChooser, n);
        }
        catch (InterruptedException interruptedException) {
            testOut.printStackTrace(interruptedException);
            return null;
        }
    }

    protected static Window waitWindow(WindowOperator windowOperator, ComponentChooser componentChooser, int n) {
        return WindowOperator.waitWindow((Window)windowOperator.getSource(), componentChooser, n, windowOperator.getTimeouts(), windowOperator.getOutput());
    }

    protected static Window waitWindow(Window window, ComponentChooser componentChooser, int n, Timeouts timeouts, TestOut testOut) {
        try {
            WindowWaiter windowWaiter = new WindowWaiter();
            windowWaiter.setTimeouts(timeouts);
            windowWaiter.setOutput(testOut);
            return windowWaiter.waitWindow(window, componentChooser, n);
        }
        catch (InterruptedException interruptedException) {
            JemmyProperties.getCurrentOutput().printStackTrace(interruptedException);
            return null;
        }
    }
}

