/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Vector;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.WindowWaiter;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.jemmy.util.WindowJob;

public class WindowManager
implements Timeoutable,
Outputable {
    private static long TIME_DELTA = 1000L;
    private static WindowManager manager;
    private Vector jobs;
    private Timeouts timeouts;
    private TestOut output;

    private WindowManager() {
        this.setTimeouts(JemmyProperties.getCurrentTimeouts());
        this.setOutput(JemmyProperties.getCurrentOutput());
        this.jobs = new Vector();
    }

    public static void addJob(WindowJob windowJob) {
        manager.add(windowJob);
    }

    public static void removeJob(WindowJob windowJob) {
        manager.remove(windowJob);
    }

    public static void performJob(WindowJob windowJob) {
        while (manager.performJobOnce(windowJob)) {
        }
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
    }

    public TestOut getOutput() {
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(WindowJob windowJob) {
        this.output.printLine("Starting job \"" + windowJob.getDescription() + "\"");
        Vector vector = this.jobs;
        synchronized (vector) {
            JobThread jobThread = new JobThread(windowJob);
            this.jobs.add(jobThread);
            jobThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(WindowJob windowJob) {
        this.output.printLine("Killing job \"" + windowJob.getDescription() + "\"");
        Vector vector = this.jobs;
        synchronized (vector) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                if (((JobThread)this.jobs.get((int)i)).job != windowJob) continue;
                ((JobThread)this.jobs.get((int)i)).needStop = true;
                this.jobs.remove(i);
            }
        }
    }

    private boolean performJobOnce(WindowJob windowJob) {
        Window window = WindowWaiter.getWindow(windowJob);
        if (window != null) {
            windowJob.launch(window);
            return true;
        }
        return false;
    }

    static {
        Timeouts.initDefault("WindowManager.TimeDelta", TIME_DELTA);
        manager = new WindowManager();
    }

    private static class JobThread
    extends Thread {
        WindowJob job;
        boolean needStop = false;

        public JobThread(WindowJob windowJob) {
            this.job = windowJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean getNS() {
            JobThread jobThread = this;
            synchronized (jobThread) {
                return this.needStop;
            }
        }

        public void run() {
            while (!this.getNS()) {
                manager.performJobOnce(this.job);
                manager.timeouts.sleep("WindowManager.TimeDelta");
            }
        }
    }

    public static class ModalDialogChoosingJob
    implements WindowJob {
        public boolean checkComponent(Component component) {
            return component instanceof Dialog && ((Dialog)component).isModal();
        }

        public Object launch(Object object) {
            new WindowOperator((Window)object).close();
            return null;
        }

        public String getDescription() {
            return "A job of closing modal dialogs";
        }
    }
}

