/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.projects;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.filesystems.FileObject;

public class AntFilesHelper {
    public static final int CURRENT_DEPENDECIES_VERSION = 3;
    public static Map<String, String> dependencies = new HashMap<String, String>();
    public static final String REST_ANT_EXT_NAME_BASE = "rest";
    public static final String REST_ANT_EXT_NAME = AntFilesHelper.getExtensionVersionString(3);
    public static final String REST_BUILD_XSL = "org/netbeans/modules/websvc/rest/resources/rest-build.xsl";
    public static final String REST_BUILD_XML_PATH = "nbproject/rest-build.xml";
    private AntProjectHelper projectHelper;
    private Project project;
    private AntBuildExtender extender;

    public AntFilesHelper(RestSupport restSupport) {
        this(restSupport.getProject(), restSupport.getAntProjectHelper());
    }

    public AntFilesHelper(Project project, AntProjectHelper antProjectHelper) {
        this.projectHelper = antProjectHelper;
        this.project = project;
        this.extender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
        if (this.extender == null) {
            throw new IllegalArgumentException("Given project does not allow extension");
        }
    }

    public void initRestBuildExtension() throws IOException {
        AntBuildExtender.Extension extension;
        boolean bl = this.refreshRestBuildXml();
        FileObject fileObject = this.project.getProjectDirectory().getFileObject(REST_BUILD_XML_PATH);
        if (fileObject != null && (extension = this.extender.getExtension(REST_ANT_EXT_NAME)) == null) {
            extension = this.extender.addExtension(REST_ANT_EXT_NAME, fileObject);
            for (Map.Entry<String, String> entry : dependencies.entrySet()) {
                extension.addDependency(entry.getKey(), entry.getValue());
            }
            bl = true;
        }
        if (this.cleanupLastExtensionVersions()) {
            bl = true;
        }
        if (bl) {
            ProjectManager.getDefault().saveProject(this.project);
        }
    }

    public boolean refreshRestBuildXml() throws IOException {
        URL uRL = this.getClass().getClassLoader().getResource(REST_BUILD_XSL);
        GeneratedFilesHelper generatedFilesHelper = new GeneratedFilesHelper(this.projectHelper);
        return generatedFilesHelper.refreshBuildScript(REST_BUILD_XML_PATH, uRL, true);
    }

    private static String getExtensionVersionString(int n) {
        return "rest." + n;
    }

    public boolean cleanupLastExtensionVersions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = REST_ANT_EXT_NAME_BASE;
        if (this.extender.getExtension(string) != null) {
            arrayList.add(string);
        }
        for (int i = 0; i < 3; ++i) {
            string = AntFilesHelper.getExtensionVersionString(i);
            if (this.extender.getExtension(string) == null) continue;
            arrayList.add(string);
        }
        for (String string2 : arrayList) {
            this.extender.removeExtension(string2);
        }
        return arrayList.size() > 0;
    }
}

