/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffFileEncodingQueryImpl
extends FileEncodingQueryImplementation {
    private Map<File, Charset> fileToCharset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Charset getEncoding(FileObject fileObject) {
        try {
            if (this.fileToCharset == null || this.fileToCharset.isEmpty() || fileObject == null || fileObject.isFolder()) {
                return null;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null) {
                return null;
            }
            Map<File, Charset> map = this.fileToCharset;
            synchronized (map) {
                return this.fileToCharset.get(file);
            }
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(1, throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void associateEncoding(File file, List<File> list) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || fileObject.isFolder()) {
            return;
        }
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        if (charset == null) {
            return;
        }
        if (this.fileToCharset == null) {
            this.fileToCharset = new WeakHashMap<File, Charset>();
        }
        Map<File, Charset> map = this.fileToCharset;
        synchronized (map) {
            for (File file2 : list) {
                this.fileToCharset.put(file2, charset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEncodingForFiles(List<File> list) {
        if (this.fileToCharset == null || list == null || list.size() == 0) {
            return;
        }
        Map<File, Charset> map = this.fileToCharset;
        synchronized (map) {
            for (File file : list) {
                this.fileToCharset.remove(file);
            }
        }
    }
}

