/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeParamsTransformer
extends RefactoringVisitor {
    private Set<ElementHandle<ExecutableElement>> allMethods;
    ChangeParametersRefactoring refactoring;

    public ChangeParamsTransformer(ChangeParametersRefactoring changeParametersRefactoring, Set<ElementHandle<ExecutableElement>> set) {
        this.refactoring = changeParametersRefactoring;
        this.allMethods = set;
    }

    @Override
    public Tree visitNewClass(NewClassTree newClassTree, Element element) {
        Element element2;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null && this.isMethodMatch(element2)) {
            List<ExpressionTree> list = this.getNewArguments(newClassTree.getArguments());
            NewClassTree newClassTree2 = this.make.NewClass(newClassTree.getEnclosingExpression(), newClassTree.getTypeArguments(), newClassTree.getIdentifier(), list, newClassTree.getClassBody());
            this.rewrite(newClassTree, newClassTree2);
        }
        return (Tree)super.visitNewClass(newClassTree, element);
    }

    private List<ExpressionTree> getNewArguments(List<? extends ExpressionTree> list) {
        ArrayList<ExpressionTree> arrayList = new ArrayList<ExpressionTree>();
        ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray = this.refactoring.getParameterInfo();
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            ExpressionTree expressionTree;
            int n = parameterInfoArray[i].getOriginalIndex();
            if (n < 0) {
                String string = parameterInfoArray[i].getDefaultValue();
                SourcePositions[] sourcePositionsArray = new SourcePositions[1];
                expressionTree = this.workingCopy.getTreeUtilities().parseExpression(string, sourcePositionsArray);
            } else {
                if (i == parameterInfoArray.length - 1 && parameterInfoArray[i].getType().endsWith("...")) {
                    for (int j = n; j < list.size(); ++j) {
                        arrayList.add(list.get(j));
                    }
                    break;
                }
                expressionTree = list.get(n);
            }
            arrayList.add(expressionTree);
        }
        return arrayList;
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree methodInvocationTree, Element element) {
        Element element2;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null && this.isMethodMatch(element2)) {
            List<ExpressionTree> list = this.getNewArguments(methodInvocationTree.getArguments());
            MethodInvocationTree methodInvocationTree2 = this.make.MethodInvocation(methodInvocationTree.getTypeArguments(), methodInvocationTree.getMethodSelect(), list);
            this.rewrite(methodInvocationTree, methodInvocationTree2);
        }
        return (Tree)super.visitMethodInvocation(methodInvocationTree, element);
    }

    @Override
    public Tree visitMethod(MethodTree methodTree, Element element) {
        this.renameDeclIfMatch(this.getCurrentPath(), methodTree, element);
        return (Tree)super.visitMethod(methodTree, element);
    }

    private void renameDeclIfMatch(TreePath treePath, Tree tree, Element element) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Element element2 = this.workingCopy.getTrees().getElement(treePath);
        if (this.isMethodMatch(element2)) {
            Tree tree2;
            List<? extends VariableTree> list = methodTree.getParameters();
            ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
            ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray = this.refactoring.getParameterInfo();
            for (int i = 0; i < parameterInfoArray.length; ++i) {
                int n = parameterInfoArray[i].getOriginalIndex();
                tree2 = n < 0 ? this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)parameterInfoArray[i].getName(), (Tree)this.make.Identifier((CharSequence)parameterInfoArray[i].getType()), null) : list.get(parameterInfoArray[i].getOriginalIndex());
                arrayList.add((VariableTree)tree2);
            }
            HashSet<Modifier> hashSet = new HashSet<Modifier>(this.refactoring.getModifiers());
            if (!element2.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                hashSet.remove((Object)Modifier.ABSTRACT);
            }
            ClassTree classTree = (ClassTree)this.workingCopy.getTrees().getTree(element2.getEnclosingElement());
            if (this.workingCopy.getTreeUtilities().isInterface(classTree)) {
                hashSet.remove((Object)Modifier.ABSTRACT);
            }
            tree2 = this.make.Method(this.make.Modifiers(hashSet, methodTree.getModifiers().getAnnotations()), (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), arrayList, methodTree.getThrows(), methodTree.getBody(), (ExpressionTree)methodTree.getDefaultValue());
            this.rewrite(tree, tree2);
            return;
        }
    }

    private boolean isMethodMatch(Element element) {
        if ((element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) && this.allMethods != null) {
            for (ElementHandle<ExecutableElement> elementHandle : this.allMethods) {
                ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)this.workingCopy);
                if (executableElement == null) {
                    Logger.getLogger("org.netbeans.modules.refactoring.java").info("ChangeParamsTransformer cannot resolve " + elementHandle);
                    continue;
                }
                if (!executableElement.equals(element) && !this.workingCopy.getElements().overrides((ExecutableElement)element, executableElement, SourceUtils.getEnclosingTypeElement((Element)executableElement))) continue;
                return true;
            }
        }
        return false;
    }
}

