/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Element;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;

public class DeleteTransformer
extends RefactoringVisitor {
    public Tree visitMethod(MethodTree methodTree, Element element) {
        this.deleteDeclIfMatch(methodTree, element);
        return (Tree)super.visitMethod(methodTree, element);
    }

    public Tree visitClass(ClassTree classTree, Element element) {
        this.deleteDeclIfMatch(classTree, element);
        return (Tree)super.visitClass(classTree, element);
    }

    public Tree visitVariable(VariableTree variableTree, Element element) {
        this.deleteDeclIfMatch(variableTree, element);
        return (Tree)super.visitVariable(variableTree, element);
    }

    private void deleteDeclIfMatch(Tree tree, Element element) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return;
        }
        Element element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        if (((Object)element).equals(element2)) {
            Tree tree2 = this.getCurrentPath().getParentPath().getLeaf();
            Tree tree3 = null;
            if (tree2.getKind() == Tree.Kind.CLASS) {
                tree3 = this.make.removeClassMember((ClassTree)tree2, tree);
            } else if (tree2.getKind() == Tree.Kind.COMPILATION_UNIT) {
                tree3 = this.make.removeCompUnitTypeDecl((CompilationUnitTree)tree2, tree);
            } else if (tree.getKind() == Tree.Kind.VARIABLE) {
                tree3 = tree2.getKind() == Tree.Kind.METHOD ? this.make.removeMethodParameter((MethodTree)tree2, (VariableTree)tree) : this.make.removeBlockStatement((BlockTree)tree2, (StatementTree)((VariableTree)tree));
            }
            if (tree3 != null) {
                this.rewrite(tree2, tree3);
            }
        }
    }
}

