/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.spi.ui;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.spi.ui.JavaRefactoringActionDelegate;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

final class JavaRefactoringGlobalAction
extends NodeAction {
    private final JavaRefactoringActionDelegate delegate;

    public JavaRefactoringGlobalAction(String string, JavaRefactoringActionDelegate javaRefactoringActionDelegate) {
        this.setName(string);
        this.delegate = javaRefactoringActionDelegate;
    }

    public final String getName() {
        return (String)this.getValue("Name");
    }

    protected void setName(String string) {
        this.putValue("Name", string);
    }

    protected void setMnemonic(char c) {
        this.putValue("MnemonicKey", new Integer(c));
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Lookup lookup) {
        return this.delegate.isEnabled(lookup);
    }

    public void performAction(Lookup lookup) {
        EditorCookie editorCookie = JavaRefactoringGlobalAction.getEditorCookie(lookup);
        if (editorCookie != null) {
            new TextComponentRunnable(editorCookie, this.delegate).run();
        }
    }

    protected Lookup getLookup(Node[] abstractLookup) {
        InstanceContent instanceContent = new InstanceContent();
        for (Node node : abstractLookup) {
            instanceContent.add((Object)node);
        }
        AbstractLookup abstractLookup2 = new AbstractLookup((AbstractLookup.Content)instanceContent);
        EditorCookie editorCookie = JavaRefactoringGlobalAction.getEditorCookie((Lookup)abstractLookup2);
        if (editorCookie != null) {
            instanceContent.add((Object)editorCookie);
        }
        instanceContent.add(new Hashtable(0));
        return abstractLookup2;
    }

    static EditorCookie getEditorCookie(Lookup lookup) {
        TopComponent topComponent;
        Node node;
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (editorCookie == null && (node = (Node)lookup.lookup(Node.class)) != null && (editorCookie = (EditorCookie)node.getLookup().lookup(EditorCookie.class)) != null && !((topComponent = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane)) {
            editorCookie = null;
        }
        return editorCookie;
    }

    public final void performAction(Node[] nodeArray) {
        this.performAction(this.getLookup(nodeArray));
    }

    protected boolean enable(Node[] nodeArray) {
        return this.enable(this.getLookup(nodeArray));
    }

    protected boolean asynchronous() {
        return false;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction(lookup);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TextComponentRunnable
    implements Runnable,
    CancellableTask<CompilationController> {
        private final JTextComponent textC;
        private final int caret;
        private final int start;
        private final int end;
        private RefactoringUI ui;
        private final JavaRefactoringActionDelegate delegate;

        public TextComponentRunnable(EditorCookie editorCookie, JavaRefactoringActionDelegate javaRefactoringActionDelegate) {
            this.delegate = javaRefactoringActionDelegate;
            this.textC = editorCookie.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        @Override
        public final void run() {
            JavaSource javaSource;
            try {
                javaSource = JavaSource.forDocument((Document)this.textC.getDocument());
                javaSource.runUserActionTask((Task)this, false);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return;
            }
            javaSource = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)javaSource);
            } else {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)this.delegate.getErrorMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            List<? extends Tree> list;
            TreePath treePath = null;
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            treePath = compilationController.getTreeUtilities().pathFor(this.caret);
            if (treePath.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT && !(list = compilationController.getCompilationUnit().getTypeDecls()).isEmpty()) {
                treePath = TreePath.getPath(compilationController.getCompilationUnit(), list.get(0));
            }
            this.ui = this.delegate.createRefactoringUI(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationController), this.start, this.end, (CompilationInfo)compilationController);
        }
    }

    protected class ContextAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar {
        Lookup context;

        public ContextAction(Lookup lookup) {
            this.context = lookup;
        }

        public Object getValue(String string) {
            return JavaRefactoringGlobalAction.this.getValue(string);
        }

        public void putValue(String string, Object object) {
            JavaRefactoringGlobalAction.this.putValue(string, object);
        }

        public void setEnabled(boolean bl) {
            JavaRefactoringGlobalAction.this.setEnabled(bl);
        }

        public boolean isEnabled() {
            return JavaRefactoringGlobalAction.this.enable(this.context);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            JavaRefactoringGlobalAction.this.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            JavaRefactoringGlobalAction.this.removePropertyChangeListener(propertyChangeListener);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JavaRefactoringGlobalAction.this.performAction(this.context);
        }

        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverridden(JavaRefactoringGlobalAction.this, "getMenuPresenter")) {
                return JavaRefactoringGlobalAction.this.getMenuPresenter();
            }
            return new Actions.MenuItem((Action)this, true);
        }

        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverridden(JavaRefactoringGlobalAction.this, "getPopupPresenter")) {
                return JavaRefactoringGlobalAction.this.getPopupPresenter();
            }
            return new Actions.MenuItem((Action)this, false);
        }

        public Component getToolbarPresenter() {
            if (this.isMethodOverridden(JavaRefactoringGlobalAction.this, "getToolbarPresenter")) {
                return JavaRefactoringGlobalAction.this.getToolbarPresenter();
            }
            return new Actions.ToolbarButton((Action)this);
        }

        private boolean isMethodOverridden(NodeAction nodeAction, String string) {
            try {
                Method method = nodeAction.getClass().getMethod(string, new Class[0]);
                return method.getDeclaringClass() != CallableSystemAction.class;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                throw new IllegalStateException("Error searching for method " + string + " in " + nodeAction);
            }
        }
    }
}

