/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.EncapsulateFieldsRefactoring;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncapsulateFieldPanel
extends JPanel
implements CustomRefactoringPanel {
    private DefaultTableModel model;
    private TreePathHandle selectedObjects;
    private ChangeListener parent;
    private String classname;
    private static boolean ALWAYS_USE_ACCESSORS = true;
    private static int FIELD_ACCESS_INDEX = 3;
    private static int METHOD_ACCESS_INDEX = 0;
    private static final String[] modifierNames = new String[]{"public", "protected", "<default>", "private"};
    private static final String[] columnNames = new String[]{EncapsulateFieldPanel.getString("LBL_ColField"), "    ", EncapsulateFieldPanel.getString("LBL_ColGetter"), "    ", EncapsulateFieldPanel.getString("LBL_ColSetter")};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_DEFAULT_INDEX = 2;
    private static final int MOD_PRIVATE_INDEX = 3;
    private static final Class[] columnTypes = new Class[]{MemberInfo.class, Boolean.class, AccessorInfo.class, Boolean.class, AccessorInfo.class};
    private boolean initialized = false;
    private JButton jButtonSelectAll;
    private JButton jButtonSelectGetters;
    private JButton jButtonSelectNone;
    private JButton jButtonSelectSetters;
    private JCheckBox jCheckAccess;
    private JComboBox jComboAccess;
    private JComboBox jComboField;
    private JComboBox jComboInsertPoint;
    private JComboBox jComboJavadoc;
    private JComboBox jComboSort;
    private JLabel jLblAccessVis;
    private JLabel jLblFieldVis;
    private JLabel jLblInsertPoint;
    private JLabel jLblJavadoc;
    private JLabel jLblSort;
    private JLabel jLblTitle;
    private JScrollPane jScrollField;
    private JTable jTableFields;

    public EncapsulateFieldPanel(TreePathHandle treePathHandle, ChangeListener changeListener) {
        String string = EncapsulateFieldPanel.getString("LBL_TitleEncapsulateFields");
        this.selectedObjects = treePathHandle;
        this.parent = changeListener;
        this.model = new TabM(columnNames, 0);
        this.initComponents();
        this.setName(string);
        this.jCheckAccess.setSelected(ALWAYS_USE_ACCESSORS);
        this.jComboAccess.setSelectedIndex(METHOD_ACCESS_INDEX);
        this.jComboField.setSelectedIndex(FIELD_ACCESS_INDEX);
        this.jTableFields.setDefaultRenderer(MemberInfo.class, new EncapsulateMemberInfoTableCellRenderer());
        this.jTableFields.setDefaultRenderer(AccessorInfo.class, new AccessorInfoRenderer());
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.selectedObjects.getFileObject());
        this.jTableFields.setDefaultEditor(AccessorInfo.class, new AccessorInfoTableEditor(javaSource));
        this.jScrollField.setBackground(this.jTableFields.getBackground());
        this.jScrollField.getViewport().setBackground(this.jTableFields.getBackground());
        this.jTableFields.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.jTableFields.setGridColor(UIManager.getColor("control"));
        }
        EncapsulateFieldPanel.initEnumCombo(this.jComboSort, SortBy.PAIRS);
        EncapsulateFieldPanel.initEnumCombo(this.jComboJavadoc, Javadoc.DEFAULT);
    }

    public Component getComponent() {
        return this;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.selectedObjects.getFileObject());
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    EncapsulateFieldPanel.this.initialize(compilationController);
                }
            }, true);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public void initialize(CompilationController compilationController) {
        TreePath treePath = this.selectedObjects.resolve((CompilationInfo)compilationController);
        Element element = compilationController.getTrees().getElement(treePath);
        int n = 0;
        for (VariableElement variableElement : this.initFields(treePath, (CompilationInfo)compilationController)) {
            TreePath treePath2 = compilationController.getTrees().getPath(variableElement);
            boolean bl = element == variableElement;
            boolean bl2 = bl && !variableElement.getModifiers().contains((Object)Modifier.FINAL);
            String string = EncapsulateFieldRefactoringPlugin.computeGetterName(variableElement);
            String string2 = EncapsulateFieldRefactoringPlugin.computeSetterName(variableElement);
            this.model.addRow(new Object[]{MemberInfo.create(treePath2, (CompilationInfo)compilationController), bl ? Boolean.TRUE : Boolean.FALSE, AccessorInfo.createGetter((CompilationInfo)compilationController, variableElement, string), bl2 ? Boolean.TRUE : Boolean.FALSE, AccessorInfo.createSetter((CompilationInfo)compilationController, variableElement, string2)});
            if (!bl) continue;
            n = this.model.getRowCount() - 1;
        }
        this.packRows(this.jTableFields);
        this.setColumnWidth(1);
        this.setColumnWidth(3);
        this.jTableFields.changeSelection(n, 0, false, false);
        this.jTableFields.invalidate();
        this.jTableFields.repaint();
        this.model.addTableModelListener(new TableModelListener(){
            boolean isUpdating = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (this.isUpdating) {
                    return;
                }
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getFirstRow();
                if (n == 1 || n == 3) {
                    AccessorInfo accessorInfo;
                    Boolean bl = (Boolean)EncapsulateFieldPanel.this.model.getValueAt(n2, n);
                    if (bl.booleanValue() && (accessorInfo = (AccessorInfo)EncapsulateFieldPanel.this.model.getValueAt(n2, n + 1)) != null) {
                        accessorInfo.reset();
                    }
                    try {
                        this.isUpdating = true;
                        EncapsulateFieldPanel.this.model.fireTableCellUpdated(n2, n + 1);
                    }
                    finally {
                        this.isUpdating = false;
                    }
                }
                AccessorInfo accessorInfo = (AccessorInfo)EncapsulateFieldPanel.this.model.getValueAt(n2, n);
                if (!(this.isUpdating || accessorInfo != null && accessorInfo.name != null && accessorInfo.name.length() != 0)) {
                    try {
                        this.isUpdating = true;
                        EncapsulateFieldPanel.this.model.setValueAt(Boolean.FALSE, n2, n - 1);
                    }
                    finally {
                        this.isUpdating = false;
                    }
                }
                EncapsulateFieldPanel.this.parent.stateChanged(null);
            }
        });
        this.initInsertPoints(treePath, (CompilationInfo)compilationController);
        this.initialized = true;
    }

    private void setColumnWidth(int n) {
        TableColumn tableColumn = this.jTableFields.getColumnModel().getColumn(n);
        JCheckBox jCheckBox = new JCheckBox();
        int n2 = (int)jCheckBox.getPreferredSize().getWidth();
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setResizable(false);
    }

    private int getMinimumRowHeight(JTable jTable, int n) {
        int n2 = jTable.getRowHeight();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, i);
            Component component = jTable.prepareRenderer(tableCellRenderer, n, i);
            int n3 = component.getMinimumSize().height;
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    private void packRows(JTable jTable) {
        int n = 0;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n2 = this.getMinimumRowHeight(jTable, i);
            if (n2 <= n) continue;
            n = n2;
        }
        jTable.setRowHeight(n);
        jTable.getTableHeader().setPreferredSize(new Dimension(jTable.getTableHeader().getPreferredSize().width, n));
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    private void initComponents() {
        this.jLblTitle = new JLabel();
        this.jButtonSelectAll = new JButton();
        this.jButtonSelectNone = new JButton();
        this.jButtonSelectGetters = new JButton();
        this.jButtonSelectSetters = new JButton();
        this.jLblInsertPoint = new JLabel();
        this.jComboInsertPoint = new JComboBox();
        this.jLblSort = new JLabel();
        this.jComboSort = new JComboBox();
        this.jLblJavadoc = new JLabel();
        this.jComboJavadoc = new JComboBox();
        this.jLblFieldVis = new JLabel();
        this.jComboField = new JComboBox();
        this.jLblAccessVis = new JLabel();
        this.jComboAccess = new JComboBox();
        this.jCheckAccess = new JCheckBox();
        this.jScrollField = new JScrollPane();
        this.jTableFields = new JTable();
        this.jLblTitle.setLabelFor(this.jTableFields);
        Mnemonics.setLocalizedText((JLabel)this.jLblTitle, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_FieldList"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectAll, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectAll.text"));
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncapsulateFieldPanel.this.jButtonSelectAllActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectNone, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectNone.text"));
        this.jButtonSelectNone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncapsulateFieldPanel.this.jButtonSelectNoneActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectGetters, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectGetters.text"));
        this.jButtonSelectGetters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncapsulateFieldPanel.this.jButtonSelectGettersActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectSetters, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectSetters.text"));
        this.jButtonSelectSetters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncapsulateFieldPanel.this.jButtonSelectSettersActionPerformed(actionEvent);
            }
        });
        this.jLblInsertPoint.setLabelFor(this.jComboInsertPoint);
        Mnemonics.setLocalizedText((JLabel)this.jLblInsertPoint, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblInsertPoint.text"));
        this.jLblSort.setLabelFor(this.jComboSort);
        Mnemonics.setLocalizedText((JLabel)this.jLblSort, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblSort.text"));
        this.jLblJavadoc.setLabelFor(this.jComboJavadoc);
        Mnemonics.setLocalizedText((JLabel)this.jLblJavadoc, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblJavadoc.text"));
        this.jLblFieldVis.setLabelFor(this.jComboField);
        Mnemonics.setLocalizedText((JLabel)this.jLblFieldVis, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_FieldVis"));
        this.jComboField.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jLblAccessVis.setLabelFor(this.jComboAccess);
        Mnemonics.setLocalizedText((JLabel)this.jLblAccessVis, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_AccessVis"));
        this.jComboAccess.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jCheckAccess.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckAccess, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_AccessorsEven"));
        this.jTableFields.setModel(this.model);
        this.jTableFields.setCellSelectionEnabled(true);
        this.jTableFields.setSelectionMode(0);
        this.jTableFields.getTableHeader().setReorderingAllowed(false);
        this.jScrollField.setViewportView(this.jTableFields);
        this.jTableFields.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_jTableFields"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jCheckAccess)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLblTitle)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLblAccessVis).add((Component)this.jLblFieldVis).add((Component)this.jLblInsertPoint).add((Component)this.jLblSort).add((Component)this.jLblJavadoc)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jComboInsertPoint, 0, 546, Short.MAX_VALUE).add((Component)this.jComboSort, -2, -1, -2).add((Component)this.jComboJavadoc, -2, -1, -2).add((Component)this.jComboField, -2, -1, -2).add((Component)this.jComboAccess, -2, -1, -2))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollField, -1, 234, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jButtonSelectSetters).add((Component)this.jButtonSelectNone).add((Component)this.jButtonSelectAll).add((Component)this.jButtonSelectGetters)))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.jButtonSelectAll, this.jButtonSelectGetters, this.jButtonSelectNone, this.jButtonSelectSetters}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLblTitle).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jButtonSelectAll).addPreferredGap(0).add((Component)this.jButtonSelectNone).addPreferredGap(0).add((Component)this.jButtonSelectGetters).addPreferredGap(0).add((Component)this.jButtonSelectSetters)).add((Component)this.jScrollField, -2, 135, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLblInsertPoint).add((Component)this.jComboInsertPoint, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLblSort).add((Component)this.jComboSort, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLblJavadoc).add((Component)this.jComboJavadoc, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLblFieldVis).add((Component)this.jComboField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLblAccessVis).add((Component)this.jComboAccess, -2, -1, -2)).addPreferredGap(0).add((Component)this.jCheckAccess).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonSelectAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectAll.acsd"));
        this.jButtonSelectNone.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectNone.acsd"));
        this.jButtonSelectGetters.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectGetters.acsd"));
        this.jButtonSelectSetters.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectSetters.acsd"));
        this.jComboInsertPoint.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboInsertPoint.acsd"));
        this.jComboSort.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboSort.acsd"));
        this.jComboJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboJavadoc.acsd"));
        this.jComboField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_fieldModifiers"));
        this.jComboAccess.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_methodAcc"));
        this.jCheckAccess.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_useAccessors"));
    }

    private void jButtonSelectAllActionPerformed(ActionEvent actionEvent) {
        this.makeSelection(true, 1, 3);
    }

    private void jButtonSelectNoneActionPerformed(ActionEvent actionEvent) {
        this.makeSelection(false, 1, 3);
    }

    private void jButtonSelectGettersActionPerformed(ActionEvent actionEvent) {
        this.makeSelection(true, 1);
    }

    private void jButtonSelectSettersActionPerformed(ActionEvent actionEvent) {
        this.makeSelection(true, 3);
    }

    private static String getString(String string) {
        return NbBundle.getMessage(EncapsulateFieldPanel.class, (String)string);
    }

    private static <E extends Enum<E>> void initEnumCombo(JComboBox jComboBox, E e) {
        Vector vector = new Vector(EnumSet.allOf(e.getClass()));
        Collections.sort(vector, (Comparator)((Object)e));
        jComboBox.setModel(new DefaultComboBoxModel(vector));
        jComboBox.setSelectedItem(e);
    }

    private void makeSelection(boolean bl, int ... nArray) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            for (int n : nArray) {
                boolean bl2 = (Boolean)this.model.getValueAt(i, n);
                if (bl == bl2) continue;
                this.model.setValueAt(bl, i, n);
            }
        }
    }

    private List<VariableElement> initFields(TreePath treePath, CompilationInfo compilationInfo) {
        Element element = compilationInfo.getTrees().getElement(treePath);
        TypeElement typeElement = null;
        typeElement = ElementKind.FIELD == element.getKind() ? (TypeElement)element.getEnclosingElement() : (TypeElement)element;
        ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
        for (Element element2 : typeElement.getEnclosedElements()) {
            if (ElementKind.FIELD != element2.getKind()) continue;
            arrayList.add((VariableElement)element2);
        }
        this.classname = typeElement.getQualifiedName().toString();
        String string = " - " + this.classname;
        this.setName(this.getName() + (String)string);
        return arrayList;
    }

    private void initInsertPoints(TreePath treePath, CompilationInfo compilationInfo) {
        Element element = compilationInfo.getTrees().getElement(treePath);
        TypeElement typeElement = null;
        typeElement = ElementKind.FIELD == element.getKind() ? (TypeElement)element.getEnclosingElement() : (TypeElement)element;
        ArrayList<InsertPoint> arrayList = new ArrayList<InsertPoint>();
        int n = 0;
        TreePath treePath2 = compilationInfo.getTrees().getPath(typeElement);
        ClassTree classTree = (ClassTree)treePath2.getLeaf();
        for (Tree object : classTree.getMembers()) {
            Element element2;
            if (object.getKind() == Tree.Kind.METHOD && (element2 = compilationInfo.getTrees().getElement(new TreePath(treePath2, object))) != null && !compilationInfo.getElementUtilities().isSynthetic(element2)) {
                InsertPoint insertPoint = new InsertPoint(n + 1, NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"MSG_EncapsulateFieldInsertPointMethod", (Object)MemberInfo.create(element2, compilationInfo).getHtmlText()));
                arrayList.add(insertPoint);
            }
            ++n;
        }
        this.jComboInsertPoint.addItem(InsertPoint.DEFAULT);
        if (!arrayList.isEmpty()) {
            this.jComboInsertPoint.addItem(new InsertPoint(((InsertPoint)arrayList.get(0)).index - 1, EncapsulateFieldPanel.getString("EncapsulateFieldPanel.jComboInsertPoint.first")));
            this.jComboInsertPoint.addItem(new InsertPoint(((InsertPoint)arrayList.get(arrayList.size() - 1)).index, EncapsulateFieldPanel.getString("EncapsulateFieldPanel.jComboInsertPoint.last")));
            for (InsertPoint insertPoint : arrayList) {
                this.jComboInsertPoint.addItem(insertPoint);
            }
        }
        this.jComboInsertPoint.setSelectedItem(InsertPoint.DEFAULT);
    }

    public Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> getAllFields() {
        ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> arrayList = new ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo>();
        Vector<Vector> vector = this.model.getDataVector();
        for (List list : vector) {
            String string;
            String string2 = (Boolean)list.get(1) != false ? ((AccessorInfo)list.get((int)2)).name : null;
            String string3 = string = (Boolean)list.get(3) != false ? ((AccessorInfo)list.get((int)4)).name : null;
            if (string2 == null && string == null) continue;
            MemberInfo memberInfo = (MemberInfo)list.get(0);
            arrayList.add(new EncapsulateFieldsRefactoring.EncapsulateFieldInfo((TreePathHandle)memberInfo.getElementHandle(), "".equals(string2) ? null : string2, "".equals(string) ? null : string));
        }
        return arrayList;
    }

    public boolean isCheckAccess() {
        ALWAYS_USE_ACCESSORS = this.jCheckAccess.isSelected();
        return ALWAYS_USE_ACCESSORS;
    }

    public Set<Modifier> getFieldModifiers() {
        FIELD_ACCESS_INDEX = this.jComboField.getSelectedIndex();
        Modifier modifier = this.getModifier(FIELD_ACCESS_INDEX);
        if (modifier == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(modifier);
    }

    public Set<Modifier> getMethodModifiers() {
        METHOD_ACCESS_INDEX = this.jComboAccess.getSelectedIndex();
        Modifier modifier = this.getModifier(METHOD_ACCESS_INDEX);
        if (modifier == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(modifier);
    }

    private Modifier getModifier(int n) {
        switch (n) {
            case 3: {
                return Modifier.PRIVATE;
            }
            case 2: {
                return null;
            }
            case 1: {
                return Modifier.PROTECTED;
            }
            case 0: {
                return Modifier.PUBLIC;
            }
        }
        throw new IllegalStateException("unknown index: " + n);
    }

    public InsertPoint getInsertPoint() {
        return (InsertPoint)this.jComboInsertPoint.getSelectedItem();
    }

    public SortBy getSortBy() {
        return (SortBy)this.jComboSort.getSelectedItem();
    }

    public Javadoc getJavadoc() {
        return (Javadoc)this.jComboJavadoc.getSelectedItem();
    }

    String getClassname() {
        return this.classname;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AccessorInfoTableEditor
    extends DefaultCellEditor
    implements Task<CompilationController> {
        private AccessorInfo ai;
        private JavaSource js;

        public AccessorInfoTableEditor(JavaSource javaSource) {
            super(new JTextField());
            this.js = javaSource;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.ai = (AccessorInfo)object;
            if (this.ai == null) {
                throw new IllegalStateException();
            }
            String string = this.ai == null ? null : this.ai.name;
            return super.getTableCellEditorComponent(jTable, string, bl, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            AccessorInfo accessorInfo;
            String string = (String)super.getCellEditorValue();
            if (string == null || string.length() == 0) {
                if (this.ai != null || this.ai.name != null && this.ai.name.length() > 0) {
                    this.ai.name = null;
                    this.ai.accessor = null;
                    this.ai.accessorToolTip = null;
                }
                accessorInfo = this.ai;
            } else {
                if (!string.equals(this.ai.name)) {
                    this.computeNewValue();
                }
                accessorInfo = this.ai;
            }
            return accessorInfo;
        }

        private void computeNewValue() {
            try {
                this.js.runUserActionTask((Task)this, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void run(CompilationController compilationController) throws Exception {
            AccessorInfo accessorInfo = this.ai;
            if (accessorInfo == null) {
                return;
            }
            accessorInfo.setName((CompilationInfo)compilationController, ((String)super.getCellEditorValue()).trim());
        }
    }

    private static final class AccessorInfoRenderer
    extends UIUtilities.JavaElementTableCellRenderer {
        private AccessorInfoRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            AccessorInfo accessorInfo = (AccessorInfo)object;
            String string = accessorInfo == null ? null : (accessorInfo.accessor == null ? accessorInfo.name : accessorInfo.accessor);
            Component component = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            String string2 = accessorInfo != null && jTable.isCellEditable(n, n2) ? accessorInfo.accessorToolTip : null;
            boolean bl3 = (Boolean)jTable.getModel().getValueAt(n, n2 - 1);
            this.setEnabled(bl3);
            if (bl3 && accessorInfo != null && !accessorInfo.isGetter && ((MemberInfo)jTable.getValueAt(n, 0)).getModifiers().contains((Object)Modifier.FINAL) && (object2 = UIManager.getDefaults().get("nb.errorForeground")) instanceof Color) {
                this.setBorder(BorderFactory.createLineBorder((Color)object2));
                String string3 = NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"MSG_EncapsulateFieldFinalFieldWarning");
                string2 = string2 == null ? string3 : String.format("<html>%s<br>%s</html>", string3, string2);
            }
            this.setToolTipText(string2);
            return component;
        }
    }

    private static final class EncapsulateMemberInfoTableCellRenderer
    extends UIUtilities.JavaElementTableCellRenderer {
        private EncapsulateMemberInfoTableCellRenderer() {
        }

        protected String extractText(Object object) {
            String string = super.extractText(object);
            string = string != null && object instanceof MemberInfo && ((MemberInfo)object).getModifiers().contains((Object)Modifier.FINAL) ? string + " : final" : string;
            return string;
        }
    }

    public static final class InsertPoint {
        public static final InsertPoint DEFAULT = new InsertPoint(Integer.MIN_VALUE, EncapsulateFieldPanel.access$1100("EncapsulateFieldPanel.jComboInsertPoint.default"));
        private int index;
        private String description;

        private InsertPoint(int n, String string) {
            this.index = n;
            this.description = string;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Javadoc implements Comparator<Javadoc>
    {
        DEFAULT("EncapsulateFieldPanel.jComboJavadoc.createDefault"),
        NONE("EncapsulateFieldPanel.jComboJavadoc.none"),
        COPY("EncapsulateFieldPanel.jComboJavadoc.copy");

        private final String displayName;

        private Javadoc(String string2) {
            this.displayName = EncapsulateFieldPanel.getString(string2);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compare(Javadoc javadoc, Javadoc javadoc2) {
            if (javadoc == javadoc2) {
                return 0;
            }
            if (javadoc == null) {
                return -1;
            }
            if (javadoc2 == null) {
                return 1;
            }
            return javadoc.toString().compareTo(javadoc2.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortBy implements Comparator<SortBy>
    {
        PAIRS("EncapsulateFieldPanel.jComboSort.pairs"),
        ALPHABETICALLY("EncapsulateFieldPanel.jComboSort.alphabetically"),
        GETTERS_FIRST("EncapsulateFieldPanel.jComboSort.gettersFirst");

        private final String displayName;

        private SortBy(String string2) {
            this.displayName = EncapsulateFieldPanel.getString(string2);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compare(SortBy sortBy, SortBy sortBy2) {
            if (sortBy == sortBy2) {
                return 0;
            }
            if (sortBy == null) {
                return -1;
            }
            if (sortBy2 == null) {
                return 1;
            }
            return sortBy.toString().compareTo(sortBy2.toString());
        }
    }

    private static final class AccessorInfo {
        String defaultName;
        MemberInfo<ElementHandle<ExecutableElement>> defaultAccessor;
        String name;
        String accessorToolTip;
        String defaultAccessorToolTip;
        MemberInfo<ElementHandle<ExecutableElement>> accessor;
        private ElementHandle<VariableElement> fieldHandle;
        private boolean isGetter;

        private AccessorInfo() {
        }

        public static AccessorInfo createGetter(CompilationInfo compilationInfo, VariableElement variableElement, String string) {
            ExecutableElement executableElement = EncapsulateFieldRefactoringPlugin.findMethod(compilationInfo, (TypeElement)variableElement.getEnclosingElement(), string, Collections.emptyList(), true);
            return AccessorInfo.create(compilationInfo, variableElement, executableElement, string, true);
        }

        public static AccessorInfo createSetter(CompilationInfo compilationInfo, VariableElement variableElement, String string) {
            ExecutableElement executableElement = EncapsulateFieldRefactoringPlugin.findMethod(compilationInfo, (TypeElement)variableElement.getEnclosingElement(), string, Collections.singletonList(variableElement), true);
            return AccessorInfo.create(compilationInfo, variableElement, executableElement, string, false);
        }

        private static AccessorInfo create(CompilationInfo compilationInfo, VariableElement variableElement, ExecutableElement executableElement, String string, boolean bl) {
            AccessorInfo accessorInfo = new AccessorInfo();
            accessorInfo.name = accessorInfo.defaultName = string;
            accessorInfo.defaultAccessor = executableElement != null ? MemberInfo.create(executableElement, compilationInfo) : null;
            accessorInfo.accessor = accessorInfo.defaultAccessor;
            accessorInfo.defaultAccessorToolTip = executableElement != null ? NbBundle.getMessage(EncapsulateFieldPanel.class, (String)(bl ? "MSG_EncapsulateFieldDeclaredGetter" : "MSG_EncapsulateFieldDeclaredSetter"), (Object)ElementHeaders.getHeader((Element)executableElement.getEnclosingElement(), (CompilationInfo)compilationInfo, (String)"%name%")) : null;
            accessorInfo.accessorToolTip = accessorInfo.defaultAccessorToolTip;
            accessorInfo.isGetter = bl;
            accessorInfo.fieldHandle = ElementHandle.create((Element)variableElement);
            return accessorInfo;
        }

        public void reset() {
            this.name = this.defaultName;
            this.accessor = this.defaultAccessor;
            this.accessorToolTip = this.defaultAccessorToolTip;
        }

        public void setName(CompilationInfo compilationInfo, String string) {
            this.name = string;
            VariableElement variableElement = (VariableElement)this.fieldHandle.resolve(compilationInfo);
            ExecutableElement executableElement = null;
            executableElement = this.isGetter ? EncapsulateFieldRefactoringPlugin.findMethod(compilationInfo, (TypeElement)variableElement.getEnclosingElement(), string, Collections.emptyList(), true) : EncapsulateFieldRefactoringPlugin.findMethod(compilationInfo, (TypeElement)variableElement.getEnclosingElement(), string, Collections.singletonList(variableElement), true);
            MemberInfo<ElementHandle<ExecutableElement>> memberInfo = this.accessor = executableElement != null ? MemberInfo.create(executableElement, compilationInfo) : null;
            this.accessorToolTip = executableElement != null ? NbBundle.getMessage(EncapsulateFieldPanel.class, (String)(this.isGetter ? "MSG_EncapsulateFieldDeclaredGetter" : "MSG_EncapsulateFieldDeclaredSetter"), (Object)ElementHeaders.getHeader((Element)executableElement.getEnclosingElement(), (CompilationInfo)compilationInfo, (String)"%name%")) : null;
        }
    }

    private static class TabM
    extends DefaultTableModel {
        public TabM(Object[] objectArray, int n) {
            super(objectArray, n);
        }

        public Class getColumnClass(int n) {
            return columnTypes[n];
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            if (n2 == 1 || n2 == 3) {
                return true;
            }
            return (Boolean)this.getValueAt(n, n2 - 1);
        }
    }
}

