/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.impl.CachedRowSetDataProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.ResultSetMetaData;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class MetaDataSerializer {
    private static Logger LOGGER = Logger.getLogger(CachedRowSetDataProvider.class.getName());
    private static ResourceBundle bundle = ResourceBundle.getBundle("com.sun.data.provider.impl.Bundle", Locale.getDefault(), MetaDataSerializer.class.getClassLoader());

    public String generateMetaDataName(String serFileName) {
        File cachedMetadataUserdirFolder = new File(System.getProperty("netbeans.user") + File.separator + "config" + File.separator + "Databases" + File.separator + "CachedMetadata");
        if (!cachedMetadataUserdirFolder.exists()) {
            cachedMetadataUserdirFolder.mkdir();
        }
        return cachedMetadataUserdirFolder + File.separator + serFileName + ".ser";
    }

    public boolean mdFileNameExists(String mdFileName) {
        return new File(mdFileName).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(ResultSetMetaData resultSetMetaData, String mdFileName) {
        mdFileName = mdFileName.replaceAll("\\n", "");
        if (resultSetMetaData != null) {
            ObjectOutputStream os = null;
            try {
                os = new ObjectOutputStream(new FileOutputStream(mdFileName));
                os.writeObject(resultSetMetaData);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public String generateFilename(String dataSourceName, String command) throws NamingException {
        if (dataSourceName == null) {
            throw new NamingException(bundle.getString("NAME_NOT_FOUND"));
        }
        String name = (dataSourceName = dataSourceName.replaceFirst("java:comp/env/jdbc/", "")) + command;
        int hashValue = name.hashCode();
        name = hashValue < 0 ? "_" + Math.abs(hashValue) : new Integer(hashValue).toString();
        return name;
    }
}

