/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project;

import java.awt.Dialog;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.projects.base.ui.NoSelectedServerWarning;
import org.netbeans.modules.compapp.projects.base.ui.customizer.IcanproProjectProperties;
import org.netbeans.modules.sql.project.SQLproProject;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class SQLproActionProvider
implements ActionProvider {
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "delete", "copy", "move", "rename"};
    SQLproProject project;
    private AntProjectHelper antProjectHelper;
    private ReferenceHelper refHelper;
    Map commands = new HashMap();

    public SQLproActionProvider(SQLproProject sQLproProject, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.antProjectHelper = antProjectHelper;
        this.project = sQLproProject;
        this.refHelper = referenceHelper;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject(this.project.getBuildXmlName());
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    String[] getTargetNames(String string, Lookup lookup, Properties properties) throws IllegalArgumentException {
        String[] stringArray = (String[])this.commands.get(string);
        return stringArray;
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        Properties properties = null;
        String[] stringArray = (String[])this.commands.get(string);
        if (string.equals("deploy") || string.equals("redeploy")) {
            if (!this.isSelectedServer()) {
                return;
            }
        } else {
            properties = null;
            if (stringArray == null) {
                throw new IllegalArgumentException(string);
            }
        }
        try {
            ActionUtils.runTarget((FileObject)this.findBuildXml(), (String[])stringArray, properties);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        return this.findBuildXml() != null;
    }

    private boolean isDebugged() {
        return false;
    }

    private boolean isSelectedServer() {
        boolean bl;
        String string = this.antProjectHelper.getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (string != null) {
            bl = true;
        } else {
            String string2 = this.antProjectHelper.getStandardPropertyEvaluator().getProperty("j2ee.server.type");
            NoSelectedServerWarning noSelectedServerWarning = new NoSelectedServerWarning(string2);
            Object[] objectArray = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)noSelectedServerWarning, NbBundle.getMessage(NoSelectedServerWarning.class, (String)"CTL_NoSelectedServerWarning_Title"), true, objectArray, objectArray[0], 0, null, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() != objectArray[0]) {
                bl = false;
            } else {
                string = noSelectedServerWarning.getSelectedInstance();
                boolean bl2 = bl = string != null;
                if (bl) {
                    IcanproProjectProperties icanproProjectProperties = new IcanproProjectProperties((Project)this.project, this.antProjectHelper, this.refHelper);
                    icanproProjectProperties.put("j2ee.server.instance", (Object)string);
                    icanproProjectProperties.store();
                }
            }
            dialog.dispose();
        }
        return bl;
    }
}

