/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.dbmodel;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DriverTypes {
    private static final TypeInfo[] TYPES = new TypeInfo[]{new TypeInfo("Oracle", "oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@<host>:<port>:<sid>"), new TypeInfo("SeeBeyond (DataDirect)", "com.SeeBeyond.oracle.jdbc.oracle.OracleDriver", "jdbc:SeeBeyond:oracle://<host>:<port>;SID=<sid>"), new TypeInfo("OracleOCI", "oracle.jdbc.OracleDriver", "jdbc:oracle:oci8:@<tns>##setTNSEntry#<tns>")};
    private static HashMap typeMap = new HashMap();

    public static Collection getDisplayNames() {
        return typeMap.keySet();
    }

    public static List getTypeInfoList() {
        return TYPES != null ? Collections.unmodifiableList(Arrays.asList(TYPES)) : Collections.EMPTY_LIST;
    }

    public static TypeInfo getTypeInfo(String string) {
        Object v = typeMap.get(string);
        return v != null ? (TypeInfo)v : null;
    }

    public static final String makeUrl(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = null;
        TypeInfo typeInfo = DriverTypes.getTypeInfo(string);
        if (typeInfo != null) {
            StringBuffer stringBuffer = new StringBuffer(typeInfo.getURLTemplate());
            String string8 = DriverTypes.getSubstVar(stringBuffer);
            while (string8 != null) {
                if (string8.equalsIgnoreCase("host")) {
                    DriverTypes.replaceSubstVar(stringBuffer, string8, string2);
                } else if (string8.equalsIgnoreCase("port")) {
                    DriverTypes.replaceSubstVar(stringBuffer, string8, string3);
                } else if (string8.equalsIgnoreCase("sid")) {
                    DriverTypes.replaceSubstVar(stringBuffer, string8, string4);
                } else if (string8.equalsIgnoreCase("username")) {
                    DriverTypes.replaceSubstVar(stringBuffer, string8, string5);
                } else if (string8.equalsIgnoreCase("password")) {
                    DriverTypes.replaceSubstVar(stringBuffer, string8, string6);
                }
                string8 = DriverTypes.getSubstVar(stringBuffer);
            }
            string7 = stringBuffer.toString();
        }
        return string7;
    }

    public static final String makeUrl(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8 = null;
        TypeInfo typeInfo = DriverTypes.getTypeInfo(string);
        if (typeInfo != null) {
            StringBuffer stringBuffer = new StringBuffer(typeInfo.getURLTemplate());
            String string9 = DriverTypes.getSubstVar(stringBuffer);
            while (string9 != null) {
                if (string9.equalsIgnoreCase("host")) {
                    DriverTypes.replaceSubstVar(stringBuffer, string9, string2);
                } else if (string9.equalsIgnoreCase("port")) {
                    DriverTypes.replaceSubstVar(stringBuffer, string9, string3);
                } else if (string9.equalsIgnoreCase("sid")) {
                    DriverTypes.replaceSubstVar(stringBuffer, string9, string4);
                } else if (string9.equalsIgnoreCase("username")) {
                    DriverTypes.replaceSubstVar(stringBuffer, string9, string5);
                } else if (string9.equalsIgnoreCase("password")) {
                    DriverTypes.replaceSubstVar(stringBuffer, string9, string6);
                } else if (string9.equalsIgnoreCase("tns")) {
                    DriverTypes.replaceSubstVar(stringBuffer, string9, string7);
                }
                string9 = DriverTypes.getSubstVar(stringBuffer);
            }
            string8 = stringBuffer.toString();
        }
        return string8;
    }

    private static final String getSubstVar(StringBuffer stringBuffer) {
        String string = null;
        int n = stringBuffer.indexOf("<");
        int n2 = stringBuffer.indexOf(">");
        if (n != -1 && n2 != -1 && n < n2 + 1) {
            string = stringBuffer.substring(n + 1, n2);
        }
        return string;
    }

    private static final void replaceSubstVar(StringBuffer stringBuffer, String string, String string2) {
        String string3 = "<" + string + ">";
        int n = stringBuffer.indexOf(string3);
        if (n != -1) {
            stringBuffer.delete(n, n + string3.length());
            stringBuffer.insert(n, string2);
        }
    }

    static {
        for (int i = 0; i < TYPES.length; ++i) {
            TypeInfo typeInfo = TYPES[i];
            typeMap.put(typeInfo.getDisplayName(), typeInfo);
        }
        if (TYPES.length != typeMap.keySet().size()) {
            throw new IllegalStateException("Count of display names does not match count of driver TypeInfo instances!");
        }
    }

    public static class TypeInfo {
        private String displayName;
        private String className;
        private String urlTemplate;
        private File jarFile;

        public TypeInfo(String string, String string2, String string3) {
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException("Must supply non-empty String instance for display argument.");
            }
            if (string2 == null || string2.trim().length() == 0) {
                throw new IllegalArgumentException("Must supply non-empty String instance for driverClass argument.");
            }
            if (string3 == null || string3.trim().length() == 0) {
                throw new IllegalArgumentException("Must supply non-empty String instance for urlString argument.");
            }
            this.displayName = string;
            this.className = string2;
            this.urlTemplate = string3;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDriverClassName() {
            return this.className;
        }

        public String getURLTemplate() {
            return this.urlTemplate;
        }

        public File getDriverJarFile() {
            return this.jarFile;
        }

        public void setDriverJarFile(File file) {
            this.jarFile = file;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

