/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.wsdl;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.sql.project.wsdl.FileUtil;
import org.netbeans.modules.sql.project.wsdl.SQLMapEntry;
import org.netbeans.modules.sql.project.wsdl.SQLMapReader;

public class JBIFileWriter {
    private String mJbiDescriptorFile;
    private String sqlMapFile;
    private String mbuildDir;
    private Map prefixTable = new HashMap();
    private Map nsTable = new HashMap();
    private FileOutputStream fos = null;
    public static final String JBI_EXT_NS = "http://www.sun.com/jbi/descriptor/service-unit";
    public static final String JBI_EXT_DISPLAY_NAME = "display-name";
    public static final String JBI_EXT_PROC_NAME = "process-name";
    public static final String JBI_EXT_FILE_PATH = "file-path";

    public JBIFileWriter(String string, String string2, String string3) {
        this.mJbiDescriptorFile = string;
        this.sqlMapFile = string2;
        this.mbuildDir = string3;
    }

    public JBIFileWriter(String string, String string2) {
        this.mJbiDescriptorFile = string;
        this.sqlMapFile = string2;
    }

    public void writeJBI() {
        List list = null;
        try {
            list = SQLMapReader.parse("sqlmap.xml", this.mbuildDir);
            this.populatePrefixAndNamespaceTable(list);
            this.generateJBI(list);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void populatePrefixAndNamespaceTable(List list) throws Exception {
        try {
            int n = 1;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                SQLMapEntry sQLMapEntry = (SQLMapEntry)list.get(i);
                String string = sQLMapEntry.getPartnerLink().getNamespaceURI();
                if (string != null && !string.trim().equals("") && !this.nsTable.containsKey(string)) {
                    this.nsTable.put(string, "ns" + n);
                    this.prefixTable.put("ns" + n, string);
                    ++n;
                }
                if ((string = sQLMapEntry.getPortType().getNamespaceURI()) != null && !string.trim().equals("") && !this.nsTable.containsKey(string)) {
                    this.nsTable.put(string, "ns" + n);
                    this.prefixTable.put("ns" + n, string);
                    ++n;
                }
                if (sQLMapEntry.getType() == "requestReplyService") continue;
                string = sQLMapEntry.getPartnerLink().getNamespaceURI();
                if (string != null && !string.trim().equals("") && !this.nsTable.containsKey(string)) {
                    this.nsTable.put(string, "ns" + n);
                    this.prefixTable.put("ns" + n, string);
                    ++n;
                }
                if ((string = sQLMapEntry.getPortType().getNamespaceURI()) == null || string.trim().equals("") || this.nsTable.containsKey(string)) continue;
                this.nsTable.put(string, "ns" + n);
                this.prefixTable.put("ns" + n, string);
                ++n;
            }
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    private void generateJBI(List list) throws Exception {
        try {
            String string;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<!--start of generated code -->\n");
            stringBuffer.append("<jbi version=\"1.0\"\n");
            stringBuffer.append("        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            stringBuffer.append("        xmlns=\"http://java.sun.com/xml/ns/jbi\"\n");
            stringBuffer.append("        xsi:schemaLocation=\"http://java.sun.com/xml/ns/jbi jbi.xsd\"\n");
            int n2 = this.nsTable.size();
            for (n = 0; n < n2; ++n) {
                string = "ns" + (n + 1);
                stringBuffer.append("        xmlns:" + string + "=\"" + this.prefixTable.get(string) + "\"");
                if (n >= n2 - 1) continue;
                stringBuffer.append("\n");
            }
            n = this.nsTable.size() + 1;
            stringBuffer.append("\t\txmlns:ns" + n + "=\" " + JBI_EXT_NS + "\"");
            stringBuffer.append(">\n");
            stringBuffer.append("    <services binding-component=\"false\">\n");
            SQLMapEntry sQLMapEntry = (SQLMapEntry)list.get(0);
            stringBuffer.append("        <provides interface-name=\"" + JBIFileWriter.getDottedQName(sQLMapEntry.getPortType(), this.nsTable));
            stringBuffer.append("\" service-name=\"" + JBIFileWriter.getDottedQName(sQLMapEntry.getPartnerLink(), this.nsTable));
            stringBuffer.append("\" endpoint-name=\"" + sQLMapEntry.getRoleName());
            stringBuffer.append("\">\n");
            string = "ns" + n;
            String string2 = string + ":" + JBI_EXT_DISPLAY_NAME;
            String string3 = string + ":" + JBI_EXT_PROC_NAME;
            String string4 = string + ":" + JBI_EXT_FILE_PATH;
            stringBuffer.append(" <" + string2 + ">" + sQLMapEntry.getDisplayName() + "</" + string2 + ">\n");
            stringBuffer.append(" <" + string3 + ">" + sQLMapEntry.getProcessName() + "</" + string3 + ">\n");
            stringBuffer.append(" <" + string4 + ">" + sQLMapEntry.getFilePath() + "</" + string4 + ">\n");
            stringBuffer.append(" </provides>\n");
            if (!sQLMapEntry.getType().equals("requestReplyService")) {
                stringBuffer.append("        <consumes interface-name=\"" + JBIFileWriter.getDottedQName(sQLMapEntry.getPortType(), this.nsTable));
                stringBuffer.append("\" service-name=\"" + JBIFileWriter.getDottedQName(sQLMapEntry.getPartnerLink(), this.nsTable));
                stringBuffer.append("\" endpoint-name=\"" + sQLMapEntry.getRoleName());
                stringBuffer.append("\" link-type=\"standard\"/>\n");
            }
            stringBuffer.append("    </services>\n");
            stringBuffer.append(" </jbi>\n");
            stringBuffer.append("<!--end of generated code -->\n");
            String string5 = stringBuffer.toString();
            this.fos = new FileOutputStream(this.mJbiDescriptorFile);
            FileUtil.copy(string5.getBytes("UTF-8"), (OutputStream)this.fos);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (this.fos != null) {
                try {
                    this.fos.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static String getDottedQName(QName qName, Map map) {
        String string = qName.getNamespaceURI();
        String string2 = (String)map.get(string);
        if (string2 == null) {
            return qName.getLocalPart();
        }
        return string2 + ":" + qName.getLocalPart();
    }

    public static void main(String[] stringArray) {
        JBIFileWriter jBIFileWriter = new JBIFileWriter("test/jbi.xml", "test/sqlmap.xml", "");
        jBIFileWriter.writeJBI();
    }
}

