/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.catd.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditableProperties
extends AbstractMap<String, String>
implements Cloneable {
    private final LinkedList<Item> items;
    private final Map<String, Item> itemIndex;
    private final boolean alphabetize;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String commentChars = "#!";
    private static final String INDENT = "    ";
    private static final int WAITING_FOR_KEY_VALUE = 1;
    private static final int READING_KEY_VALUE = 2;

    public EditableProperties() {
        this(false);
    }

    public EditableProperties(boolean alphabetize) {
        this.alphabetize = alphabetize;
        this.items = new LinkedList();
        this.itemIndex = new HashMap<String, Item>();
    }

    public EditableProperties(Map<String, String> map) {
        this(false);
        this.putAll(map);
    }

    private EditableProperties(EditableProperties ep) {
        this.alphabetize = ep.alphabetize;
        this.items = new LinkedList();
        this.itemIndex = new HashMap<String, Item>(ep.items.size() * 4 / 3 + 1);
        for (Item _i : ep.items) {
            Item i = (Item)_i.clone();
            this.items.add(i);
            this.itemIndex.put(i.getKey(), i);
        }
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new SetImpl(this);
    }

    public void load(InputStream stream) throws IOException {
        String line;
        int state = 1;
        BufferedReader input = new BufferedReader(new InputStreamReader(stream, "ISO-8859-1"));
        LinkedList<String> tempList = new LinkedList<String>();
        int commentLinesCount = 0;
        while (null != (line = input.readLine())) {
            tempList.add(line);
            boolean empty = EditableProperties.isEmpty(line);
            boolean comment = EditableProperties.isComment(line);
            if (state == 1) {
                if (empty) {
                    this.createNonKeyItem(tempList);
                    commentLinesCount = 0;
                } else if (comment) {
                    ++commentLinesCount;
                } else {
                    state = 2;
                }
            }
            if (state != 2 || this.isContinue(line)) continue;
            this.createKeyItem(tempList, commentLinesCount);
            state = 1;
            commentLinesCount = 0;
        }
        if (tempList.size() > 0) {
            if (state == 2) {
                this.createKeyItem(tempList, commentLinesCount);
            } else {
                this.createNonKeyItem(tempList);
            }
        }
    }

    public void store(OutputStream stream) throws IOException {
        boolean previousLineWasEmpty = true;
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(stream, "ISO-8859-1"));
        for (Item item : this.items) {
            if (item.isSeparate() && !previousLineWasEmpty) {
                output.newLine();
            }
            String line2 = null;
            for (String line2 : item.getRawData()) {
                output.write(line2);
                output.newLine();
            }
            if (line2 == null) continue;
            previousLineWasEmpty = EditableProperties.isEmpty(line2);
        }
        output.flush();
    }

    @Override
    public String put(String key, String value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        Item item = this.itemIndex.get(key);
        String result = null;
        if (item != null) {
            result = item.getValue();
            item.setValue(value);
        } else {
            item = new Item(key, value);
            this.addItem(item, this.alphabetize);
        }
        return result;
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public String setProperty(String key, String value) {
        return this.put(key, value);
    }

    public String setProperty(String key, String[] value) {
        String result = (String)this.get(key);
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        List<String> valueList = Arrays.asList(value);
        Item item = this.itemIndex.get(key);
        if (item != null) {
            item.setValue(valueList);
        } else {
            this.addItem(new Item(key, valueList), this.alphabetize);
        }
        return result;
    }

    public String[] getComment(String key) {
        Item item = this.itemIndex.get(key);
        if (item == null) {
            return new String[0];
        }
        return item.getComment();
    }

    public void setComment(String key, String[] comment, boolean separate) {
        Item item = this.itemIndex.get(key);
        if (item == null) {
            throw new IllegalArgumentException("Cannot set comment for non-existing property " + key);
        }
        item.setComment(comment, separate);
    }

    @Override
    public Object clone() {
        return this.cloneProperties();
    }

    public EditableProperties cloneProperties() {
        return new EditableProperties(this);
    }

    private void createNonKeyItem(List<String> lines) {
        Item item;
        if (!this.items.isEmpty() && (item = this.items.getLast()).getKey() == null) {
            item.addCommentLines(lines);
            lines.clear();
            return;
        }
        item = new Item(lines);
        this.addItem(item, false);
        lines.clear();
    }

    private void createKeyItem(List<String> lines, int commentLinesCount) {
        Item item = new Item(lines.subList(0, commentLinesCount), lines.subList(commentLinesCount, lines.size()));
        this.addItem(item, false);
        lines.clear();
    }

    private void addItem(Item item, boolean sort) {
        String key = item.getKey();
        if (sort) {
            assert (key != null);
            ListIterator<Item> it = this.items.listIterator();
            while (it.hasNext()) {
                String k = ((Item)it.next()).getKey();
                if (k == null || k.compareToIgnoreCase(key) <= 0) continue;
                it.previous();
                it.add(item);
                this.itemIndex.put(key, item);
                return;
            }
        }
        this.items.add(item);
        if (key != null) {
            this.itemIndex.put(key, item);
        }
    }

    private void removeItem(Item item) {
        this.items.remove(item);
        if (item.getKey() != null) {
            this.itemIndex.remove(item.getKey());
        }
    }

    private boolean isContinue(String line) {
        int slashCount = 0;
        for (int index = line.length() - 1; index >= 0 && line.charAt(index) == '\\'; --index) {
            ++slashCount;
        }
        return slashCount % 2 != 0;
    }

    private static boolean isComment(String line) {
        return (line = EditableProperties.trimLeft(line)).length() != 0 && commentChars.indexOf(line.charAt(0)) != -1;
    }

    private static boolean isEmpty(String line) {
        return EditableProperties.trimLeft(line).length() == 0;
    }

    private static String trimLeft(String line) {
        int start;
        for (start = 0; start < line.length() && whiteSpaceChars.indexOf(line.charAt(start)) != -1; ++start) {
        }
        return line.substring(start);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapEntryImpl
    implements Map.Entry<String, String> {
        private Item item;

        public MapEntryImpl(Item item) {
            this.item = item;
        }

        @Override
        public String getKey() {
            return this.item.getKey();
        }

        @Override
        public String getValue() {
            return this.item.getValue();
        }

        @Override
        public String setValue(String value) {
            String result = this.item.getValue();
            this.item.setValue(value);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorImpl
    implements Iterator<Map.Entry<String, String>> {
        private final EditableProperties props;
        private ListIterator<Item> delegate;

        public IteratorImpl(EditableProperties props) {
            this.props = props;
            this.delegate = props.items.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.findNext() != null;
        }

        @Override
        public Map.Entry<String, String> next() {
            Item item = this.findNext();
            if (item == null) {
                throw new NoSuchElementException();
            }
            this.delegate.next();
            return new MapEntryImpl(item);
        }

        @Override
        public void remove() {
            this.delegate.previous();
            Item item = this.findNext();
            if (item == null) {
                throw new IllegalStateException();
            }
            int index = this.delegate.nextIndex();
            this.props.items.remove(item);
            this.props.itemIndex.remove(item.getKey());
            this.delegate = this.props.items.listIterator(index);
        }

        private Item findNext() {
            while (this.delegate.hasNext()) {
                Item item = this.delegate.next();
                if (item.getKey() == null || item.getValue() == null) continue;
                this.delegate.previous();
                return item;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetImpl
    extends AbstractSet<Map.Entry<String, String>> {
        private EditableProperties props;

        public SetImpl(EditableProperties props) {
            this.props = props;
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new IteratorImpl(this.props);
        }

        @Override
        public int size() {
            return this.props.items.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Item
    implements Cloneable {
        private List<String> commentLines;
        private List<String> keyValueLines;
        private String key;
        private String value;
        private boolean separate;

        private Item() {
        }

        public Item(List<String> commentLines) {
            this.commentLines = new ArrayList<String>(commentLines);
        }

        public Item(List<String> commentLines, List<String> keyValueLines) {
            this.commentLines = new ArrayList<String>(commentLines);
            this.keyValueLines = new ArrayList<String>(keyValueLines);
            this.parse(keyValueLines);
        }

        public Item(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Item(String key, List<String> value) {
            this.key = key;
            this.setValue(value);
        }

        void addCommentLines(List<String> lines) {
            assert (this.key == null);
            this.commentLines.addAll(lines);
        }

        public String[] getComment() {
            String[] res = new String[this.commentLines.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = Item.decodeUnicode(this.commentLines.get(i));
            }
            return res;
        }

        public void setComment(String[] commentLines, boolean separate) {
            this.separate = separate;
            this.commentLines = new ArrayList<String>(commentLines.length);
            for (int i = 0; i < commentLines.length; ++i) {
                this.commentLines.add(Item.encodeUnicode(commentLines[i]));
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
            this.keyValueLines = null;
        }

        public void setValue(List<String> value) {
            StringBuffer val = new StringBuffer();
            ArrayList<String> l = new ArrayList<String>();
            if (!value.isEmpty()) {
                l.add(Item.encode(this.key, true) + "=\\");
                Iterator<String> it = value.iterator();
                while (it.hasNext()) {
                    String s = it.next();
                    val.append(s);
                    s = Item.encode(s, false);
                    l.add(it.hasNext() ? EditableProperties.INDENT + s + '\\' : EditableProperties.INDENT + s);
                }
            } else {
                l.add(Item.encode(this.key, true) + '=');
            }
            this.value = val.toString();
            this.keyValueLines = l;
        }

        public boolean isSeparate() {
            return this.separate;
        }

        public List<String> getRawData() {
            ArrayList<String> l = new ArrayList<String>();
            if (this.commentLines != null) {
                l.addAll(this.commentLines);
            }
            if (this.keyValueLines == null) {
                this.keyValueLines = new ArrayList<String>();
                if (this.key != null && this.value != null) {
                    this.keyValueLines.add(Item.encode(this.key, true) + "=" + Item.encode(this.value, false));
                }
            }
            l.addAll(this.keyValueLines);
            return l;
        }

        private void parse(List<String> keyValueLines) {
            String line = this.mergeLines(keyValueLines);
            this.splitKeyValue(line);
        }

        private String mergeLines(List<String> lines) {
            String line = "";
            Iterator<String> it = lines.iterator();
            while (it.hasNext()) {
                String l = EditableProperties.trimLeft(it.next());
                if (it.hasNext()) {
                    assert (l.endsWith("\\")) : lines;
                    l = l.substring(0, l.length() - 1);
                }
                line = line + l;
            }
            return line;
        }

        private void splitKeyValue(String line) {
            int separatorIndex;
            for (separatorIndex = 0; separatorIndex < line.length(); ++separatorIndex) {
                char ch = line.charAt(separatorIndex);
                if (ch == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if (EditableProperties.keyValueSeparators.indexOf(ch) != -1) break;
            }
            this.key = Item.decode(line.substring(0, separatorIndex));
            if ((line = EditableProperties.trimLeft(line.substring(separatorIndex))).length() == 0) {
                this.value = "";
                return;
            }
            if (EditableProperties.strictKeyValueSeparators.indexOf(line.charAt(0)) != -1) {
                line = EditableProperties.trimLeft(line.substring(1));
            }
            this.value = Item.decode(line);
        }

        private static String decode(String input) {
            int len = input.length();
            StringBuffer output = new StringBuffer(len);
            for (int x = 0; x < len; ++x) {
                int ch = input.charAt(x);
                if (ch != 92) {
                    output.append((char)ch);
                    continue;
                }
                if (++x == len) continue;
                ch = input.charAt(x);
                if (ch == 117) {
                    if (x + 5 > len) {
                        output.append(input.substring(x - 1));
                        x += 4;
                        continue;
                    }
                    String val = input.substring(x + 1, x + 5);
                    try {
                        output.append((char)Integer.parseInt(val, 16));
                    }
                    catch (NumberFormatException e) {
                        output.append(input.substring(x - 1, x + 5));
                    }
                    x += 4;
                    continue;
                }
                if (ch == 116) {
                    ch = 9;
                } else if (ch == 114) {
                    ch = 13;
                } else if (ch == 110) {
                    ch = 10;
                } else if (ch == 102) {
                    ch = 12;
                }
                output.append((char)ch);
            }
            return output.toString();
        }

        private static String encode(String input, boolean escapeSpace) {
            int len = input.length();
            StringBuffer output = new StringBuffer(len * 2);
            block8: for (int x = 0; x < len; ++x) {
                char ch = input.charAt(x);
                switch (ch) {
                    case ' ': {
                        if (x == 0 || escapeSpace) {
                            output.append('\\');
                        }
                        output.append(' ');
                        continue block8;
                    }
                    case '\\': {
                        output.append("\\\\");
                        continue block8;
                    }
                    case '\t': {
                        output.append("\\t");
                        continue block8;
                    }
                    case '\n': {
                        output.append("\\n");
                        continue block8;
                    }
                    case '\r': {
                        output.append("\\r");
                        continue block8;
                    }
                    case '\f': {
                        output.append("\\f");
                        continue block8;
                    }
                    default: {
                        if (ch < ' ' || ch > '~') {
                            output.append("\\u");
                            String hex = Integer.toHexString(ch);
                            for (int i = 0; i < 4 - hex.length(); ++i) {
                                output.append('0');
                            }
                            output.append(hex);
                            continue block8;
                        }
                        output.append(ch);
                    }
                }
            }
            return output.toString();
        }

        private static String decodeUnicode(String input) {
            int len = input.length();
            StringBuffer output = new StringBuffer(len);
            for (int x = 0; x < len; ++x) {
                char ch = input.charAt(x);
                if (ch != '\\') {
                    output.append(ch);
                    continue;
                }
                if (++x == len) continue;
                ch = input.charAt(x);
                if (ch == 'u') {
                    if (x + 5 > len) {
                        output.append(input.substring(x - 1));
                        x += 4;
                        continue;
                    }
                    String val = input.substring(x + 1, x + 5);
                    try {
                        output.append((char)Integer.parseInt(val, 16));
                    }
                    catch (NumberFormatException e) {
                        output.append(input.substring(x - 1, x + 5));
                    }
                    x += 4;
                    continue;
                }
                output.append(ch);
            }
            return output.toString();
        }

        private static String encodeUnicode(String input) {
            int len = input.length();
            StringBuffer output = new StringBuffer(len * 2);
            for (int x = 0; x < len; ++x) {
                char ch = input.charAt(x);
                if (ch < ' ' || ch > '~') {
                    output.append("\\u");
                    String hex = Integer.toHexString(ch);
                    for (int i = 0; i < 4 - hex.length(); ++i) {
                        output.append('0');
                    }
                    output.append(hex);
                    continue;
                }
                output.append(ch);
            }
            return output.toString();
        }

        public Object clone() {
            Item item = new Item();
            if (this.keyValueLines != null) {
                item.keyValueLines = new ArrayList<String>(this.keyValueLines);
            }
            if (this.commentLines != null) {
                item.commentLines = new ArrayList<String>(this.commentLines);
            }
            item.key = this.key;
            item.value = this.value;
            item.separate = this.separate;
            return item;
        }
    }
}

