/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.libraries.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.javascript.libraries.ui.customizer.JavaScriptLibraryListModel;
import org.netbeans.modules.javascript.libraries.util.JSLibraryData;
import org.netbeans.modules.javascript.libraries.util.JSLibraryProjectUtils;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CustomizerJSLibraries
extends JPanel {
    private final ProjectCustomizer.Category category;
    private final Project project;
    private final JavaScriptLibraryListModel listModel;
    private final PropertyChangeListener libraryChangeListener;
    private JButton addLibraryJButton;
    private JList librariesList;
    private JScrollPane librariesListScrollPane;
    private JLabel libraryListLabel;
    private JTextField locationDisplay;
    private JLabel locationLabel;
    private JButton removeLibraryJButton;

    public CustomizerJSLibraries(ProjectCustomizer.Category category, Project project) {
        this.category = category;
        this.project = project;
        this.listModel = new JavaScriptLibraryListModel(project);
        this.initComponents();
        this.librariesList.setModel(this.listModel);
        this.librariesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CustomizerJSLibraries.this.updateRemoveButtonState();
                CustomizerJSLibraries.this.updateLocationDisplay();
            }
        });
        this.locationDisplay.setEditable(false);
        this.updateRemoveButtonState();
        this.libraryChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                for (int i = 0; i < CustomizerJSLibraries.this.listModel.getSize(); ++i) {
                    String string = CustomizerJSLibraries.this.listModel.getLibraryNameAt(i);
                    String string2 = CustomizerJSLibraries.this.listModel.getLibraryLocationAt(i);
                    CustomizerJSLibraries.this.listModel.changeLibrary(i, string, string2);
                }
            }
        };
        LibraryManager libraryManager = JSLibraryProjectUtils.getLibraryManager(project);
        libraryManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.libraryChangeListener, (Object)libraryManager));
    }

    private void initComponents() {
        this.locationLabel = new JLabel();
        this.locationDisplay = new JTextField();
        this.librariesListScrollPane = new JScrollPane();
        this.librariesList = new JList();
        this.libraryListLabel = new JLabel();
        this.addLibraryJButton = new JButton();
        this.removeLibraryJButton = new JButton();
        this.locationLabel.setLabelFor(this.locationDisplay);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(CustomizerJSLibraries.class, (String)"CustomizerJSLibraries.locationLabel.text"));
        this.librariesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.librariesListScrollPane.setViewportView(this.librariesList);
        this.librariesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJSLibraries.class, (String)"CustomizerJSLibraries.librariesList.AccessibleContext.accessibleName"));
        this.librariesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJSLibraries.class, (String)"CustomizerJSLibraries.librariesList.AccessibleContext.accessibleDescription"));
        this.libraryListLabel.setLabelFor(this.librariesList);
        Mnemonics.setLocalizedText((JLabel)this.libraryListLabel, (String)NbBundle.getMessage(CustomizerJSLibraries.class, (String)"CustomizerJSLibraries.libraryListLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addLibraryJButton, (String)NbBundle.getMessage(CustomizerJSLibraries.class, (String)"CustomizerJSLibraries.addLibraryJButton.text"));
        this.addLibraryJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerJSLibraries.this.addLibraryJButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeLibraryJButton, (String)NbBundle.getMessage(CustomizerJSLibraries.class, (String)"CustomizerJSLibraries.removeLibraryJButton.text"));
        this.removeLibraryJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerJSLibraries.this.removeLibraryJButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.libraryListLabel).add((Component)this.librariesListScrollPane, -1, 383, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.removeLibraryJButton, -1, -1, Short.MAX_VALUE).add((Component)this.addLibraryJButton, -1, 110, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.locationLabel).addPreferredGap(0).add((Component)this.locationDisplay, -1, 431, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.locationLabel).add((Component)this.locationDisplay, -2, -1, -2)).add(26, 26, 26).add((Component)this.libraryListLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addLibraryJButton, -2, 29, -2).addPreferredGap(0).add((Component)this.removeLibraryJButton)).add((Component)this.librariesListScrollPane, -1, 252, Short.MAX_VALUE)).addContainerGap()));
        this.locationDisplay.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJSLibraries.class, (String)"CustomizerJSLibraries.locationDisplay.AccessibleContext.accessibleName"));
        this.locationDisplay.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJSLibraries.class, (String)"CustomizerJSLibraries.locationDisplay.AccessibleContext.accessibleDescription"));
        this.librariesListScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJSLibraries.class, (String)"CustomizerJSLibraries.librariesListScrollPane.AccessibleContext.accessibleName"));
        this.addLibraryJButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJSLibraries.class, (String)"CustomizerJSLibraries.addLibraryJButton.AccessibleContext.accessibleDescription"));
        this.removeLibraryJButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJSLibraries.class, (String)"CustomizerJSLibraries.removeLibraryJButton.AccessibleContext.accessibleDescription"));
    }

    private void addLibraryJButtonActionPerformed(ActionEvent actionEvent) {
        Object object;
        List<JSLibraryData> list;
        LibraryManager libraryManager = JSLibraryProjectUtils.getLibraryManager(this.project);
        LinkedHashSet<Library> linkedHashSet = new LinkedHashSet<Library>();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            list = this.listModel.getLibraryNameAt(i);
            object = libraryManager.getLibrary((String)((Object)list));
            if (object == null) continue;
            linkedHashSet.add((Library)object);
        }
        LibraryChooser.Filter filter = JSLibraryProjectUtils.createDefaultFilter(linkedHashSet);
        list = JSLibraryProjectUtils.displayAddLibraryDialog(this.project, filter);
        if (list != null) {
            object = new ArrayList();
            ArrayList<JSLibraryData> arrayList = new ArrayList<JSLibraryData>();
            ArrayList<ModelModification> arrayList2 = new ArrayList<ModelModification>();
            for (JSLibraryData object2 : list) {
                Object object3;
                String string;
                boolean bl = true;
                Library library = libraryManager.getLibrary(object2.getLibraryName());
                if (!JSLibraryProjectUtils.isLibraryFolderEmpty(this.project, library, string = object2.getLibraryLocation())) {
                    object3 = JSLibraryProjectUtils.displayLibraryOverwriteDialog(library);
                    boolean bl2 = bl = object3 == NotifyDescriptor.YES_OPTION;
                }
                if (!bl) continue;
                object3 = library.getName();
                boolean bl3 = false;
                for (int i = 0; i < this.listModel.getSize(); ++i) {
                    String string2 = this.listModel.getLibraryNameAt(i);
                    if (!string2.equals(object3)) continue;
                    bl3 = true;
                    arrayList2.add(new ModelModification(i, string2, string));
                    break;
                }
                JSLibraryData jSLibraryData = new JSLibraryData(library.getName(), string);
                if (!bl3) {
                    arrayList2.add(new ModelModification((String)object3, string));
                    arrayList.add(jSLibraryData);
                }
                object.add(jSLibraryData);
            }
            if (arrayList.size() > 0) {
                JSLibraryProjectUtils.addJSLibraryMetadata(this.project, arrayList);
            }
            if (object.size() > 0) {
                JSLibraryProjectUtils.extractLibrariesWithProgress(this.project, (Collection<JSLibraryData>)object);
            }
            for (ModelModification modelModification : arrayList2) {
                if (modelModification.getIndex() >= 0) {
                    this.listModel.changeLibrary(modelModification.getIndex(), modelModification.getName(), modelModification.getLocation());
                    continue;
                }
                this.listModel.appendLibrary(modelModification.getName(), modelModification.getLocation());
            }
        }
    }

    private void removeLibraryJButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.librariesList.getSelectedIndices();
        assert (nArray.length > 0);
        ArrayList<JSLibraryData> arrayList = new ArrayList<JSLibraryData>();
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            arrayList.add(new JSLibraryData(this.listModel.getLibraryNameAt(n), this.listModel.getLibraryLocationAt(n)));
        }
        ArrayList<JSLibraryData> arrayList2 = new ArrayList<JSLibraryData>();
        ArrayList<JSLibraryData> arrayList3 = new ArrayList<JSLibraryData>();
        arrayList3.addAll(arrayList);
        LibraryManager libraryManager = JSLibraryProjectUtils.getLibraryManager(this.project);
        for (JSLibraryData jSLibraryData : arrayList) {
            boolean bl;
            String string = jSLibraryData.getLibraryName();
            String string2 = jSLibraryData.getLibraryLocation();
            Library library = libraryManager.getLibrary(string);
            if (library == null) continue;
            if (string2 != null && !JSLibraryProjectUtils.isLibraryFolderEmpty(this.project, library, string2)) {
                Object object = JSLibraryProjectUtils.displayLibraryDeleteConfirm(library);
                boolean bl2 = bl = object == NotifyDescriptor.YES_OPTION;
                if (object == NotifyDescriptor.CANCEL_OPTION) {
                    arrayList3.remove(jSLibraryData);
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            arrayList2.add(jSLibraryData);
        }
        if (arrayList3.size() > 0) {
            for (int i = arrayList3.size() - 1; i >= 0; --i) {
                this.listModel.removeLibrary(((JSLibraryData)arrayList3.get(i)).getLibraryName());
            }
            JSLibraryProjectUtils.removeJSLibraryMetadata(this.project, arrayList3);
        }
        if (arrayList2.size() > 0) {
            JSLibraryProjectUtils.deleteLibrariesWithProgress(this.project, arrayList2);
        }
    }

    private void updateRemoveButtonState() {
        this.removeLibraryJButton.setEnabled(this.librariesList.getSelectedIndex() >= 0);
    }

    private void updateLocationDisplay() {
        int n = this.librariesList.getSelectedIndex();
        if (n >= 0 && n < this.listModel.getSize()) {
            String string = this.listModel.getLibraryLocationAt(n);
            string = string == null ? "" : string;
            this.locationDisplay.setText(string);
        } else {
            this.locationDisplay.setText("");
        }
    }

    private static final class ModelModification {
        private final String name;
        private final String location;
        private final int index;

        public ModelModification(int n, String string, String string2) {
            this.index = n;
            this.name = string;
            this.location = string2;
        }

        public ModelModification(String string, String string2) {
            this(-1, string, string2);
        }

        public int getIndex() {
            return this.index;
        }

        public String getLocation() {
            return this.location;
        }

        public String getName() {
            return this.name;
        }
    }
}

