/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring;

import java.io.IOException;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class RefactoringUtil {
    public static final String XSD_MIME_TYPE = "application/x-schema+xml";

    public static Schema getSchema(FileObject fileObject) throws IOException {
        if (!XSD_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)fileObject))) {
            return null;
        }
        Object var1_1 = null;
        ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
        SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
        assert (schemaModel != null) : "Unexpected null model returned from factory";
        if (schemaModel.getState().equals((Object)Model.State.VALID)) {
            return schemaModel.getSchema();
        }
        String string = NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_SchemaModelNotWellFormed", (Object)fileObject.getPath());
        throw new IOException(string);
    }

    public static String getLocationReferenceAttributeName(Component component) {
        if (component instanceof Import) {
            return "location";
        }
        if (component instanceof SchemaModelReference) {
            return "schemaLocation";
        }
        return "ref";
    }
}

