/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring.query;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.xml.nbprefuse.AnalysisConstants;
import org.netbeans.modules.xml.nbprefuse.AnalysisViewer;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.refactoring.query.CustomizerResults;
import org.netbeans.modules.xml.schema.refactoring.query.Query;
import org.netbeans.modules.xml.schema.refactoring.query.QueryUnusedGlobals;
import org.netbeans.modules.xml.schema.refactoring.query.views.ComplexTypeDerivationsView;
import org.netbeans.modules.xml.schema.refactoring.query.views.WhereUsedExplorer;
import org.netbeans.modules.xml.schema.refactoring.ui.QueryPanel;
import org.netbeans.modules.xml.schema.refactoring.ui.QueryPanelContainer;
import org.netbeans.modules.xml.schema.refactoring.ui.QueryUtilities;
import org.netbeans.modules.xml.xam.Named;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class QueryComplexTypeDerivations
implements Query {
    protected String displayName;
    private WhereUsedExplorer customizer;
    private SchemaModel model;
    private String shortName;
    private CustomizerResults results;

    public QueryComplexTypeDerivations(SchemaModel schemaModel) {
        this.model = schemaModel;
        this.setDisplayName(NbBundle.getMessage(QueryComplexTypeDerivations.class, (String)"LBL_QueryComplexTypeDerivations"));
        this.shortName = NbBundle.getMessage(QueryComplexTypeDerivations.class, (String)"LBL_QueryComplexTypeDerivations_ShortName");
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String toString() {
        return this.displayName;
    }

    public SchemaModel getSchemaModel() {
        return this.model;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void runQuery(final QueryPanel queryPanel, final AnalysisViewer analysisViewer) {
        this.showCustomizerDialog();
        if (this.results != null && this.results.wasCanceled()) {
            return;
        }
        SchemaComponent schemaComponent = this.customizer.getSelectedSchemaComponent();
        GlobalComplexType globalComplexType = null;
        if (!(schemaComponent instanceof GlobalComplexType)) {
            return;
        }
        globalComplexType = (GlobalComplexType)schemaComponent;
        final ComplexTypeDerivationsView complexTypeDerivationsView = new ComplexTypeDerivationsView((SchemaComponent)globalComplexType);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QueryComplexTypeDerivations.class, (String)"LBL_Finding_Derivations"));
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                complexTypeDerivationsView.createModels();
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                progressHandle.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (complexTypeDerivationsView != null) {
                            if (!queryPanel.getIsVisible()) {
                                QueryPanelContainer queryPanelContainer = QueryPanelContainer.getUsagesComponent();
                                if (queryPanelContainer == null) {
                                    ErrorManager.getDefault().log(65536, "XML Schema Query Failed to open QueryPanelContainer. The problem could be that the XML settings and wstcref files in userdir Windows2Local are obsolete.  Try removing xml-schema-query.* and restart the IDE.");
                                    return;
                                }
                                queryPanelContainer.open();
                                queryPanelContainer.requestActive();
                                queryPanelContainer.addPanel(queryPanel);
                                queryPanel.setIsVisible(true);
                            }
                            queryPanel.requestFocus();
                            if (complexTypeDerivationsView != null) {
                                complexTypeDerivationsView.showView(analysisViewer);
                                analysisViewer.validate();
                                analysisViewer.repaint();
                            }
                        }
                    }
                });
            }
        });
    }

    public CustomizerResults showCustomizerDialog() {
        this.results = new CustomizerResults();
        this.customizer = new CTExplorer(this.model);
        this.results.setPanel(this.customizer);
        String string = NbBundle.getMessage(QueryUnusedGlobals.class, (String)"LBL_QueryComplexTypeDerivations_ShortName");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.customizer, string);
        JDialog jDialog = (JDialog)DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        jDialog.setTitle(string);
        jDialog.validate();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != NotifyDescriptor.OK_OPTION) {
            this.results.setWasCanceled(true);
        }
        return this.results;
    }

    public SchemaModel getModel() {
        return this.model;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CTExplorer
    extends WhereUsedExplorer {
        private static final long serialVersionUID = 1L;

        public CTExplorer(SchemaModel schemaModel) {
            super(schemaModel);
        }

        @Override
        protected Node createTree() {
            this.count = 0;
            Schema schema = this.model.getSchema();
            AbstractNode abstractNode = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.BASE_COMPLEX_TYPES);
            String string = "org/netbeans/modules/xml/schema/ui/nodes/resources/complextype.png";
            abstractNode.setIconBaseWithExtension(string);
            ArrayList<WhereUsedExplorer.QueryCustomizerNode> arrayList = new ArrayList<WhereUsedExplorer.QueryCustomizerNode>();
            for (GlobalComplexType globalComplexType : schema.getComplexTypes()) {
                this.createCustomizerNode(arrayList, (Named)globalComplexType, string, false);
            }
            int n = arrayList.size();
            if (n == 1) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(QueryComplexTypeDerivations.class, (String)"LBL_1_ComplexType_with_Derivations_Found"));
            } else {
                StatusDisplayer.getDefault().setStatusText(MessageFormat.format(NbBundle.getMessage(QueryComplexTypeDerivations.class, (String)"LBL_ComplexTypes_with_Derivations_Found"), n));
            }
            abstractNode.getChildren().add((Node[])arrayList.toArray(new WhereUsedExplorer.QueryCustomizerNode[arrayList.size()]));
            return abstractNode;
        }

        @Override
        protected void createCustomizerNode(List<WhereUsedExplorer.QueryCustomizerNode> list, Named named, String string, boolean bl) {
            WhereUsedExplorer.QueryCustomizerNode queryCustomizerNode = null;
            queryCustomizerNode = bl ? new WhereUsedExplorer.QueryCustomizerNode(this, Children.LEAF, named, bl, this.model) : new WhereUsedExplorer.QueryCustomizerNode(this, Children.LEAF, named, bl);
            queryCustomizerNode.setIconBaseWithExtension(string);
            queryCustomizerNode.setName(named.getName());
            for (WhereUsedExplorer.QueryCustomizerNode queryCustomizerNode2 : list) {
                if (queryCustomizerNode2.getSchemaComponent() != named) continue;
                return;
            }
            list.add(queryCustomizerNode);
            if (!bl) {
                ++this.count;
            }
        }
    }
}

