/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring.query;

import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.xml.nbprefuse.AnalysisViewer;
import org.netbeans.modules.xml.refactoring.ui.CancelGraph;
import org.netbeans.modules.xml.refactoring.ui.CancelSignal;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.refactoring.query.CustomizerResults;
import org.netbeans.modules.xml.schema.refactoring.query.Query;
import org.netbeans.modules.xml.schema.refactoring.query.views.QueryUnusedGlobalsCustomizerPanel;
import org.netbeans.modules.xml.schema.refactoring.query.views.QueryUnusedGlobalsView;
import org.netbeans.modules.xml.schema.refactoring.ui.QueryPanel;
import org.netbeans.modules.xml.schema.refactoring.ui.QueryPanelContainer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class QueryUnusedGlobals
implements Query {
    private String shortName;
    private String displayName;
    private SchemaModel model;
    Boolean excludeGEs;
    private CustomizerResults results;
    private QueryUnusedGlobalsView view;

    public QueryUnusedGlobals(SchemaModel schemaModel) {
        this.model = schemaModel;
        this.shortName = NbBundle.getMessage(QueryUnusedGlobals.class, (String)"LBL_QueryUnusedGlobal_Shortname");
        this.displayName = NbBundle.getMessage(QueryUnusedGlobals.class, (String)"LBL_QueryUnusedGlobal_Display_Name");
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void runQuery(final QueryPanel queryPanel, final AnalysisViewer analysisViewer) {
        this.showCustomizerDialog();
        if (this.results.wasCanceled()) {
            return;
        }
        this.excludeGEs = this.getExcludeGEs();
        this.view = new QueryUnusedGlobalsView(this.model, this.excludeGEs);
        final CancelGraph cancelGraph = new CancelGraph();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QueryUnusedGlobals.class, (String)"LBL_Finding_Unused_Global_Components"), (Cancellable)cancelGraph);
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                QueryUnusedGlobals.this.view.createModels((CancelSignal)cancelGraph);
                if (cancelGraph.isCancelRequested()) {
                    progressHandle.finish();
                    return;
                }
                progressHandle.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (QueryUnusedGlobals.this.view != null) {
                            if (!queryPanel.getIsVisible()) {
                                QueryPanelContainer queryPanelContainer = QueryPanelContainer.getUsagesComponent();
                                if (queryPanelContainer == null) {
                                    ErrorManager.getDefault().log(65536, "XML Schema Query Failed to open QueryPanelContainer. The problem could be that the XML settings and wstcref files in userdir Windows2Local are obsolete.  Try removing xml-schema-query.* and restart the IDE.");
                                    return;
                                }
                                queryPanelContainer.open();
                                queryPanelContainer.requestActive();
                                queryPanelContainer.addPanel(queryPanel);
                                queryPanel.setIsVisible(true);
                            }
                            if (QueryUnusedGlobals.this.view != null) {
                                QueryUnusedGlobals.this.view.showView(analysisViewer);
                                analysisViewer.validate();
                                analysisViewer.repaint();
                            }
                        }
                    }
                });
            }
        });
    }

    public String toString() {
        return this.displayName;
    }

    public CustomizerResults showCustomizerDialog() {
        this.results = new CustomizerResults();
        QueryUnusedGlobalsCustomizerPanel queryUnusedGlobalsCustomizerPanel = new QueryUnusedGlobalsCustomizerPanel();
        this.results.setPanel(queryUnusedGlobalsCustomizerPanel);
        String string = NbBundle.getMessage(QueryUnusedGlobals.class, (String)"LBL_QueryUnusedGlobal_Display_Name");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)queryUnusedGlobalsCustomizerPanel, string);
        JDialog jDialog = (JDialog)DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        jDialog.setTitle(string);
        jDialog.validate();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != NotifyDescriptor.OK_OPTION) {
            this.results.setWasCanceled(true);
        }
        return this.results;
    }

    private boolean getExcludeGEs() {
        JPanel jPanel;
        if (this.results != null && (jPanel = this.results.getPanel()) instanceof QueryUnusedGlobalsCustomizerPanel) {
            QueryUnusedGlobalsCustomizerPanel queryUnusedGlobalsCustomizerPanel = (QueryUnusedGlobalsCustomizerPanel)QueryUnusedGlobalsCustomizerPanel.class.cast(jPanel);
            return queryUnusedGlobalsCustomizerPanel.getExcludeElements();
        }
        return false;
    }

    public SchemaModel getModel() {
        return this.model;
    }

    public class FUnCustomizer {
        protected CustomizerResults[] constraints;
        protected SchemaComponentReference[] references;
        protected Query query;
        protected QueryUnusedGlobalsCustomizerPanel panel;

        public FUnCustomizer(Query query) {
            this.query = query;
            this.initialize();
        }

        protected void initialize() {
            this.panel = new QueryUnusedGlobalsCustomizerPanel();
        }

        public void setExcludeElements(boolean bl) {
            this.panel.setExcludeElements(bl);
        }
    }
}

