/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataView {
    private DatabaseConnection dbConn;
    private List<Throwable> errMessages = new ArrayList<Throwable>();
    private String sqlString;
    private DataViewDBTable tblMeta;
    private SQLStatementGenerator stmtGenerator;
    private SQLExecutionHelper execHelper;
    private DataViewPageContext dataPage;
    private DataViewUI dataViewUI;
    private boolean nbOutputComponent = false;
    private boolean hasResultSet = false;
    private int updateCount;
    private long executionTime;
    private boolean supportsLimit = false;

    public static DataView create(DatabaseConnection databaseConnection, String string, int n) {
        assert (databaseConnection != null);
        DataView dataView = new DataView();
        dataView.dbConn = databaseConnection;
        dataView.sqlString = string.trim();
        dataView.nbOutputComponent = false;
        try {
            dataView.dataPage = new DataViewPageContext(n);
            dataView.execHelper = new SQLExecutionHelper(dataView, databaseConnection);
            SQLExecutionHelper.initialDataLoad(dataView, databaseConnection, dataView.execHelper);
            dataView.stmtGenerator = new SQLStatementGenerator(dataView);
        }
        catch (Exception exception) {
            dataView.setErrorStatusText(exception);
        }
        return dataView;
    }

    public static DataView create(DatabaseConnection databaseConnection, String string, int n, boolean bl) {
        DataView dataView = DataView.create(databaseConnection, string, n);
        dataView.nbOutputComponent = bl;
        return dataView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Component> createComponents() {
        if (!this.hasResultSet) {
            return Collections.emptyList();
        }
        DataView dataView = this;
        synchronized (dataView) {
            this.dataViewUI = new DataViewUI(this, this.nbOutputComponent);
            this.setRowsInTableModel();
            this.dataViewUI.setEditable(this.tblMeta.hasOneTable());
            this.resetToolbar(this.hasExceptions());
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        arrayList.add(this.dataViewUI);
        return arrayList;
    }

    public boolean hasExceptions() {
        return !this.errMessages.isEmpty();
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    public Collection<Throwable> getExceptions() {
        return Collections.unmodifiableCollection(this.errMessages);
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public JButton[] getEditButtons() {
        assert (this.nbOutputComponent);
        return this.dataViewUI.getEditButtons();
    }

    DataViewDBTable getDataViewDBTable() {
        return this.tblMeta;
    }

    DataViewPageContext getDataViewPageContext() {
        return this.dataPage;
    }

    DatabaseConnection getDatabaseConnection() {
        return this.dbConn;
    }

    String getSQLString() {
        return this.sqlString;
    }

    UpdatedRowContext getUpdatedRowContext() {
        return this.dataViewUI.getUpdatedRowContext();
    }

    SQLExecutionHelper getSQLExecutionHelper() {
        return this.execHelper;
    }

    SQLStatementGenerator getSQLStatementGenerator() {
        return this.stmtGenerator;
    }

    boolean isEditable() {
        return this.dataViewUI.isEditable();
    }

    boolean isLimitSupported() {
        return this.supportsLimit;
    }

    synchronized void disableButtons() {
        assert (this.dataViewUI != null);
        this.dataViewUI.disableButtons();
        this.errMessages.clear();
    }

    synchronized void setEditable(boolean bl) {
        this.dataViewUI.setEditable(bl);
    }

    void setInfoStatusText(String string) {
        if (string != null) {
            StatusDisplayer.getDefault().setStatusText(string);
        }
    }

    synchronized void setErrorStatusText(Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof DBException && throwable.getCause() instanceof SQLException) {
                this.errMessages.add(throwable.getCause());
            }
            this.errMessages.add(throwable);
            String string = NbBundle.getMessage(DataView.class, (String)"MSG_error");
            StatusDisplayer.getDefault().setStatusText(string + throwable.getMessage());
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception(throwable);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)exception);
        }
    }

    void resetToolbar(boolean bl) {
        assert (this.dataViewUI != null);
        this.dataViewUI.resetToolbar(bl);
    }

    void setLimitSupported(boolean bl) {
        this.supportsLimit = bl;
    }

    void setRowsInTableModel() {
        assert (this.dataViewUI != null);
        assert (this.dataPage != null);
        if (this.dataPage.getCurrentRows() != null) {
            this.dataViewUI.setDataRows(this.dataPage.getCurrentRows());
            this.dataViewUI.setTotalCount(this.dataPage.getTotalRows());
        }
    }

    synchronized void incrementRowSize(int n) {
        assert (this.dataViewUI != null);
        this.dataPage.setTotalRows(this.dataPage.getTotalRows() + n);
        this.dataViewUI.setTotalCount(this.dataPage.getTotalRows());
    }

    synchronized void decrementRowSize(int n) {
        assert (this.dataViewUI != null);
        this.dataPage.decrementRowSize(n);
        this.dataViewUI.setTotalCount(this.dataPage.getTotalRows());
    }

    synchronized void syncPageWithTableModel() {
        this.dataViewUI.syncPageWithTableModel();
    }

    void setHasResultSet(boolean bl) {
        this.hasResultSet = bl;
    }

    void setUpdateCount(int n) {
        this.updateCount = n;
    }

    void setExecutionTime(long l) {
        this.executionTime = l;
    }

    void setDataViewDBTable(DataViewDBTable dataViewDBTable) {
        this.tblMeta = dataViewDBTable;
    }

    private DataView() {
    }
}

