/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewActionHandler;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewTablePanel;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataViewUI
extends JPanel {
    private JButton commit;
    private JButton refreshButton;
    private JButton truncateButton;
    private JButton next;
    private JButton last;
    private JButton previous;
    private JButton first;
    private JButton deleteRow;
    private JButton insert;
    private JTextField refreshField;
    private JLabel totalRowsLabel;
    private JLabel limitRow;
    private JButton[] editButtons = new JButton[5];
    private String imgPrefix = "/org/netbeans/modules/db/dataview/images/";
    private DataViewTablePanel dataPanel;
    private final DataView dataView;
    private JButton cancel;
    private DataViewActionHandler actionHandler;
    private static final MouseListener sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            Object object = mouseEvent.getSource();
            if (object instanceof AbstractButton && (abstractButton = (AbstractButton)mouseEvent.getSource()).isEnabled()) {
                abstractButton.setContentAreaFilled(true);
                abstractButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                abstractButton.setContentAreaFilled(false);
                abstractButton.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent mouseEvent) {
        }
    };
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);

    DataViewUI(DataView dataView, boolean bl) {
        this.dataView = dataView;
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        this.putClientProperty("PersistenceType", "Never");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        String string = dataView.getSQLString();
        this.setName(string.substring(0, Math.min(string.length(), 25)));
        this.setToolTipText(string);
        JPanel jPanel = this.initializeMainPanel(bl);
        this.add((Component)jPanel, "North");
        this.actionHandler = new DataViewActionHandler(this, dataView);
        this.dataPanel = new DataViewTablePanel(dataView, this, this.actionHandler);
        this.add((Component)this.dataPanel, "Center");
        this.dataPanel.revalidate();
        this.dataPanel.repaint();
    }

    JButton[] getEditButtons() {
        return this.editButtons;
    }

    void setEditable(boolean bl) {
        this.dataPanel.setEditable(bl);
    }

    boolean isEditable() {
        return this.dataPanel.isEditable();
    }

    void setTotalCount(int n) {
        if (n < 0) {
            this.totalRowsLabel.setText(NbBundle.getMessage(DataViewUI.class, (String)"LBL_not_available"));
        } else {
            this.totalRowsLabel.setText(n + " " + this.dataView.getDataViewPageContext().pageOf());
        }
    }

    boolean isCommitEnabled() {
        return this.commit.isEnabled();
    }

    DataViewTableUI getDataViewTableUI() {
        return this.dataPanel.getDataViewTableUI();
    }

    UpdatedRowContext getUpdatedRowContext() {
        return this.dataPanel.getUpdatedRowContext();
    }

    void setCommitEnabled(boolean bl) {
        this.commit.setEnabled(bl);
    }

    void setCancelEnabled(boolean bl) {
        this.cancel.setEnabled(bl);
    }

    void setDataRows(List<Object[]> list) {
        this.dataPanel.createTableModel(list);
    }

    void syncPageWithTableModel() {
        List<Object[]> list = this.dataPanel.getPageDataFromTable();
        List<Object[]> list2 = this.dataView.getDataViewPageContext().getCurrentRows();
        for (String string : this.dataView.getUpdatedRowContext().getUpdateKeys()) {
            int n = Integer.parseInt(string.substring(0, string.indexOf(";"))) - 1;
            list.set(n, list2.get(n));
        }
        this.dataView.getDataViewPageContext().setCurrentRows(list);
    }

    void disableButtons() {
        this.truncateButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.refreshField.setEnabled(false);
        this.first.setEnabled(false);
        this.previous.setEnabled(false);
        this.next.setEnabled(false);
        this.last.setEnabled(false);
        this.deleteRow.setEnabled(false);
        this.commit.setEnabled(false);
        this.cancel.setEnabled(false);
        this.insert.setEnabled(false);
        this.dataPanel.revalidate();
        this.dataPanel.repaint();
    }

    int getPageSize() {
        int n = this.dataView.getDataViewPageContext().getPageSize();
        int n2 = this.dataView.getDataViewPageContext().getTotalRows();
        try {
            int n3 = Integer.parseInt(this.refreshField.getText().trim());
            return n3 < 0 ? n : n3;
        }
        catch (NumberFormatException numberFormatException) {
            return n2 < n ? n2 : n;
        }
    }

    boolean isDirty() {
        return this.dataPanel.isDirty();
    }

    void resetToolbar(boolean bl) {
        this.refreshButton.setEnabled(true);
        this.refreshField.setEnabled(true);
        this.deleteRow.setEnabled(false);
        DataViewPageContext dataViewPageContext = this.dataView.getDataViewPageContext();
        if (!bl) {
            if (dataViewPageContext.hasPrevious()) {
                this.first.setEnabled(true);
                this.previous.setEnabled(true);
            }
            if (dataViewPageContext.hasNext()) {
                this.next.setEnabled(true);
                this.last.setEnabled(true);
            }
            if (dataViewPageContext.hasOnePageOnly()) {
                this.first.setEnabled(false);
                this.previous.setEnabled(false);
            }
            if (dataViewPageContext.isLastPage()) {
                this.next.setEnabled(false);
                this.last.setEnabled(false);
            }
            if (!this.isEditable()) {
                this.commit.setEnabled(false);
                this.cancel.setEnabled(false);
                this.deleteRow.setEnabled(false);
                this.insert.setEnabled(false);
                this.truncateButton.setEnabled(false);
                this.dataPanel.setEditable(false);
            } else {
                if (dataViewPageContext.hasRows()) {
                    this.truncateButton.setEnabled(true);
                } else {
                    this.deleteRow.setEnabled(false);
                    this.truncateButton.setEnabled(false);
                    dataViewPageContext.first();
                }
                this.insert.setEnabled(true);
                if (this.getUpdatedRowContext().getUpdateKeys().isEmpty()) {
                    this.commit.setEnabled(false);
                    this.cancel.setEnabled(false);
                } else {
                    this.commit.setEnabled(true);
                    this.cancel.setEnabled(true);
                }
            }
        } else {
            this.disableButtons();
        }
        this.refreshField.setText("" + dataViewPageContext.getPageSize());
        if (this.dataPanel != null) {
            this.dataPanel.revalidate();
            this.dataPanel.repaint();
        }
    }

    private ActionListener createOutputListener() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object.equals(DataViewUI.this.refreshButton)) {
                    DataViewUI.this.actionHandler.refreshActionPerformed();
                } else if (object.equals(DataViewUI.this.first)) {
                    DataViewUI.this.actionHandler.firstActionPerformed();
                } else if (object.equals(DataViewUI.this.last)) {
                    DataViewUI.this.actionHandler.lastActionPerformed();
                } else if (object.equals(DataViewUI.this.next)) {
                    DataViewUI.this.actionHandler.nextActionPerformed();
                } else if (object.equals(DataViewUI.this.previous)) {
                    DataViewUI.this.actionHandler.previousActionPerformed();
                } else if (object.equals(DataViewUI.this.refreshField)) {
                    DataViewUI.this.actionHandler.setMaxActionPerformed();
                } else if (object.equals(DataViewUI.this.commit)) {
                    DataViewUI.this.actionHandler.commitActionPerformed(false);
                } else if (object.equals(DataViewUI.this.cancel)) {
                    DataViewUI.this.actionHandler.cancelEditPerformed();
                } else if (object.equals(DataViewUI.this.deleteRow)) {
                    DataViewUI.this.actionHandler.deleteRecordActionPerformed();
                } else if (object.equals(DataViewUI.this.insert)) {
                    DataViewUI.this.actionHandler.insertActionPerformed();
                } else if (object.equals(DataViewUI.this.truncateButton)) {
                    DataViewUI.this.actionHandler.truncateActionPerformed();
                }
            }
        };
        return actionListener;
    }

    private void processButton(AbstractButton abstractButton) {
        abstractButton.setContentAreaFilled(false);
        abstractButton.setBorderPainted(false);
        abstractButton.setMargin(BUTTON_INSETS);
        if (abstractButton instanceof AbstractButton) {
            abstractButton.addMouseListener(sharedMouseListener);
        }
        abstractButton.setFocusable(false);
    }

    private void initToolbar(JToolBar jToolBar, ActionListener actionListener) {
        jToolBar.addSeparator(new Dimension(10, 10));
        URL uRL = this.getClass().getResource(this.imgPrefix + "refresh.png");
        this.refreshButton = new JButton(new ImageIcon(uRL));
        this.refreshButton.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_refresh"));
        this.refreshButton.addActionListener(actionListener);
        this.processButton(this.refreshButton);
        jToolBar.add(this.refreshButton);
        uRL = this.getClass().getResource(this.imgPrefix + "navigate_beginning.png");
        this.first = new JButton(new ImageIcon(uRL));
        this.first.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_first"));
        this.first.addActionListener(actionListener);
        this.first.setEnabled(false);
        this.processButton(this.first);
        jToolBar.add(this.first);
        uRL = this.getClass().getResource(this.imgPrefix + "navigate_left.png");
        this.previous = new JButton(new ImageIcon(uRL));
        this.previous.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_previous"));
        this.previous.addActionListener(actionListener);
        this.previous.setEnabled(false);
        this.processButton(this.previous);
        jToolBar.add(this.previous);
        uRL = this.getClass().getResource(this.imgPrefix + "navigate_right.png");
        this.next = new JButton(new ImageIcon(uRL));
        this.next.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_next"));
        this.next.addActionListener(actionListener);
        this.next.setEnabled(false);
        this.processButton(this.next);
        jToolBar.add(this.next);
        uRL = this.getClass().getResource(this.imgPrefix + "navigate_end.png");
        this.last = new JButton(new ImageIcon(uRL));
        this.last.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_last"));
        this.last.addActionListener(actionListener);
        this.last.setEnabled(false);
        jToolBar.add(this.last);
        this.processButton(this.last);
        jToolBar.addSeparator(new Dimension(10, 10));
        this.limitRow = new JLabel(NbBundle.getMessage(DataViewUI.class, (String)"LBL_max_rows"));
        this.limitRow.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 8));
        jToolBar.add(this.limitRow);
        this.refreshField = new JTextField();
        this.refreshField.setText("" + this.dataView.getDataViewPageContext().getPageSize());
        this.refreshField.setMinimumSize(new Dimension(35, this.refreshField.getHeight()));
        this.refreshField.setSize(35, this.refreshField.getHeight());
        this.refreshField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (DataViewUI.this.refreshField.getText().length() >= 4) {
                    keyEvent.consume();
                }
            }
        });
        this.refreshField.addActionListener(actionListener);
        jToolBar.add(this.refreshField);
        jToolBar.addSeparator(new Dimension(10, 10));
        JLabel jLabel = new JLabel(NbBundle.getMessage(DataViewUI.class, (String)"LBL_total_rows"));
        jLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DataViewUI.class, (String)"LBL_total_rows"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 8));
        jToolBar.add(jLabel);
        this.totalRowsLabel = new JLabel();
        jToolBar.add(this.totalRowsLabel);
        Box.Filler filler = new Box.Filler(new Dimension(this.getWidth(), this.getHeight()), new Dimension(700, this.getHeight()), new Dimension(this.getWidth(), this.getHeight()));
        jToolBar.add(filler);
    }

    private void initVerticalToolbar(ActionListener actionListener) {
        URL uRL = this.getClass().getResource(this.imgPrefix + "row_add.png");
        this.insert = new JButton(new ImageIcon(uRL));
        this.insert.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_insert"));
        this.insert.addActionListener(actionListener);
        this.insert.setEnabled(false);
        this.processButton(this.insert);
        this.editButtons[0] = this.insert;
        uRL = this.getClass().getResource(this.imgPrefix + "row_delete.png");
        this.deleteRow = new JButton(new ImageIcon(uRL));
        this.deleteRow.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_deleterow"));
        this.deleteRow.addActionListener(actionListener);
        this.deleteRow.setEnabled(false);
        this.processButton(this.deleteRow);
        this.editButtons[1] = this.deleteRow;
        uRL = this.getClass().getResource(this.imgPrefix + "row_commit.png");
        this.commit = new JButton(new ImageIcon(uRL));
        this.commit.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_commit_all"));
        this.commit.addActionListener(actionListener);
        this.commit.setEnabled(false);
        this.processButton(this.commit);
        this.editButtons[2] = this.commit;
        uRL = this.getClass().getResource(this.imgPrefix + "cancel_edits.png");
        this.cancel = new JButton(new ImageIcon(uRL));
        this.cancel.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_cancel_edits"));
        this.cancel.addActionListener(actionListener);
        this.cancel.setEnabled(false);
        this.processButton(this.cancel);
        this.editButtons[3] = this.cancel;
        uRL = this.getClass().getResource(this.imgPrefix + "table_truncate.png");
        this.truncateButton = new JButton(new ImageIcon(uRL));
        this.truncateButton.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_truncate_table"));
        this.truncateButton.addActionListener(actionListener);
        this.truncateButton.setEnabled(false);
        this.processButton(this.truncateButton);
        this.editButtons[4] = this.truncateButton;
    }

    private JPanel initializeMainPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        ActionListener actionListener = this.createOutputListener();
        this.initVerticalToolbar(actionListener);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        if (!bl) {
            JButton[] jButtonArray;
            for (JButton jButton : jButtonArray = this.getEditButtons()) {
                if (jButton == null) continue;
                jToolBar.add(jButton);
            }
        }
        this.initToolbar(jToolBar, actionListener);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 23;
        jPanel.add((Component)jToolBar, gridBagConstraints);
        this.validate();
        return jPanel;
    }

    public void enableDeleteBtn(boolean bl) {
        this.deleteRow.setEnabled(bl);
    }
}

