/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.openide.ErrorManager;
import org.w3c.dom.Element;

public class BoxType {
    public static final BoxType NONE = new BoxType("none");
    public static final BoxType STATIC = new BoxType("static");
    public static final BoxType ABSOLUTE = new BoxType("absolute");
    public static final BoxType FIXED = new BoxType("fixed");
    public static final BoxType FLOAT = new BoxType("float");
    public static final BoxType RELATIVE = new BoxType("relative");
    public static final BoxType LINEBOX = new BoxType("linebox");
    public static final BoxType SPACE = new BoxType("space");
    public static final BoxType LINEBREAK = new BoxType("linebreak");
    public static final BoxType TEXT = new BoxType("text");
    private final String description;

    private BoxType(String string) {
        this.description = string;
    }

    public static BoxType getBoxType(Element element) {
        if (CssProvider.getValueService().isNoneValue(CssProvider.getEngineService().getComputedValueForElement(element, 22))) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Element has none display style, element=" + element));
        }
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 23);
        if (!CssProvider.getValueService().isNoneValue(cssValue)) {
            return FLOAT;
        }
        cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 48);
        if (CssProvider.getValueService().isStaticValue(cssValue)) {
            return STATIC;
        }
        if (CssProvider.getValueService().isAbsoluteValue(cssValue)) {
            return ABSOLUTE;
        }
        if (CssProvider.getValueService().isRelativeValue(cssValue)) {
            return RELATIVE;
        }
        if (CssProvider.getValueService().isFixedValue(cssValue)) {
            return FIXED;
        }
        return STATIC;
    }

    public boolean isNormalFlow() {
        return this == STATIC || this == RELATIVE || this == LINEBOX;
    }

    public boolean isAbsolutelyPositioned() {
        return this == ABSOLUTE || this == FIXED;
    }

    public boolean isPositioned() {
        return this == ABSOLUTE || this == FIXED || this == RELATIVE;
    }

    public boolean isInlineTextBox() {
        return this == TEXT || this == LINEBREAK || this == SPACE;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return super.toString() + "[description=" + this.description + "]";
    }
}

