/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.w3c.dom.Element;

public class CssBorder {
    public static final int FRAME_VOID = 0;
    public static final int FRAME_TOP = 1;
    public static final int FRAME_BOTTOM = 2;
    public static final int FRAME_LEFT = 4;
    public static final int FRAME_RIGHT = 8;
    public static final int FRAME_BOX = 15;
    public static final int FRAME_UNSET = 143;
    public static final int WIDTH_THIN = 1;
    public static final int WIDTH_MEDIUM = 3;
    static final int STYLE_UNKNOWN = -1;
    static final int STYLE_NONE = 0;
    static final int STYLE_SOLID = 1;
    static final int STYLE_DASHED = 2;
    static final int STYLE_DOTTED = 3;
    static final int STYLE_DOUBLE = 4;
    static final int STYLE_GROOVE = 5;
    static final int STYLE_RIDGE = 6;
    static final int STYLE_INSET = 7;
    static final int STYLE_OUTSET = 8;
    private static CssBorder designerBorder = null;
    private static CssBorder emptyBorder = null;
    private static final Color TRANSPARENT = new Color(0, 0, 0);
    private final Color topColor;
    private final Color bottomColor;
    private final Color leftColor;
    private final Color rightColor;
    private Color topAltColor;
    private Color bottomAltColor;
    private Color leftAltColor;
    private Color rightAltColor;
    private Stroke topStroke;
    private Stroke bottomStroke;
    private Stroke leftStroke;
    private Stroke rightStroke;
    private final int topWidth;
    private final int bottomWidth;
    private final int rightWidth;
    private final int leftWidth;
    private Stroke prevStroke = null;
    private int prevWidth = -1;
    private int prevStyle = -1;
    int[] pointsX = new int[4];
    int[] pointsY = new int[4];

    private CssBorder(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, Color color2, Color color3, Color color4) {
        this.topWidth = n;
        this.bottomWidth = n2;
        this.leftWidth = n4;
        this.rightWidth = n3;
        if (n8 != 1 && n8 != 4) {
            if (n8 == 7) {
                color4 = color4.darker();
            } else if (n8 == 8) {
                color4 = color4.brighter();
            } else if (n8 == 6) {
                this.leftAltColor = color4.darker();
                color4 = color4.brighter();
            } else if (n8 == 5) {
                this.leftAltColor = color4.brighter();
                color4 = color4.darker();
            } else {
                this.leftStroke = this.getStroke(n4, n8);
            }
        }
        if (n5 != 1 && n5 != 4) {
            if (n5 == 7) {
                color = color.darker();
            } else if (n5 == 8) {
                color = color.brighter();
            } else if (n5 == 6) {
                this.topAltColor = color.darker();
                color = color.brighter();
            } else if (n5 == 5) {
                this.topAltColor = color.brighter();
                color = color.darker();
            } else if (n5 != 0) {
                this.topStroke = this.getStroke(n, n5);
            }
        }
        if (n6 != 1 && n6 != 4) {
            if (n6 == 7) {
                color3 = color3.brighter();
            } else if (n6 == 8) {
                color3 = color3.darker();
            } else if (n6 == 6) {
                this.rightAltColor = color3.brighter();
                color3 = color3.darker();
            } else if (n6 == 5) {
                this.rightAltColor = color3.darker();
                color3 = color3.brighter();
            } else if (n6 != 0) {
                this.rightStroke = this.getStroke(n3, n6);
            }
        }
        if (n7 != 1 && n7 != 4) {
            if (n7 == 7) {
                color2 = color2.brighter();
            } else if (n7 == 8) {
                color2 = color2.darker();
            } else if (n7 == 6) {
                this.bottomAltColor = color2.brighter();
                color2 = color2.darker();
            } else if (n7 == 5) {
                this.bottomAltColor = color2.darker();
                color2 = color2.brighter();
            } else {
                this.bottomStroke = this.getStroke(n2, n7);
            }
        }
        this.leftColor = color4;
        this.rightColor = color3;
        this.bottomColor = color2;
        this.topColor = color;
    }

    public static CssBorder getBorder(Element element) {
        return CssBorder.getBorder(element, -1, 0, 15);
    }

    public static CssBorder getBorder(Element element, int n, int n2, int n3) {
        int n4 = CssBorder.getBorderStyle(element, 9);
        int n5 = CssBorder.getBorderStyle(element, 10);
        int n6 = CssBorder.getBorderStyle(element, 11);
        int n7 = CssBorder.getBorderStyle(element, 12);
        if (n4 == -1) {
            n4 = (n3 & 4) != 0 ? n2 : 0;
        }
        if (n5 == -1) {
            n5 = (n3 & 8) != 0 ? n2 : 0;
        }
        if (n6 == -1) {
            n6 = (n3 & 1) != 0 ? n2 : 0;
        }
        if (n7 == -1) {
            n7 = (n3 & 2) != 0 ? n2 : 0;
        }
        if (n6 == 0 && n7 == 0 && n4 == 0 && n5 == 0 && n3 == 0) {
            return null;
        }
        int n8 = n6 == 0 ? 0 : CssBorder.getBorderWidth(element, 15, n);
        int n9 = n7 == 0 ? 0 : CssBorder.getBorderWidth(element, 16, n);
        int n10 = n4 == 0 ? 0 : CssBorder.getBorderWidth(element, 13, n);
        int n11 = n5 == 0 ? 0 : CssBorder.getBorderWidth(element, 14, n);
        if (n8 == -1) {
            n8 = n6 == 0 ? 0 : 3;
        }
        if (n9 == -1) {
            n9 = n7 == 0 ? 0 : 3;
        }
        if (n11 == -1) {
            n11 = n5 == 0 ? 0 : 3;
        }
        if (n10 == -1) {
            n10 = n4 == 0 ? 0 : 3;
        }
        if (n8 == 0 && n9 == 0 && n10 == 0 && n11 == 0) {
            return null;
        }
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        if (n10 != 0) {
            color4 = CssBorder.getColor(element, 5);
        }
        if (n11 > 0) {
            color3 = CssBorder.getColor(element, 6);
        }
        if (n8 > 0) {
            color = CssBorder.getColor(element, 7);
        }
        if (n9 > 0) {
            color2 = CssBorder.getColor(element, 8);
        }
        if (n8 > 0 && n6 != 0 && color == null) {
            color = CssBorder.getDefaultColor(element);
        }
        if (n9 > 0 && n7 != 0 && color2 == null) {
            color2 = CssBorder.getDefaultColor(element);
        }
        if (n10 > 0 && n4 != 0 && color4 == null) {
            color4 = CssBorder.getDefaultColor(element);
        }
        if (n11 > 0 && n5 != 0 && color3 == null) {
            color3 = CssBorder.getDefaultColor(element);
        }
        if (color == TRANSPARENT) {
            n6 = 0;
        }
        if (color2 == TRANSPARENT) {
            n7 = 0;
        }
        if (color4 == TRANSPARENT) {
            n4 = 0;
        }
        if (color3 == TRANSPARENT) {
            n5 = 0;
        }
        if (n6 == 0 && n7 == 0 && n4 == 0 && n5 == 0) {
            return null;
        }
        if (color == null) {
            color = CssBorder.getDefaultColor(element);
        }
        if (color2 == null) {
            color2 = CssBorder.getDefaultColor(element);
        }
        if (color4 == null) {
            color4 = CssBorder.getDefaultColor(element);
        }
        if (color3 == null) {
            color3 = CssBorder.getDefaultColor(element);
        }
        return new CssBorder(n8, n9, n11, n10, n6, n5, n7, n4, color, color2, color3, color4);
    }

    private static int getBorderWidth(Element element, int n, int n2) {
        if (n2 != -1 && CssProvider.getEngineService().isDefaultStyleValueForElement(element, null, n)) {
            return n2;
        }
        int n3 = CssUtilities.getCssLength(element, n);
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    private static Color getColor(Element element, int n) {
        return CssProvider.getValueService().getColorForElement(element, n);
    }

    private static Color getDefaultColor(Element element) {
        Color color = CssProvider.getValueService().getColorForElement(element, 20);
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    private static int getBorderStyle(Element element, int n) {
        if (CssProvider.getEngineService().isDefaultStyleValueForElement(element, null, n)) {
            return -1;
        }
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, n);
        if (CssProvider.getValueService().isNoneValue(cssValue)) {
            return 0;
        }
        if (CssProvider.getValueService().isHiddenValue(cssValue)) {
            return 0;
        }
        if (CssProvider.getValueService().isDottedValue(cssValue)) {
            return 3;
        }
        if (CssProvider.getValueService().isDashedValue(cssValue)) {
            return 2;
        }
        if (CssProvider.getValueService().isSolidValue(cssValue)) {
            return 1;
        }
        if (CssProvider.getValueService().isDoubleValue(cssValue)) {
            return 4;
        }
        if (CssProvider.getValueService().isGrooveValue(cssValue)) {
            return 5;
        }
        if (CssProvider.getValueService().isRidgeValue(cssValue)) {
            return 6;
        }
        if (CssProvider.getValueService().isInsetValue(cssValue)) {
            return 7;
        }
        if (CssProvider.getValueService().isOutsetValue(cssValue)) {
            return 8;
        }
        return -1;
    }

    public static CssBorder getDesignerBorder() {
        if (designerBorder == null) {
            Color color = Color.lightGray;
            designerBorder = new CssBorder(1, 1, 1, 1, 2, 2, 2, 2, color, color, color, color);
        }
        return designerBorder;
    }

    static CssBorder getBorder(int n, int n2, Color color) {
        return new CssBorder(n2, n2, n2, n2, n, n, n, n, color, color, color, color);
    }

    public static CssBorder getEmptyBorder() {
        if (emptyBorder == null) {
            emptyBorder = new CssBorder(0, 0, 0, 0, 0, 0, 0, 0, Color.black, Color.black, Color.black, Color.black);
        }
        return emptyBorder;
    }

    private Stroke getStroke(int n, int n2) {
        if (n == 0) {
            return null;
        }
        if (this.prevWidth == n && this.prevStyle == n2) {
            return this.prevStroke;
        }
        BasicStroke basicStroke = null;
        switch (n2) {
            case -1: 
            case 0: {
                break;
            }
            case 2: {
                basicStroke = new BasicStroke(n, 2, 0, 10.0f, new float[]{6 * n, 6 * n + n}, 0.0f);
                break;
            }
            case 3: {
                basicStroke = new BasicStroke(n, 2, 0, 10.0f, new float[]{n, 3 * n}, 0.0f);
                break;
            }
        }
        this.prevStroke = basicStroke;
        this.prevStyle = n2;
        this.prevWidth = n;
        return basicStroke;
    }

    public void paintBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics.getColor();
        Stroke stroke = graphics2D.getStroke();
        if (this.topStroke == this.bottomStroke && this.bottomStroke == this.rightStroke && this.rightStroke == this.leftStroke && (this.topStroke == null || this.topColor == this.bottomColor && this.bottomColor == this.rightColor && this.rightColor == this.leftColor)) {
            if (this.topStroke != null) {
                graphics.setColor(this.topColor);
                graphics2D.setStroke(this.topStroke);
                if (this.topWidth == 1) {
                    graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
                } else {
                    int n5 = n + this.leftWidth / 2;
                    if ((this.leftWidth & 1) == 1) {
                        --n5;
                    }
                    int n6 = n + n3 - 1 - this.rightWidth / 2;
                    int n7 = n2 + this.topWidth / 2;
                    if ((this.topWidth & 1) == 1) {
                        --n7;
                    }
                    int n8 = n2 + n4 - 1 - this.bottomWidth / 2;
                    graphics2D.drawRect(n5, n7, n6 - n5, n8 - n7);
                }
            } else {
                graphics2D.setStroke(stroke);
                if (this.topAltColor != null && this.topWidth > 1) {
                    graphics.setColor(this.topColor);
                    this.paintTop(graphics2D, n, n2, n3, this.topWidth / 2, this.leftWidth / 2, this.rightWidth / 2);
                    graphics.setColor(this.topAltColor);
                    this.paintTop(graphics2D, n + this.leftWidth / 2, n2 + this.topWidth / 2, n3 - this.leftWidth / 2 - this.rightWidth / 2, this.topWidth / 2 + this.topWidth % 2, this.leftWidth / 2 + this.leftWidth % 2, this.rightWidth / 2 + this.rightWidth % 2);
                } else {
                    graphics.setColor(this.topColor);
                    this.paintTop(graphics2D, n, n2, n3, this.topWidth, this.leftWidth, this.rightWidth);
                }
                if (this.bottomAltColor != null && this.bottomWidth > 1) {
                    graphics.setColor(this.bottomColor);
                    this.paintBottom(graphics2D, n, n2 + n4, n3, this.bottomWidth / 2, this.leftWidth / 2, this.rightWidth / 2);
                    graphics.setColor(this.bottomAltColor);
                    this.paintBottom(graphics2D, n + this.leftWidth / 2, n2 + n4 - this.bottomWidth / 2, n3 - this.leftWidth / 2 - this.rightWidth / 2, this.bottomWidth / 2 + this.bottomWidth % 2, this.leftWidth / 2 + this.leftWidth % 2, this.rightWidth / 2 + this.rightWidth % 2);
                } else {
                    graphics.setColor(this.bottomColor);
                    this.paintBottom(graphics2D, n, n2 + n4, n3, this.bottomWidth, this.leftWidth, this.rightWidth);
                }
                graphics.setColor(this.leftColor);
                if (this.leftAltColor != null && this.leftWidth > 1) {
                    graphics.setColor(this.leftColor);
                    this.paintLeft(graphics2D, n, n2, this.leftWidth / 2, n4, this.topWidth / 2, this.bottomWidth / 2);
                    graphics.setColor(this.leftAltColor);
                    this.paintLeft(graphics2D, n + this.leftWidth / 2 + this.leftWidth % 2, n2 + this.topWidth / 2 + this.topWidth % 2, this.leftWidth / 2 + this.leftWidth % 2, n4 - this.topWidth / 2 - this.bottomWidth / 2, this.topWidth / 2 + this.topWidth % 2, this.bottomWidth / 2 + this.bottomWidth % 2);
                } else {
                    graphics.setColor(this.leftColor);
                    this.paintLeft(graphics2D, n, n2, this.leftWidth, n4, this.topWidth, this.bottomWidth);
                }
                if (this.rightAltColor != null && this.rightWidth > 1) {
                    graphics.setColor(this.rightColor);
                    this.paintRight(graphics2D, n + n3, n2, this.rightWidth / 2, n4, this.topWidth / 2, this.bottomWidth / 2);
                    graphics.setColor(this.rightAltColor);
                    this.paintRight(graphics2D, n + n3 - this.rightWidth / 2 + this.rightWidth % 2, n2 + this.topWidth / 2 + this.topWidth % 2, this.rightWidth / 2 + this.rightWidth % 2, n4 - this.topWidth / 2 - this.bottomWidth / 2, this.topWidth / 2 + this.topWidth % 2, this.bottomWidth / 2 + this.bottomWidth % 2);
                } else {
                    graphics.setColor(this.rightColor);
                    this.paintRight(graphics2D, n + n3, n2, this.rightWidth, n4, this.topWidth, this.bottomWidth);
                }
            }
        } else {
            int n9;
            int n10;
            int n11;
            if (this.topStroke != null) {
                graphics.setColor(this.topColor);
                graphics2D.setStroke(this.topStroke);
                n11 = n - this.leftWidth + this.topWidth / 2;
                if ((this.topWidth & 1) == 1) {
                    --n11;
                }
                n10 = n2 + this.topWidth / 2;
                if ((this.topWidth & 1) == 1) {
                    --n10;
                }
                n9 = n + n3 - this.rightWidth - this.topWidth / 2;
                graphics2D.drawLine(n11, n10, n9, n10);
            } else if (this.topAltColor != null) {
                graphics2D.setStroke(stroke);
                graphics.setColor(this.topColor);
                this.paintTop(graphics2D, n, n2, n3, this.topWidth / 2, this.leftWidth / 2, this.rightWidth / 2);
                graphics.setColor(this.topAltColor);
                this.paintTop(graphics2D, n + this.leftWidth / 2, n2 + this.topWidth / 2, n3 - this.leftWidth / 2 - this.rightWidth / 2, this.topWidth / 2 + this.topWidth % 2, this.leftWidth / 2 + this.leftWidth % 2, this.rightWidth / 2 + this.rightWidth % 2);
            } else {
                graphics2D.setStroke(stroke);
                graphics.setColor(this.topColor);
                this.paintTop(graphics2D, n, n2, n3, this.topWidth, this.leftWidth, this.rightWidth);
            }
            if (this.bottomStroke != null) {
                graphics.setColor(this.bottomColor);
                graphics2D.setStroke(this.bottomStroke);
                n11 = n - this.leftWidth + this.bottomWidth / 2;
                if ((this.bottomWidth & 1) == 1) {
                    --n11;
                }
                n10 = n2 + n4 - this.bottomWidth / 2;
                n9 = n + n3 - this.rightWidth - this.bottomWidth / 2;
                graphics2D.drawLine(n11, n10, n9, n10);
            } else {
                graphics.setColor(this.bottomColor);
                graphics2D.setStroke(stroke);
                this.paintBottom(graphics2D, n, n2 + n4, n3, this.bottomWidth, this.leftWidth, this.rightWidth);
            }
            if (this.leftStroke != null) {
                graphics.setColor(this.leftColor);
                graphics2D.setStroke(this.leftStroke);
                n11 = n - this.leftWidth / 2;
                n10 = n2 - this.topWidth + this.leftWidth / 2;
                n9 = n2 + n4 + this.bottomWidth - this.leftWidth / 2;
                if ((this.leftWidth & 1) == 1) {
                    --n11;
                }
                if ((this.leftWidth & 1) == 1) {
                    --n10;
                }
                graphics2D.drawLine(n11, n10, n11, n9);
            } else {
                graphics.setColor(this.leftColor);
                graphics2D.setStroke(stroke);
                this.paintLeft(graphics2D, n, n2, this.leftWidth, n4, this.topWidth, this.bottomWidth);
            }
            if (this.rightStroke != null) {
                graphics.setColor(this.rightColor);
                graphics2D.setStroke(this.rightStroke);
                n11 = n + n3 - this.rightWidth / 2;
                n10 = n2 - this.topWidth + this.rightWidth / 2;
                if ((this.rightWidth & 1) == 0) {
                    --n10;
                }
                n9 = n2 + n4 + this.bottomWidth - this.rightWidth / 2;
                graphics2D.drawLine(n11, n10, n11, n9);
            } else {
                graphics.setColor(this.rightColor);
                graphics2D.setStroke(stroke);
                this.paintRight(graphics2D, n + n3, n2, this.rightWidth, n4, this.topWidth, this.bottomWidth);
            }
        }
        graphics.setColor(color);
        graphics2D.setStroke(stroke);
    }

    private void paintTop(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 == 1) {
            graphics2D.drawLine(n, n2, n + n3 - 1, n2);
        } else {
            this.pointsX[0] = n;
            this.pointsY[0] = n2;
            this.pointsX[1] = n + n3;
            this.pointsY[1] = n2;
            this.pointsX[2] = n + n3 - n6;
            this.pointsY[2] = n2 + n4;
            this.pointsX[3] = n + n5;
            this.pointsY[3] = this.pointsY[2];
            graphics2D.fillPolygon(this.pointsX, this.pointsY, 4);
        }
    }

    private void paintBottom(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.bottomWidth == 1) {
            graphics2D.drawLine(n, n2 - 1, n + n3 - 1, n2 - 1);
        } else {
            this.pointsX[0] = n;
            this.pointsY[0] = n2;
            this.pointsX[1] = n + n3;
            this.pointsY[1] = n2;
            this.pointsX[2] = n + n3 - n6;
            this.pointsY[2] = n2 - n4;
            this.pointsX[3] = n + n5;
            this.pointsY[3] = this.pointsY[2];
            graphics2D.fillPolygon(this.pointsX, this.pointsY, 4);
        }
    }

    private void paintLeft(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.leftWidth == 1) {
            graphics2D.drawLine(n, n2, n, n2 + n4 - 1);
        } else {
            this.pointsX[0] = n;
            this.pointsY[0] = n2;
            this.pointsX[1] = n;
            this.pointsY[1] = n2 + n4;
            this.pointsX[2] = n + n3;
            this.pointsY[2] = n2 + n4 - n6;
            this.pointsX[3] = this.pointsX[2];
            this.pointsY[3] = n2 + n5;
            graphics2D.fillPolygon(this.pointsX, this.pointsY, 4);
        }
    }

    private void paintRight(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.rightWidth == 1) {
            graphics2D.drawLine(n - 1, n2, n - 1, n2 + n4 - 1);
        } else {
            this.pointsX[0] = n;
            this.pointsY[0] = n2;
            this.pointsX[1] = n;
            this.pointsY[1] = n2 + n4;
            this.pointsX[2] = n - n3;
            this.pointsY[2] = n2 + n4 - n6;
            this.pointsX[3] = this.pointsX[2];
            this.pointsY[3] = n2 + n5;
            graphics2D.fillPolygon(this.pointsX, this.pointsY, 4);
        }
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(1, 1, 1, 1);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public int getLeftBorderWidth() {
        return this.leftWidth;
    }

    public int getRightBorderWidth() {
        return this.rightWidth;
    }

    public int getTopBorderWidth() {
        return this.topWidth;
    }

    public int getBottomBorderWidth() {
        return this.bottomWidth;
    }

    public String toString() {
        return super.toString() + "[" + this.leftWidth + "," + this.rightWidth + "," + this.topWidth + "," + this.bottomWidth + "," + this.leftColor + "]";
    }
}

