/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Color;
import java.awt.Graphics;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.css2.BoxList;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.FormatContext;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.css2.SpaceBox;
import org.netbeans.modules.visualweb.css2.TableBox;
import org.netbeans.modules.visualweb.css2.TextBox;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.openide.ErrorManager;
import org.w3c.dom.Element;

public class LineBox
extends ContainerBox {
    private int maxWidth;
    private int nextX;
    boolean isFloated;

    public LineBox(WebForm webForm, Element element, int n, int n2) {
        super(webForm, element, BoxType.LINEBOX, true, false);
        this.maxWidth = n;
        this.nextX = n2;
        this.effectiveTopMargin = 0;
        this.effectiveBottomMargin = 0;
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getBoxCount(); ++i) {
            CssBox cssBox = this.getBox(i);
            if (cssBox.getBoxType() == BoxType.TEXT) {
                stringBuffer.append(((TextBox)cssBox).getText());
                continue;
            }
            if (cssBox.getBoxType() == BoxType.SPACE) {
                stringBuffer.append(' ');
                continue;
            }
            if (cssBox.getBoxType() == BoxType.LINEBREAK) {
                stringBuffer.append("<br>");
                continue;
            }
            if (cssBox.getElement() == null) continue;
            stringBuffer.append('<');
            stringBuffer.append(cssBox.getElement().getTagName());
            stringBuffer.append('>');
        }
        return "floated=" + this.isFloated + "," + "contents=" + stringBuffer.toString() + "," + super.paramString();
    }

    protected void initialize() {
        this.effectiveTopMargin = 0;
        this.effectiveBottomMargin = 0;
    }

    protected void initializeInvariants() {
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public boolean canFit(CssBox cssBox) {
        int n = cssBox.getWidth();
        return this.nextX + this.leftMargin + n <= this.maxWidth;
    }

    public boolean canFit(FormatContext formatContext, CssBox cssBox, int n) {
        if (cssBox.getParent() == null) {
            return this.canFit(cssBox);
        }
        int n2 = Math.max(cssBox.getHeight(), cssBox.getHeight());
        int n3 = formatContext.getMaxWidth(this, this.getParent(), n, n2);
        int n4 = cssBox.getWidth();
        return this.nextX + this.leftMargin + n4 <= n3;
    }

    public boolean isFull() {
        return this.nextX >= this.maxWidth;
    }

    public int getActualWidth() {
        return this.nextX;
    }

    public int getNextX() {
        return this.nextX;
    }

    public boolean isEmpty() {
        return this.getBoxCount() == 0;
    }

    public void applyHorizontalAlignments(int n, int n2, FormatContext formatContext) {
        if (this.isEmpty()) {
            return;
        }
        CssValue cssValue = null;
        Element element = this.getElement();
        if (element != null) {
            cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 50);
        } else {
            ErrorManager.getDefault().log("linebox element was null - can't look up an alignment for it");
        }
        if (cssValue != null && !CssProvider.getValueService().isLeftValue(cssValue)) {
            if (CssProvider.getValueService().isRightValue(cssValue)) {
                int n3 = n + this.containingBlockWidth - this.getWidth();
                this.setX(n3);
                return;
            }
            if (CssProvider.getValueService().isCenterValue(cssValue) || CssProvider.getValueService().isRaveCenterValue(cssValue)) {
                int n4 = n + (this.containingBlockWidth - this.getWidth()) / 2;
                this.setX(n4);
                return;
            }
            if (CssProvider.getValueService().isJustifyValue(cssValue)) {
                int n5 = this.getBoxCount();
                this.setX(0);
                if (n5 > 1) {
                    int n6;
                    int n7 = 0;
                    for (n6 = 0; n6 < n5; ++n6) {
                        n7 += this.getBox(n6).getWidth();
                    }
                    n6 = this.maxWidth - n7;
                    if (n6 < n7) {
                        int n8 = n6 / (n5 - 1);
                        int n9 = 0;
                        for (int i = 0; i < n5 - 1; ++i) {
                            CssBox cssBox = this.getBox(i);
                            cssBox.setX(n9);
                            n9 += cssBox.getWidth();
                            n9 += n8;
                        }
                        CssBox cssBox = this.getBox(n5 - 1);
                        cssBox.setX(this.maxWidth - cssBox.getWidth());
                    }
                }
            } else {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unexpected alignment value, cssAl=" + cssValue));
            }
        }
        this.setX(n);
    }

    public int applyVerticalAlignments() {
        int n;
        int n2;
        Object object;
        CssBox cssBox;
        int n3 = 0;
        int n4 = this.getBoxCount();
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            cssBox = this.getBox(i);
            object = CssProvider.getEngineService().getComputedValueForElement(cssBox.getElement(), 32);
            if (!(cssBox.isReplacedBox() || CssProvider.getValueService().isNormalValue((CssValue)object) || cssBox instanceof TableBox)) {
                n2 = (int)object.getFloatValue();
            } else {
                n2 = cssBox.getHeight();
                if (cssBox.getBoxType() == BoxType.TEXT) {
                    bl = true;
                }
            }
            int n7 = cssBox.getContributingBaseline();
            n = n2 - n7;
            if (n7 == 0) {
                n = 0;
            }
            if (n7 > n5) {
                n5 = n7;
            }
            if (n > n6) {
                n6 = n;
            }
            if ((cssBox.isReplacedBox() || CssProvider.getValueService().isNormalValue((CssValue)object) || cssBox instanceof TableBox) && n5 + n6 > n2) {
                n2 = n5 + n6;
            }
            CssBox cssBox2 = cssBox;
            while ((cssBox2 = cssBox2.originalInlineContainer) != null) {
                object = CssProvider.getEngineService().getComputedValueForElement(cssBox2.getElement(), 32);
                if (CssProvider.getValueService().isNormalValue((CssValue)object) || CssProvider.getEngineService().isInheritedStyleValueForElement(cssBox2.getElement(), 32)) continue;
                n2 = (int)object.getFloatValue();
                break;
            }
            if (n3 >= n2) continue;
            n3 = n2;
        }
        Element element = this.getElement();
        if (bl && element != null) {
            cssBox = CssProvider.getEngineService().getComputedValueForElement(element, 32);
            if (!CssProvider.getValueService().isNormalValue((CssValue)cssBox) && (n2 = (int)cssBox.getFloatValue()) > n3) {
                n3 = n2;
            }
        }
        int n8 = n3;
        for (n2 = 0; n2 < n4; ++n2) {
            int n9;
            object = this.getBox(n2);
            CssValue cssValue = ((CssBox)object).originalInlineContainer != null && !CssProvider.getEngineService().isInheritedStyleValueForElement(((CssBox)object).getElement(), 55) ? CssProvider.getEngineService().getComputedValueForElement(((CssBox)object).originalInlineContainer.getElement(), 55) : CssProvider.getEngineService().getComputedValueForElement(((CssBox)object).getElement(), 55);
            if (CssProvider.getValueService().isBaseLineValue(cssValue)) {
                n = n8 - ((CssBox)object).getBaseline();
                ((CssBox)object).setY(n);
                continue;
            }
            if (CssProvider.getValueService().isSuperValue(cssValue) || CssProvider.getValueService().isSubValue(cssValue)) {
                n = CssProvider.getValueService().isSuperValue(cssValue) ? -3 : 3;
                n9 = n8 - ((CssBox)object).getBaseline() + n;
                ((CssBox)object).setY(n9);
                continue;
            }
            if (CssProvider.getValueService().isTopValue(cssValue) || CssProvider.getValueService().isTextTopValue(cssValue)) {
                ((CssBox)object).setY(0);
                continue;
            }
            if (CssProvider.getValueService().isBottomValue(cssValue) || CssProvider.getValueService().isTextBottomValue(cssValue)) {
                ((CssBox)object).setY(n3 - ((CssBox)object).getHeight());
                continue;
            }
            if (CssProvider.getValueService().isMiddleValue(cssValue)) {
                if (LineBox.isTextualBox((CssBox)object)) {
                    n = (int)CssProvider.getValueService().getFontSizeForElement(element, this.webform.getDefaultFontSize()) / 2;
                    n9 = n8 - ((CssBox)object).getHeight() / 2 - n;
                    ((CssBox)object).setY(n9);
                    continue;
                }
                n = n8 / 2 - ((CssBox)object).getHeight() / 2;
                ((CssBox)object).setY(n);
                continue;
            }
            n = (int)cssValue.getFloatValue();
            n9 = n8 - ((CssBox)object).getBaseline() - n;
            ((CssBox)object).setY(n9);
        }
        if (n3 == 0 && element != null) {
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 32);
            n3 = CssProvider.getValueService().isNormalValue(cssValue) ? (int)(1.1 * (double)CssProvider.getValueService().getFontSizeForElement(element, this.webform.getDefaultFontSize())) : (int)cssValue.getFloatValue();
        }
        return n3;
    }

    private static boolean isTextualBox(CssBox cssBox) {
        if (cssBox == null) {
            return false;
        }
        BoxType boxType = cssBox.getBoxType();
        return boxType == BoxType.TEXT || boxType == BoxType.SPACE || boxType == BoxType.LINEBREAK;
    }

    protected void paintBackground(Graphics graphics, int n, int n2) {
        if (this.isEmpty()) {
            return;
        }
        n += this.getX();
        n2 += this.getY();
        int n3 = this.getBoxCount();
        for (int i = 0; i < n3; ++i) {
            CssBox cssBox = this.getBox(i);
            if (cssBox.getBoxType() == BoxType.LINEBREAK) {
                assert (i == n3 - 1);
                return;
            }
            CssBox cssBox2 = cssBox.getPositionedBy();
            if (cssBox2 != this) {
                cssBox.paintBackground(graphics, cssBox2.getAbsoluteX(), cssBox2.getAbsoluteY());
                continue;
            }
            cssBox.paintBackground(graphics, n, n2);
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.isEmpty()) {
            return;
        }
        n += this.getX();
        n2 += this.getY();
        int n3 = this.getBoxCount();
        for (int i = 0; i < n3; ++i) {
            CssBox cssBox;
            CssBox cssBox2 = this.getBox(i);
            if (cssBox2.getBoxType() == BoxType.LINEBREAK) {
                assert (i == n3 - 1);
                if (!CssBox.paintSpaces) continue;
            }
            if ((cssBox = cssBox2.getPositionedBy()) != this) {
                cssBox2.paint(graphics, cssBox.getAbsoluteX(), cssBox.getAbsoluteY());
                continue;
            }
            cssBox2.paint(graphics, n, n2);
        }
        if (CssBox.paintSpaces) {
            graphics.setColor(Color.PINK);
            graphics.drawRect(this.getAbsoluteX(), this.getAbsoluteY(), this.width == 0 ? 10 : this.width, this.height);
        }
    }

    protected void addBox(CssBox cssBox, CssBox cssBox2, CssBox cssBox3) {
        assert (cssBox.isInlineBox());
        if (cssBox.getBoxType() == BoxType.SPACE && this.getBoxCount() > 0 && this.getBox(this.getBoxCount() - 1).getBoxType() == BoxType.SPACE) {
            return;
        }
        if (this.boxes == null) {
            int n = 25;
            this.boxes = new BoxList(n);
            this.boxes.setSyncParentIndices(false);
            if (this.boxType != BoxType.LINEBOX) {
                this.boxes.setKeepSorted(true);
            }
        }
        this.boxes.add(cssBox, cssBox2, cssBox3);
        cssBox.setPositionedBy(this);
        cssBox.setLocation(this.nextX, 0);
        this.nextX += cssBox.getWidth() + cssBox.leftMargin + cssBox.rightMargin;
    }

    public void relayout(FormatContext formatContext) {
        throw new RuntimeException();
    }

    void computeHorizontalLengths(FormatContext formatContext) {
    }

    void computeVerticalLengths(FormatContext formatContext) {
    }

    public DomProvider.DomPosition computePosition(int n) {
        CssBox cssBox;
        int n2;
        if (this.getBoxCount() > 0 && (n2 = (cssBox = this.getBox(this.getBoxCount() - 1)).getX() + cssBox.getWidth() - 1) < n) {
            n = n2;
        }
        n2 = this.getBoxCount();
        for (int i = 0; i < n2; ++i) {
            DomProvider.DomPosition domPosition;
            DomProvider.DomPosition domPosition2;
            CssBox cssBox2 = this.getBox(i);
            if (cssBox2.getBoxType() == BoxType.LINEBREAK && ModelViewMapper.isValidPosition(this.webform, domPosition2 = this.webform.createDomPosition(cssBox2.getSourceElement(), false), false, this.webform.getManager().getInlineEditor())) {
                return domPosition2;
            }
            int n3 = cssBox2.getX();
            int n4 = n3 + cssBox2.getWidth();
            if (n3 > n) {
                Object object;
                Object object2;
                Object object3 = null;
                boolean bl = false;
                if (i > 0) {
                    int n5 = n3 - n;
                    object2 = this.getBox(i - 1);
                    int n6 = n - (((CssBox)object2).getX() + ((CssBox)object2).getWidth());
                    if (n5 <= n6) {
                        object3 = cssBox2;
                    } else {
                        object3 = object2;
                        bl = true;
                    }
                } else {
                    object3 = cssBox2;
                }
                if (((CssBox)object3).getBoxType() == BoxType.TEXT) {
                    object = (TextBox)object3;
                    object2 = ((TextBox)object).getFirstPosition();
                    if (!ModelViewMapper.isValidPosition(this.webform, (DomProvider.DomPosition)object2, false, this.webform.getManager().getInlineEditor())) continue;
                    return object2;
                }
                if (((CssBox)object3).getBoxType() == BoxType.SPACE) {
                    object = (SpaceBox)object3;
                    object2 = ((SpaceBox)object).getFirstPosition();
                    if (!ModelViewMapper.isValidPosition(this.webform, (DomProvider.DomPosition)object2, false, this.webform.getManager().getInlineEditor())) continue;
                    return object2;
                }
                object = this.webform.createDomPosition(((CssBox)object3).getSourceElement(), bl);
                if (!ModelViewMapper.isValidPosition(this.webform, (DomProvider.DomPosition)object, false, this.webform.getManager().getInlineEditor())) continue;
                return object;
            }
            if (n < n3 || n > n4) continue;
            if (cssBox2.getBoxType() == BoxType.TEXT) {
                DomProvider.DomPosition domPosition3 = ((TextBox)cssBox2).computePosition(n - n3);
                if (ModelViewMapper.isValidPosition(this.webform, domPosition3, false, this.webform.getManager().getInlineEditor())) {
                    return domPosition3;
                }
            } else if (cssBox2.getBoxType() == BoxType.SPACE && ModelViewMapper.isValidPosition(this.webform, domPosition = ((SpaceBox)cssBox2).computePosition(n - n3), false, this.webform.getManager().getInlineEditor())) {
                return domPosition;
            }
            boolean bl = n > (n3 + n4) / 2;
            DomProvider.DomPosition domPosition4 = this.webform.createDomPosition(cssBox2.getSourceElement(), bl);
            if (!ModelViewMapper.isValidPosition(this.webform, domPosition4, false, this.webform.getManager().getInlineEditor())) continue;
            return domPosition4;
        }
        return DomProvider.DomPosition.NONE;
    }
}

