/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class BasicDragGestureRecognizer
implements MouseListener,
MouseMotionListener {
    private MouseEvent dndArmedEvent = null;
    private static int motionThreshold;
    private static boolean checkedMotionThreshold;

    static int getMotionThreshold() {
        if (checkedMotionThreshold) {
            return motionThreshold;
        }
        checkedMotionThreshold = true;
        try {
            motionThreshold = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        }
        catch (Exception exception) {
            motionThreshold = 5;
        }
        return motionThreshold;
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        if ((n & 0x400) != 1024) {
            return 0;
        }
        JComponent jComponent = this.getComponent(mouseEvent);
        TransferHandler transferHandler = jComponent.getTransferHandler();
        return BasicDragGestureRecognizer.convertModifiersToDropAction(n, transferHandler.getSourceActions(jComponent));
    }

    private static int convertModifiersToDropAction(int n, int n2) {
        int n3 = 0;
        switch (n & 0xC0) {
            case 192: {
                n3 = 0x40000000;
                break;
            }
            case 128: {
                n3 = 1;
                break;
            }
            case 64: {
                n3 = 2;
                break;
            }
            default: {
                if ((n2 & 2) != 0) {
                    n3 = 2;
                    break;
                }
                if ((n2 & 1) != 0) {
                    n3 = 1;
                    break;
                }
                if ((n2 & 0x40000000) == 0) break;
                n3 = 0x40000000;
            }
        }
        return n3 & n2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dndArmedEvent = null;
        if (this.isDragPossible(mouseEvent) && this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.dndArmedEvent = mouseEvent;
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dndArmedEvent = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dndArmedEvent != null) {
            mouseEvent.consume();
            int n = this.mapDragOperationFromModifiers(mouseEvent);
            if (n == 0) {
                return;
            }
            int n2 = Math.abs(mouseEvent.getX() - this.dndArmedEvent.getX());
            int n3 = Math.abs(mouseEvent.getY() - this.dndArmedEvent.getY());
            if (n2 > BasicDragGestureRecognizer.getMotionThreshold() || n3 > BasicDragGestureRecognizer.getMotionThreshold()) {
                JComponent jComponent = this.getComponent(mouseEvent);
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, this.dndArmedEvent, n);
                this.dndArmedEvent = null;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    protected boolean isDragPossible(MouseEvent mouseEvent) {
        JComponent jComponent = this.getComponent(mouseEvent);
        return jComponent == null ? true : jComponent.getTransferHandler() != null;
    }

    protected JComponent getComponent(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            return jComponent;
        }
        return null;
    }

    static {
        checkedMotionThreshold = false;
    }
}

