/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Hashtable;
import java.util.Map;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.w3c.dom.Element;

public final class CssUtilities {
    public static final int AUTO = 0x7FFFFFFE;
    private static FontKey fontSearch = new FontKey(null, 0, 0);
    private static Map<FontKey, Font> fontTable = new Hashtable<FontKey, Font>();

    private CssUtilities() {
    }

    public static FontMetrics getDesignerFontMetricsForElement(Element element, String string, int n) {
        Font font = CssUtilities.getDesignerFontForElement(element, string, n);
        return DesignerUtils.getFontMetrics(font);
    }

    public static Font getDesignerFontForElement(Element element, String string, int n) {
        String[] stringArray = CssProvider.getValueService().getFontFamilyNamesForElement(element);
        int n2 = CssProvider.getValueService().getFontStyleForElement(element, 0);
        int n3 = Math.round(CssProvider.getValueService().getFontSizeForElement(element, n));
        for (String string2 : stringArray) {
            Font font = CssUtilities.getFont(string2, n2, n3);
            if (string != null && string.length() != 0 && font.canDisplayUpTo(string) != -1) continue;
            return font;
        }
        return CssUtilities.getFont(stringArray[stringArray.length - 1], n2, n3);
    }

    private static Font getFont(String string, int n, int n2) {
        fontSearch.setValue(string, n, n2);
        Font font = fontTable.get(fontSearch);
        if (font == null) {
            font = new Font(string, n, n2);
            FontKey fontKey = new FontKey(string, n, n2);
            fontTable.put(fontKey, font);
        }
        return font;
    }

    public static int getCssLength(Element element, int n) {
        return CssProvider.getValueService().getCssLength(element, n);
    }

    private static class FontKey {
        private String family;
        private int style;
        private int size;

        public FontKey(String string, int n, int n2) {
            this.setValue(string, n, n2);
        }

        public void setValue(String string, int n, int n2) {
            this.family = string != null ? string.intern() : null;
            this.style = n;
            this.size = n2;
        }

        public int hashCode() {
            int n = this.family != null ? this.family.hashCode() : 0;
            return n ^ this.style ^ this.size;
        }

        public boolean equals(Object object) {
            if (object instanceof FontKey) {
                FontKey fontKey = (FontKey)object;
                return this.size == fontKey.size && this.style == fontKey.style && this.family == fontKey.family;
            }
            return false;
        }
    }
}

