/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public class DesignerUtils {
    static final boolean DEBUG = ErrorManager.getDefault().getInstance(DesignerUtils.class.getName()).isLoggable(1);

    public static boolean onlyWhitespace(String string) {
        if (DEBUG) {
            DesignerUtils.debugLog(DesignerUtils.class.getName() + ".onlyWhitespace(String)");
        }
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static final int getNonTabbedTextWidth(char[] cArray, int n, int n2, FontMetrics fontMetrics) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (c == '\t' || c == '\n') {
                n3 += fontMetrics.charWidth(' ');
                continue;
            }
            n3 += fontMetrics.charWidth(c);
        }
        return n3;
    }

    public static void setActivatedNodes(final TopComponent topComponent, final Node[] nodeArray) {
        if (DEBUG) {
            DesignerUtils.debugLog(DesignerUtils.class.getName() + ".setActivatedNodes(TopComponent, Node[])");
        }
        if (nodeArray == null) {
            throw new IllegalArgumentException("Null node array.");
        }
        if (topComponent == null) {
            throw new IllegalArgumentException("Null TopComponent.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            topComponent.setActivatedNodes(nodeArray);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    topComponent.setActivatedNodes(nodeArray);
                }
            });
        }
    }

    public static final boolean inside(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < n3) {
            return false;
        }
        if (n2 < n4) {
            return false;
        }
        if (n > n3 + n5) {
            return false;
        }
        return n2 <= n4 + n6;
    }

    public static boolean intersects(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (DEBUG) {
            DesignerUtils.debugLog(DesignerUtils.class.getName() + ".intersects(Rectangle, int, int, int, int)");
        }
        if (rectangle == null) {
            throw new IllegalArgumentException("Null rectangle.");
        }
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (n3 <= 0 || n4 <= 0 || n5 <= 0 || n6 <= 0) {
            return false;
        }
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        n4 += n2;
        n5 += n7;
        n6 += n8;
        return !((n3 += n) >= n && n3 <= n7 || n4 >= n2 && n4 <= n8 || n5 >= n7 && n5 <= n || n6 >= n8 && n6 <= n2);
    }

    static void debugLog(String string) {
        ErrorManager.getDefault().getInstance(DesignerUtils.class.getName()).log(string);
    }

    public static FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }
}

