/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.DomProviderService;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.designer.ColorManager;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DesignerPaneUI;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.ImageCache;
import org.netbeans.modules.visualweb.designer.InlineEditor;
import org.netbeans.modules.visualweb.designer.InteractionManager;
import org.netbeans.modules.visualweb.designer.SelectionManager;
import org.netbeans.modules.visualweb.spi.designer.Decoration;
import org.netbeans.spi.palette.PaletteController;
import org.openide.ErrorManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebForm
implements Designer {
    private final DomProvider domProvider;
    private SelectionManager selection;
    private final CellRendererPane rendererPane = new CellRendererPane();
    private final DesignerPane designerPane;
    private ColorManager colors;
    private InteractionManager manager;
    private ImageCache imageCache;
    private final EventListenerList listenerList = new EventListenerList();
    private boolean paintSizeMask;
    private WeakReference<CssBox> initialFocusMarkCssBoxWRef = new WeakReference<Object>(null);
    private final Dimension pageSize = new Dimension(0, 0);
    private boolean gridShow;
    private boolean gridSnap;
    private int gridWidth;
    private int gridHeight;
    private int gridTraceWidth;
    private int gridTraceHeight;
    private boolean showDecorations;
    private int defaultFontSize;
    private static Map<Element, Map<WebForm, WeakReference<CssBox>>> element2webformMap = new WeakHashMap<Element, Map<WebForm, WeakReference<CssBox>>>(500);

    private WebForm(DomProvider domProvider) {
        if (domProvider == null) {
            throw new NullPointerException("The domProvider parameter can't be null!");
        }
        this.domProvider = domProvider;
        this.designerPane = new DesignerPane(this);
    }

    public static WebForm createWebForm(DomProvider domProvider) {
        return new WebForm(domProvider);
    }

    public DomProviderService getDomProviderService() {
        return this.domProvider.getDomProviderService();
    }

    public DomProvider getDomProvider() {
        return this.domProvider;
    }

    public String toString() {
        return super.toString() + "[domProvider=" + this.domProvider + "]";
    }

    public void setCssBoxForElement(Element element, CssBox cssBox) {
        Node node = element.getParentNode();
        if (node instanceof Element && this.getCssBoxForElement((Element)node) == cssBox) {
            return;
        }
        Map<WebForm, WeakReference<CssBox>> map = element2webformMap.get(element);
        if (map == null) {
            map = new WeakHashMap<WebForm, WeakReference<CssBox>>();
        }
        map.put(this, new WeakReference<CssBox>(cssBox));
        element2webformMap.put(element, map);
    }

    public CssBox getCssBoxForElement(Element element) {
        if (element == null) {
            return null;
        }
        Map<WebForm, WeakReference<CssBox>> map = element2webformMap.get(element);
        WeakReference<CssBox> weakReference = map == null ? null : map.get(this);
        return weakReference == null ? null : (CssBox)weakReference.get();
    }

    public void copyBoxForElement(Element element, Element element2) {
        CssBox cssBox = this.getCssBoxForElement(element);
        this.setCssBoxForElement(element2, cssBox);
    }

    public CssBox findCssBoxForElement(Element element) {
        CssBox cssBox = this.getCssBoxForElement(element);
        if (cssBox != null) {
            while (cssBox.getParent() != null && cssBox.getParent().getElement() == element) {
                cssBox = cssBox.getParent();
            }
            this.setCssBoxForElement(element, cssBox);
            return cssBox;
        }
        return null;
    }

    public DesignerPane getPane() {
        return this.designerPane;
    }

    public boolean hasSelection() {
        return this.selection != null;
    }

    public SelectionManager getSelection() {
        if (this.selection == null) {
            this.selection = new SelectionManager(this);
        }
        return this.selection;
    }

    public DomProvider.DomDocument getDomDocument() {
        return this.domProvider.getDomDocument();
    }

    public Document getHtmlDom() {
        return this.domProvider.getHtmlDom();
    }

    public Element getHtmlBody() {
        return this.domProvider.getHtmlBody();
    }

    public void setPaneGrid(boolean bl) {
        DesignerPane designerPane = this.getPane();
        if (designerPane != null) {
            designerPane.setGridMode(bl);
        }
    }

    public boolean isGridMode() {
        return this.domProvider.isGridMode();
    }

    public CellRendererPane getRenderPane() {
        return this.rendererPane;
    }

    public ColorManager getColors() {
        if (this.colors == null) {
            this.colors = new ColorManager(this);
        }
        return this.colors;
    }

    public InteractionManager getManager() {
        if (this.manager == null) {
            this.manager = new InteractionManager(this);
        }
        return this.manager;
    }

    public ImageCache getImageCache() {
        if (this.imageCache == null) {
            this.imageCache = new ImageCache();
        }
        return this.imageCache;
    }

    public boolean hasCachedFrameBoxes() {
        return this.domProvider.hasCachedExternalFrames();
    }

    private void flushCaches() {
        if (this.imageCache != null) {
            this.imageCache.flush();
        }
    }

    public void changeNode(Node node, Node node2, Element[] elementArray) {
        PageBox pageBox = this.getPane().getPaneUI().getPageBox();
        if (pageBox == null) {
            return;
        }
        pageBox.changed(node, node2, elementArray);
    }

    public void removeNode(Node node, Node node2) {
        PageBox pageBox = this.getPane().getPaneUI().getPageBox();
        if (pageBox == null) {
            return;
        }
        pageBox.removed(node, node2);
    }

    public void insertNode(Node node, Node node2) {
        PageBox pageBox = this.getPane().getPaneUI().getPageBox();
        if (pageBox == null) {
            return;
        }
        pageBox.inserted(node, node2);
    }

    public void detachDomDocument() {
        DesignerPane designerPane = this.getPane();
        if (designerPane != null && designerPane.hasCaret()) {
            designerPane.caretDetachDom();
        }
    }

    public DomProvider[] getExternalDomProviders() {
        DesignerPane designerPane = this.getPane();
        if (designerPane == null) {
            return new DomProvider[0];
        }
        PageBox pageBox = designerPane.getPageBox();
        if (pageBox == null) {
            return new DomProvider[0];
        }
        WebForm[] webFormArray = pageBox.findExternalForms();
        ArrayList<DomProvider> arrayList = new ArrayList<DomProvider>();
        for (WebForm webForm : webFormArray) {
            if (webForm == null || webForm == this) continue;
            arrayList.add(webForm.domProvider);
        }
        return arrayList.toArray(new DomProvider[arrayList.size()]);
    }

    public void resetAll() {
        this.getManager().finishInlineEditing(false);
        this.flushCaches();
        final DesignerPane designerPane = this.getPane();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WebForm.this.getSelection().updateNodes();
                if (designerPane != null) {
                    designerPane.repaint();
                }
            }
        });
    }

    boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, Transferable transferable) {
        return this.domProvider.canImport(jComponent, dataFlavorArray, transferable);
    }

    int computeActions(Element element, Transferable transferable) {
        return this.domProvider.computeActions(element, transferable);
    }

    int processLinks(Element element, Element element2) {
        return this.domProvider.processLinks(element, element2);
    }

    public void showDropMatch(Element element, Element element2, int n) {
        this.getPane().getDndHandler().showDropMatch(element, element2, n);
    }

    public void clearDropMatch() {
        this.getPane().getDndHandler().clearDropMatch();
    }

    public void selectComponentDelayed(final Element element) {
        if (element != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    WebForm.this.getSelection().selectBean(element);
                }
            });
        }
    }

    public void inlineEditComponents(Element[] elementArray) {
        this.getManager().inlineEdit(elementArray);
    }

    public URL getBaseUrl() {
        return this.domProvider.getBaseUrl();
    }

    public URL resolveUrl(String string) {
        return this.domProvider.resolveUrl(string);
    }

    public PaletteController getPaletteController() {
        return this.domProvider.getPaletteController();
    }

    boolean canDropComponentsAtNode(Element[] elementArray, Node node) {
        return this.domProvider.canDropComponentsAtNode(elementArray, node);
    }

    public boolean moveComponent(Element element, Node node, Node node2) {
        return this.domProvider.moveComponent(element, node, node2);
    }

    public boolean isFormComponent(Element element) {
        return this.domProvider.isFormComponent(element);
    }

    int getDropType(Element element, Element element2, Transferable transferable, boolean bl) {
        return this.domProvider.getDropType(element, element2, transferable, bl);
    }

    int getDropTypeForComponent(Element element, Element element2, Element element3, boolean bl) {
        return this.domProvider.getDropTypeForComponent(element, element2, element3, bl);
    }

    Element getComponentRootElementEquivalentTo(Element element) {
        return this.domProvider.getComponentRootElementEquivalentTo(element);
    }

    boolean canHighlightComponentRootElement(Element element) {
        return this.domProvider.canHighlightComponentRootElmenet(element);
    }

    DomProvider.InlineEditorSupport createInlineEditorSupport(Element element, String string, String string2) {
        return this.domProvider.createInlineEditorSupport(element, string, string2);
    }

    void importString(String string, Point point, Node node, int n, Dimension dimension, boolean bl, Element element, Element element2) {
        this.domProvider.importString(this, string, point, node, n, dimension, bl, element, element2);
    }

    boolean importData(JComponent jComponent, Transferable transferable, Point point, Node node, int n, Dimension dimension, boolean bl, Element element, Element element2, int n2) {
        return this.domProvider.importData(this, jComponent, transferable, point, node, n, dimension, bl, element, element2, n2);
    }

    public void startInlineEditing(Element element, String string) {
        this.getManager().startInlineEditing(element, string);
    }

    public void selectComponent(Element element) {
        this.getSelection().selectComponent(element);
    }

    public int getSelectedCount() {
        return this.getSelection().getNumSelected();
    }

    public Element[] getSelectedComponents() {
        return this.getSelection().getSelectedComponentRootElements();
    }

    public Rectangle modelToView(DomProvider.DomPosition domPosition) {
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + ".modelToView(DesignerPaneBase, Position)");
        }
        if (domPosition == null) {
            throw new IllegalArgumentException("Null position.");
        }
        return ModelViewMapper.modelToView(this.getPane().getPageBox(), domPosition);
    }

    public DomProvider.DomPosition viewToModel(Point point) {
        return ModelViewMapper.viewToModel(this, point.x, point.y);
    }

    public boolean isInlineEditing() {
        return this.getManager().isInlineEditing();
    }

    public DomProvider.DomPosition createDomPosition(Node node, int n, DomProvider.DomPosition.Bias bias) {
        return this.domProvider.createDomPosition(node, n, bias);
    }

    public DomProvider.DomPosition createDomPosition(Node node, boolean bl) {
        return this.domProvider.createDomPosition(node, bl);
    }

    public DomProvider.DomRange createDomRange(Node node, int n, Node node2, int n2) {
        return this.domProvider.createDomRange(node, n, node2, n2);
    }

    public int compareBoundaryPoints(Node node, int n, Node node2, int n2) {
        return this.domProvider.compareBoundaryPoints(node, n, node2, n2);
    }

    DomProvider.DomPosition first(DomProvider.DomPosition domPosition, DomProvider.DomPosition domPosition2) {
        return this.domProvider.first(domPosition, domPosition2);
    }

    DomProvider.DomPosition last(DomProvider.DomPosition domPosition, DomProvider.DomPosition domPosition2) {
        return this.domProvider.last(domPosition, domPosition2);
    }

    public WebForm findExternalForm(URL uRL) {
        Designer[] designerArray = this.domProvider.getExternalDesigners(uRL);
        if (designerArray.length > 0 && designerArray[0] instanceof WebForm) {
            return (WebForm)designerArray[0];
        }
        return null;
    }

    public Designer.Box findBox(int n, int n2) {
        return ModelViewMapper.findBox(this.getPane().getPageBox(), n, n2);
    }

    public Designer.Box findBoxForSourceElement(Element element) {
        return this.findCssBoxForElement(element);
    }

    public Designer.Box findBoxForComponentRootElement(Element element) {
        return ModelViewMapper.findBoxForComponentRootElement(this.getPane().getPageBox(), element);
    }

    public Designer.Box findBoxForElement(Element element) {
        return this.findCssBoxForElement(element);
    }

    public Element getPrimarySelectedComponent() {
        this.getSelection().pickPrimary();
        return this.getSelection().getPrimary();
    }

    public DomProvider.DomPosition computeNextPosition(DomProvider.DomPosition domPosition) {
        return ModelViewMapper.computeArrowRight(this, domPosition);
    }

    public DomProvider.DomPosition computePreviousPosition(DomProvider.DomPosition domPosition) {
        return ModelViewMapper.computeArrowLeft(this, domPosition);
    }

    public boolean isInsideEditableRegion(DomProvider.DomPosition domPosition) {
        InlineEditor inlineEditor = this.getManager().getInlineEditor();
        if (inlineEditor != null) {
            DomProvider.DomPosition domPosition2 = inlineEditor.getBegin();
            DomProvider.DomPosition domPosition3 = inlineEditor.getEnd();
            return domPosition.isLaterThan(domPosition2) && domPosition.isEarlierThan(domPosition3);
        }
        if (this.isRenderedNode(domPosition.getNode())) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Node is expected to be not rendered, node=" + domPosition.getNode()));
        }
        if (!this.isGridMode()) {
            return true;
        }
        CssBox cssBox = this.getManager().getInsertModeBox();
        if (cssBox == null) {
            return false;
        }
        Element element = CssBox.getElementForComponentRootCssBox(cssBox);
        WebForm webForm = cssBox.getWebForm();
        if (webForm == null) {
            return false;
        }
        DomProvider.DomPosition domPosition4 = this.createDomPosition(webForm.getDomProviderService().getSourceElement(element), 0, DomProvider.DomPosition.Bias.FORWARD);
        DomProvider.DomPosition domPosition5 = this.createDomPosition(domPosition4.getNode(), domPosition4.getNode().getChildNodes().getLength(), DomProvider.DomPosition.Bias.BACKWARD);
        return domPosition.isLaterThan(domPosition4) && domPosition.isEarlierThan(domPosition5);
    }

    public void finishInlineEditing(boolean bl) {
        this.getManager().finishInlineEditing(bl);
    }

    public void invokeDeleteNextCharAction(ActionEvent actionEvent) {
        InlineEditor inlineEditor = this.getManager().getInlineEditor();
        if (inlineEditor != null) {
            inlineEditor.invokeDeleteNextCharAction(actionEvent);
        }
    }

    public Transferable inlineCopyText(boolean bl) {
        InlineEditor inlineEditor = this.getManager().getInlineEditor();
        if (inlineEditor != null) {
            return inlineEditor.copyText(bl);
        }
        return null;
    }

    public Element getPrimarySelection() {
        return this.getSelection().getPrimary();
    }

    public Element getSelectedContainer() {
        return this.getSelection().getSelectedContainer();
    }

    public void setSelectedComponents(Element[] elementArray, boolean bl) {
        this.getSelection().selectComponents(elementArray, bl);
    }

    public void clearSelection(boolean bl) {
        this.getSelection().clearSelection(bl);
    }

    public void syncSelection(boolean bl) {
        this.getManager().syncSelection(bl);
        this.getSelection().syncSelection(bl);
    }

    public void updateSelectedNodes() {
        this.getSelection().updateNodes();
    }

    public Designer.Box getPageBox() {
        return this.getPane().getPageBox();
    }

    public Point getPastePoint() {
        return this.getManager().getPastePoint();
    }

    public ActionMap getPaneActionMap() {
        return this.getPane().getActionMap();
    }

    public void paneRequestFocus() {
        this.getPane().requestFocus();
    }

    public JComponent createPaneComponent() {
        return this.getPane();
    }

    public void updatePaneViewPort() {
        this.getPane().updateViewport();
    }

    public boolean hasPaneCaret() {
        return this.getPane().hasCaret();
    }

    public DomProvider.DomRange getPaneCaretRange() {
        return this.getPane().getCaretRange();
    }

    public void setPaneCaret(DomProvider.DomPosition domPosition) {
        this.getPane().setCaretDot(domPosition);
    }

    public void resetPanePageBox() {
        this.getPane().getPaneUI().resetPageBox();
    }

    public void redoPaneLayout(boolean bl) {
        PageBox pageBox = this.getPane().getPageBox();
        if (pageBox == null) {
            return;
        }
        pageBox.redoLayout(bl);
    }

    public boolean isRenderedNode(Node node) {
        return this.domProvider.isRenderedNode(node);
    }

    public void addDesignerListener(Designer.DesignerListener designerListener) {
        this.listenerList.add(Designer.DesignerListener.class, designerListener);
    }

    public void removeDesignerListener(Designer.DesignerListener designerListener) {
        this.listenerList.remove(Designer.DesignerListener.class, designerListener);
    }

    private Designer.DesignerListener[] getDesignerListeners() {
        Object[] objectArray = this.listenerList.getListenerList();
        ArrayList<Designer.DesignerListener> arrayList = new ArrayList<Designer.DesignerListener>();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != Designer.DesignerListener.class) continue;
            arrayList.add((Designer.DesignerListener)objectArray[i + 1]);
        }
        return arrayList.toArray(new Designer.DesignerListener[arrayList.size()]);
    }

    public void fireUserActionPerformed(Designer.DesignerEvent designerEvent) {
        Designer.DesignerListener[] designerListenerArray;
        for (Designer.DesignerListener designerListener : designerListenerArray = this.getDesignerListeners()) {
            designerListener.userActionPerformed(designerEvent);
        }
    }

    public void fireUserPopupActionPerformed(Designer.DesignerPopupEvent designerPopupEvent) {
        Designer.DesignerListener[] designerListenerArray;
        for (Designer.DesignerListener designerListener : designerListenerArray = this.getDesignerListeners()) {
            designerListener.userPopupActionPerformed(designerPopupEvent);
        }
    }

    public void fireUserElementClicked(Designer.DesignerClickEvent designerClickEvent) {
        Designer.DesignerListener[] designerListenerArray;
        for (Designer.DesignerListener designerListener : designerListenerArray = this.getDesignerListeners()) {
            designerListener.userElementClicked(designerClickEvent);
        }
    }

    public void fireSelectionChanged(Designer.DesignerEvent designerEvent) {
        Designer.DesignerListener[] designerListenerArray;
        for (Designer.DesignerListener designerListener : designerListenerArray = this.getDesignerListeners()) {
            designerListener.selectionChanged(designerEvent);
        }
    }

    void paintDesignerDecorations(Graphics2D graphics2D) {
        this.domProvider.paintDesignerDecorations(graphics2D, this);
    }

    public Designer.RenderContext createRenderContext() {
        return new RenderContextImpl(this);
    }

    public void setPaintSizeMask(boolean bl) {
        this.paintSizeMask = bl;
    }

    public boolean isPaintSizeMask() {
        return this.paintSizeMask;
    }

    public Decoration getDecoration(Element element) {
        return this.domProvider.getDecoration(element);
    }

    public int adjustX(int n) {
        return n += DesignerPane.getAdjustX();
    }

    public int adjustY(int n) {
        return n += DesignerPane.getAdjustY();
    }

    public int snapX(int n, Designer.Box box) {
        boolean bl = this.isGridSnap();
        int n2 = this.getGridWidth();
        return WebForm.doSnapX(n, box == null ? 0 : box.getAbsoluteX(), bl, n2);
    }

    public int snapX(int n) {
        return this.snapX(n, null);
    }

    private static int doSnapX(int n, int n2, boolean bl, int n3) {
        int n4 = n2;
        n -= n4;
        if (bl) {
            n = (n + n3 / 2) / n3 * n3;
        }
        return n += n4;
    }

    public int snapY(int n, Designer.Box box) {
        boolean bl = this.isGridSnap();
        int n2 = this.getGridHeight();
        return WebForm.doSnapY(n, box == null ? 0 : box.getAbsoluteY(), bl, n2);
    }

    public int snapY(int n) {
        return this.snapY(n, null);
    }

    private static int doSnapY(int n, int n2, boolean bl, int n3) {
        int n4 = n2;
        n -= n4;
        if (bl) {
            n = (n + n3 / 2) / n3 * n3;
        }
        return n += n4;
    }

    public void setInitialFocusMarkCssBox(CssBox cssBox) {
        this.initialFocusMarkCssBoxWRef = new WeakReference<CssBox>(cssBox);
    }

    public CssBox getInitialFocusMarkCssBox() {
        return (CssBox)this.initialFocusMarkCssBoxWRef.get();
    }

    public void setPageSize(Dimension dimension) {
        this.pageSize.setSize(dimension);
        PageBox pageBox = this.designerPane.getPageBox();
        if (pageBox != null) {
            pageBox.redoLayout(true);
        }
        this.designerPane.repaint();
    }

    public int getPageSizeWidth() {
        return this.pageSize.width;
    }

    public int getPageSizeHeight() {
        return this.pageSize.height;
    }

    public void setGridShow(boolean bl) {
        this.gridShow = bl;
        this.designerPane.repaint();
    }

    public boolean isGridShow() {
        return this.gridShow;
    }

    public void setGridSnap(boolean bl) {
        this.gridSnap = bl;
        this.designerPane.repaint();
    }

    public boolean isGridSnap() {
        return this.gridSnap;
    }

    public void setGridWidth(int n) {
        this.gridWidth = n;
        this.designerPane.repaint();
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridHeight(int n) {
        this.gridHeight = n;
        this.designerPane.repaint();
    }

    public void setGridTraceWidth(int n) {
        this.gridTraceWidth = n;
    }

    public int getGridTraceWidth() {
        return this.gridTraceWidth;
    }

    public void setGridTraceHeight(int n) {
        this.gridTraceHeight = n;
    }

    public int getGridTraceHeight() {
        return this.gridTraceHeight;
    }

    public int getGridHeight() {
        return this.gridWidth;
    }

    public void setShowDecorations(boolean bl) {
        this.showDecorations = bl;
        this.designerPane.repaint();
    }

    public boolean isShowDecorations() {
        return this.showDecorations;
    }

    public void setDefaultFontSize(int n) {
        this.defaultFontSize = n;
        DesignerPaneUI designerPaneUI = this.designerPane.getPaneUI();
        if (designerPaneUI != null) {
            designerPaneUI.resetPageBox();
        }
        this.designerPane.repaint();
    }

    public int getDefaultFontSize() {
        return this.defaultFontSize;
    }

    public static Element getComponentRootElementForCssBox(CssBox cssBox) {
        WebForm webForm;
        WebForm webForm2 = webForm = cssBox == null ? null : cssBox.getWebForm();
        if (webForm == null) {
            return null;
        }
        while (cssBox != null) {
            Element element = cssBox.getElement();
            if (webForm.getDomProviderService().isPrincipalElement(element, null)) {
                return element;
            }
            cssBox = cssBox.getParent();
        }
        return null;
    }

    public static Element getElementForComponentRootCssBox(CssBox cssBox) {
        if (cssBox == null) {
            return null;
        }
        Element element = cssBox.getElement();
        BoxType boxType = cssBox.getBoxType();
        if (element == null || boxType == BoxType.LINEBOX || boxType == BoxType.TEXT || boxType == BoxType.SPACE) {
            return null;
        }
        return WebForm.getElementForPrincipalCssBox(cssBox);
    }

    private static Element getElementForPrincipalCssBox(CssBox cssBox) {
        if (cssBox == null) {
            return null;
        }
        WebForm webForm = cssBox.getWebForm();
        if (webForm == null) {
            return null;
        }
        Element element = cssBox.getElement();
        ContainerBox containerBox = cssBox.getParent();
        Element element2 = containerBox == null ? null : containerBox.getElement();
        return webForm.getDomProviderService().isPrincipalElement(element, element2) ? element : null;
    }

    private static class RenderContextImpl
    implements Designer.RenderContext {
        private final WebForm webForm;

        public RenderContextImpl(WebForm webForm) {
            this.webForm = webForm;
        }

        public Dimension getVieportDimension() {
            return this.webForm.getPane().getPageBox().getViewport().getExtentSize();
        }

        public Point getViewportPosition() {
            return this.webForm.getPane().getPageBox().getViewport().getViewPosition();
        }

        public int getNonTabbedTextWidth(char[] cArray, int n, int n2, FontMetrics fontMetrics) {
            return DesignerUtils.getNonTabbedTextWidth(cArray, n, n2, fontMetrics);
        }

        public Rectangle getBoundsForComponent(Element element) {
            if (element != null) {
                return ModelViewMapper.getComponentBounds(this.webForm.getPane().getPageBox(), element);
            }
            return null;
        }
    }

    public static class DefaultDesignerEvent
    implements Designer.DesignerEvent {
        private final Designer designer;
        private final Designer.Box box;

        public DefaultDesignerEvent(Designer designer, Designer.Box box) {
            this.designer = designer;
            this.box = box;
        }

        public Designer getDesigner() {
            return this.designer;
        }

        public Designer.Box getBox() {
            return this.box;
        }
    }
}

