/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.faces.FacesDesignProperty;
import com.sun.rave.designtime.markup.BasicMarkupMouseRegion;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import com.sun.rave.designtime.markup.MarkupDesignInfo;
import com.sun.rave.designtime.markup.MarkupMouseRegion;
import com.sun.rave.designtime.markup.MarkupPosition;
import com.sun.rave.designtime.markup.MarkupRenderContext;
import com.sun.webui.jsf.component.Body;
import com.sun.webui.jsf.component.PanelGroup;
import com.sun.webui.jsf.component.PanelLayout;
import com.sun.webui.jsf.component.Tab;
import com.sun.webui.jsf.component.TabSet;
import com.sun.webui.jsf.component.util.DesignUtil;
import com.sun.webui.jsf.design.AbstractDesignInfo;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TabDesignInfo
extends AbstractDesignInfo
implements MarkupDesignInfo {
    private static Pattern gridPattern = Pattern.compile(".*-rave-layout\\s*:\\s*grid.*");

    public TabDesignInfo() {
        super(Tab.class);
    }

    public Result beanCreatedSetup(DesignBean bean) {
        DesignBean childBean;
        DesignBean parentBean;
        super.beanCreatedSetup(bean);
        DesignContext context = bean.getDesignContext();
        DesignProperty textProperty = bean.getProperty("text");
        String suffix = DesignUtil.getNumericalSuffix(bean.getInstanceName());
        textProperty.setValue((Object)(bean.getBeanInfo().getBeanDescriptor().getDisplayName() + " " + suffix));
        TabDesignInfo.selectTab(bean);
        if (context.canCreateBean(PanelLayout.class.getName(), bean, null)) {
            DesignBean panelBean = context.createBean(PanelLayout.class.getName(), bean, null);
            panelBean.getDesignInfo().beanCreatedSetup(panelBean);
            panelBean.getProperty("panelLayout").setValue((Object)TabDesignInfo.getParentLayout(bean));
        }
        if ((parentBean = bean.getBeanParent()).getInstance() instanceof Tab && (childBean = parentBean.getChildBean(0)).getInstance() instanceof PanelLayout) {
            context.deleteBean(childBean);
        }
        return Result.SUCCESS;
    }

    public Result beanPastedSetup(DesignBean bean) {
        DesignBean childBean;
        DesignContext context = bean.getDesignContext();
        DesignBean parentBean = bean.getBeanParent();
        if (parentBean.getInstance() instanceof Tab && (childBean = parentBean.getChildBean(0)).getInstance() instanceof PanelLayout) {
            context.deleteBean(childBean);
        }
        return Result.SUCCESS;
    }

    public Result beanDeletedCleanup(DesignBean bean) {
        TabDesignInfo.unselectTab(bean);
        return Result.SUCCESS;
    }

    public boolean acceptChild(DesignBean parentBean, DesignBean childBean, Class childClass) {
        if (parentBean.getInstance() instanceof Tab) {
            Tab tab = (Tab)parentBean.getInstance();
            if (childBean != null && childBean.getBeanParent() != null) {
                return false;
            }
            if (childClass.equals(Tab.class)) {
                if (tab.getChildCount() != 1) {
                    return true;
                }
                UIComponent component = (UIComponent)tab.getChildren().get(0);
                if (!(component instanceof PanelLayout) || component.getChildCount() == 0) {
                    return true;
                }
            }
            if ((UIPanel.class.isAssignableFrom(childClass) || PanelGroup.class.isAssignableFrom(childClass) || PanelLayout.class.isAssignableFrom(childClass)) && tab.getChildCount() == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean acceptParent(DesignBean parentBean, DesignBean childBean, Class childClass) {
        Object parent = parentBean.getInstance();
        if (parent instanceof TabSet) {
            return true;
        }
        return parent instanceof Tab && !(parentBean.getBeanParent().getBeanParent().getInstance() instanceof Tab);
    }

    public void instanceNameChanged(DesignBean bean, String oldInstanceName) {
        DesignBean tabSetBean;
        for (tabSetBean = bean.getBeanParent(); tabSetBean != null && !(tabSetBean.getInstance() instanceof TabSet); tabSetBean = tabSetBean.getBeanParent()) {
            tabSetBean.getProperty("selectedChildId").setValue(null);
        }
        if (tabSetBean != null) {
            DesignProperty selectedProperty = tabSetBean.getProperty("selected");
            if (oldInstanceName != null && oldInstanceName.equals(selectedProperty.getValue())) {
                selectedProperty.setValue((Object)bean.getInstanceName());
            }
        }
    }

    public void customizeRender(MarkupDesignBean bean, MarkupRenderContext renderContext) {
        MarkupPosition end;
        DocumentFragment documentFragment = renderContext.getDocumentFragment();
        MarkupPosition begin = renderContext.getBeginPosition();
        if (begin == (end = renderContext.getEndPosition())) {
            return;
        }
        assert (begin.getUnderParent() == end.getUnderParent());
        Element tabElement = null;
        for (Node n = begin.getBeforeSibling(); n != null && tabElement == null; n = n.getParentNode()) {
            if (n.getNodeType() != 1 || !n.getLocalName().equals("td")) continue;
            tabElement = (Element)n;
        }
        if (tabElement != null) {
            FacesDesignProperty selectedProperty = TabDesignInfo.getTabSetSelectedProperty((DesignBean)bean);
            String id = (String)bean.getProperty("id").getValue();
            if (selectedProperty != null && id != null && !id.equals(selectedProperty.getValue())) {
                Tab tab = (Tab)bean.getInstance();
                if (tab.getTabChildCount() == 0) {
                    this.registerTab((DesignBean)bean, renderContext, tabElement);
                } else if (!selectedProperty.getValue().equals(tab.getSelectedChildId())) {
                    this.registerTab((DesignBean)bean, renderContext, tabElement);
                }
            }
        }
    }

    private void registerTab(final DesignBean bean, MarkupRenderContext context, Element e) {
        String styleClass = e.getAttribute("class");
        if (styleClass.indexOf("disabled") == -1) {
            BasicMarkupMouseRegion region = new BasicMarkupMouseRegion(){

                public boolean isClickable() {
                    return true;
                }

                public Result regionClicked(int clickCount) {
                    TabDesignInfo.selectTab(bean);
                    return Result.SUCCESS;
                }
            };
            context.associateMouseRegion(e, (MarkupMouseRegion)region);
            return;
        }
    }

    private static void selectTab(DesignBean bean) {
        FacesDesignProperty property = TabDesignInfo.getTabSetSelectedProperty(bean);
        assert (property != null);
        if (property != null && !property.isBound()) {
            property.setValue((Object)bean.getInstanceName());
        }
    }

    private static void unselectTab(DesignBean bean) {
        DesignBean tabSet = null;
        String id = null;
        DesignBean parentBean = bean.getBeanParent();
        if (parentBean.getInstance() instanceof TabSet) {
            tabSet = bean.getBeanParent();
        } else {
            int index;
            tabSet = TabDesignInfo.getTabSetBean(bean);
            DesignBean[] childrenBeans = parentBean.getChildBeans();
            for (index = 0; index < childrenBeans.length && bean != childrenBeans[index]; ++index) {
            }
            if (index > 0) {
                id = childrenBeans[index - 1].getInstanceName();
            } else if (childrenBeans.length > 1) {
                id = childrenBeans[1].getInstanceName();
            }
        }
        assert (tabSet != null);
        if (tabSet != null) {
            FacesDesignProperty property = (FacesDesignProperty)tabSet.getProperty("selected");
            assert (property != null);
            if (property != null && !property.isBound() && property.getValue().equals(bean.getInstanceName())) {
                property.setValue((Object)id);
            }
        }
    }

    private static FacesDesignProperty getTabSetSelectedProperty(DesignBean tabBean) {
        DesignBean tabSetBean = TabDesignInfo.getTabSetBean(tabBean);
        if (tabSetBean == null) {
            return null;
        }
        return (FacesDesignProperty)tabSetBean.getProperty("selected");
    }

    private static DesignBean getTabSetBean(DesignBean tabBean) {
        DesignBean bean;
        for (bean = tabBean.getBeanParent(); bean != null && !(bean.getInstance() instanceof TabSet); bean = bean.getBeanParent()) {
        }
        return bean;
    }

    private static String getParentLayout(DesignBean bean) {
        while (bean != null) {
            String style;
            if ((bean.getInstance() instanceof Body || bean instanceof MarkupDesignBean && ((MarkupDesignBean)bean).getElement().getTagName().equals("div")) && (style = (String)bean.getProperty("style").getValue()) != null && gridPattern.matcher(style).matches()) {
                return "grid";
            }
            bean = bean.getBeanParent();
        }
        return "flow";
    }
}

