/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.vforms;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.ext.componentgroup.ComponentGroupHolder;
import com.sun.rave.designtime.ext.componentgroup.impl.ColorWrapperImpl;
import com.sun.rave.designtime.ext.componentgroup.util.ComponentGroupHelper;
import com.sun.webui.jsf.component.Form;
import com.sun.webui.jsf.component.FormDesignInfo;
import com.sun.webui.jsf.component.vforms.HomogonousCellRenderer;
import com.sun.webui.jsf.component.vforms.TextFieldCellEditor;
import com.sun.webui.jsf.component.vforms.VirtualFormsCustomizer;
import com.sun.webui.jsf.component.vforms.VirtualFormsHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class VirtualFormsCustomizerPanel
extends JPanel {
    protected VirtualFormsCustomizer customizer;
    private ArrayList vformsList = new ArrayList();
    private FormsTableModel vformsTableModel = new FormsTableModel();
    private HashMap colorMap = new HashMap();
    private JButton btnDelete;
    private JButton btnNew;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel tableLabel;
    private JTable vformsTable;

    public VirtualFormsCustomizerPanel(VirtualFormsCustomizer customizer) {
        this.customizer = customizer;
        this.initComponents();
        this.readVFormInfo();
    }

    public Result applyChanges() {
        Form.VirtualFormDescriptor[] vforms = this.vformsList.toArray(new Form.VirtualFormDescriptor[this.vformsList.size()]);
        String vfConfig = Form.generateVirtualFormsConfig((Form.VirtualFormDescriptor[])vforms);
        DesignProperty vfcProp = this.customizer.getDesignBean().getProperty("virtualFormsConfig");
        vfcProp.setValue((Object)vfConfig);
        DesignContext context = this.customizer.getDesignBean().getDesignContext();
        for (int i = 0; vforms != null && i < vforms.length; ++i) {
            String vfName = vforms[i].getName();
            String key = this.getColorKey(vfName);
            Color c = (Color)this.colorMap.get(key);
            if (c == null) continue;
            context.setContextData(key, (Object)new ColorWrapperImpl(c));
        }
        this.customizer.setModified(false);
        return null;
    }

    private void readVFormInfo() {
        DesignBean formBean = this.customizer.getDesignBean();
        DesignContext dcontext = formBean.getDesignContext();
        ComponentGroupHolder[] holders = ComponentGroupHelper.getComponentGroupHolders((DesignContext)dcontext);
        ComponentGroupHelper.populateColorMap((DesignContext)dcontext, (ComponentGroupHolder[])holders, (Map)this.colorMap);
        Form form = (Form)formBean.getInstance();
        Form.VirtualFormDescriptor[] vforms = form.getVirtualForms();
        for (int i = 0; vforms != null && i < vforms.length; ++i) {
            Form.VirtualFormDescriptor vformCopy = new Form.VirtualFormDescriptor(vforms[i].getName());
            vformCopy.setParticipatingIds(vforms[i].getParticipatingIds());
            vformCopy.setSubmittingIds(vforms[i].getSubmittingIds());
            this.vformsList.add(vformCopy);
        }
        this.vformsTable.setModel(this.vformsTableModel);
        this.vformsTable.setSelectionMode(0);
        TableColumn colorCol = this.vformsTable.getColumnModel().getColumn(0);
        colorCol.setCellRenderer(new ColorCellRenderer());
        colorCol.setCellEditor(new DefaultCellEditor(new ColorComboBox()));
        ((DefaultCellEditor)colorCol.getCellEditor()).setClickCountToStart(2);
        if (this.vformsTableModel.getRowCount() > 0) {
            this.vformsTable.changeSelection(0, 0, false, false);
        }
    }

    private String getColorKey(String vfName) {
        DesignBean formBean = this.customizer.getDesignBean();
        String formBeanId = formBean.getInstanceName();
        String formIdDotVfName = formBeanId + "." + vfName;
        return ComponentGroupHelper.getComponentGroupColorKey((String)FormDesignInfo.VIRTUAL_FORM_HOLDER_NAME, (String)formIdDotVfName);
    }

    private void initComponents() {
        this.tableLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.vformsTable = new JTable();
        this.vformsTable.setSelectionMode(0);
        JTextField textField = new JTextField();
        TextFieldCellEditor cellEditor = new TextFieldCellEditor(this.vformsTable, textField);
        this.vformsTable.setDefaultEditor(String.class, cellEditor);
        this.vformsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ((DefaultCellEditor)this.vformsTable.getDefaultEditor(String.class)).setClickCountToStart(1);
        this.vformsTable.setDefaultRenderer(String.class, new HomogonousCellRenderer());
        this.vformsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.jPanel1 = new JPanel();
        this.btnNew = new JButton();
        this.btnDelete = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName("Edit Virtual Forms dialog box");
        this.getAccessibleContext().setAccessibleDescription("Use this table to view and edit properties of the virutal forms defined on this page.");
        this.tableLabel.setDisplayedMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("labelMnemonic").charAt(0));
        this.tableLabel.setLabelFor(this.vformsTable);
        this.tableLabel.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("customizeLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.add((Component)this.tableLabel, gridBagConstraints);
        this.tableLabel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("tableLabelAccessibleName"));
        this.tableLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("tableLabelAccessibleDescription"));
        this.jScrollPane1.setBackground(SystemColor.window);
        this.vformsTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.vformsTable.setShowVerticalLines(false);
        this.jScrollPane1.setViewportView(this.vformsTable);
        this.vformsTable.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("vformsTableAccessibleName"));
        this.vformsTable.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("vformsTableAccessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 17, 10);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane1.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("vformsTableAccessibleName"));
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("vformsTableAccessibleDescription"));
        this.jPanel1.setLayout(new GridLayout(2, 1, 0, 5));
        this.btnNew.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("newButtonMnemonic").charAt(0));
        this.btnNew.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("newButton"));
        this.btnNew.setToolTipText(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("NewVf"));
        this.btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VirtualFormsCustomizerPanel.this.btnNewActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnNew);
        this.btnNew.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("btnNewAccessibleName"));
        this.btnNew.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("btnNewAccessibleDescription"));
        this.btnDelete.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("deleteButtonMnemonic").charAt(0));
        this.btnDelete.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("deleteButton"));
        this.btnDelete.setToolTipText(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("DeleteVf"));
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VirtualFormsCustomizerPanel.this.btnDeleteActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnDelete);
        this.btnDelete.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("btnDeleteAccessibleName"));
        this.btnDelete.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("btnDeleteAccessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        int vfidx = this.vformsTable.getSelectedRow();
        if (vfidx > -1 && vfidx < this.vformsList.size()) {
            Form.VirtualFormDescriptor vform = (Form.VirtualFormDescriptor)this.vformsList.get(vfidx);
            String title = ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("confirmDeleteTitle");
            String msg = MessageFormat.format(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("confirmDeleteMessage"), vform.getName());
            if (JOptionPane.showConfirmDialog(this, msg, title, 0) == 0) {
                this.vformsList.remove(vfidx);
                this.vformsTableModel.fireTableDataChanged();
                if (this.vformsList.size() <= vfidx) {
                    --vfidx;
                }
                if (vfidx >= 0) {
                    this.vformsTable.getSelectionModel().setSelectionInterval(vfidx, vfidx);
                }
            }
        }
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        String name = VirtualFormsHelper.getNewVirtualFormName(this.vformsList);
        Form.VirtualFormDescriptor vform = new Form.VirtualFormDescriptor(name);
        this.vformsList.add(vform);
        this.vformsTableModel.fireTableDataChanged();
        this.vformsTable.getSelectionModel().setSelectionInterval(this.vformsList.size() - 1, this.vformsList.size() - 1);
    }

    class ColorComboBox
    extends JComboBox {
        public ColorComboBox() {
            DefaultComboBoxModel<Color> cbm = new DefaultComboBoxModel<Color>();
            for (int i = 0; i < ComponentGroupHelper.DEFAULT_COLOR_SET.length; ++i) {
                Color c = ComponentGroupHelper.DEFAULT_COLOR_SET[i];
                cbm.addElement(c);
            }
            this.setModel(cbm);
            this.setRenderer(new ColorListRenderer());
            this.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("colorComboAccessibleName"));
            this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("colorComboAccessibleDescription"));
        }
    }

    class ColorIcon
    implements Icon {
        private Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, 8, 8);
            g.setColor(Color.black);
            g.drawRect(x, y, 8, 8);
        }

        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    class ColorListRenderer
    extends DefaultListCellRenderer {
        ColorListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            Color c = (Color)value;
            this.setIcon(new ColorIcon(c));
            this.setText(null);
            return this;
        }
    }

    class ColorCellRenderer
    extends DefaultTableCellRenderer {
        Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("TextField.selectionBackground");
        Color SELECTION_FOREGROUND = UIManager.getDefaults().getColor("TextField.selectionForeground");
        Color BACKGROUND = UIManager.getDefaults().getColor("TextField.background");
        Color FOREGROUND = UIManager.getDefaults().getColor("TextField.foreground");

        ColorCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected) {
                c.setBackground(this.SELECTION_BACKGROUND);
                c.setForeground(this.SELECTION_FOREGROUND);
            } else {
                c.setBackground(this.BACKGROUND);
                c.setForeground(this.FOREGROUND);
            }
            Color color = (Color)value;
            this.setIcon(new ColorIcon(color));
            this.setText(null);
            return c;
        }
    }

    class FormsTableModel
    extends AbstractTableModel {
        public int getRowCount() {
            return VirtualFormsCustomizerPanel.this.vformsList.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("colorHeader");
                }
                case 1: {
                    return ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("nameHeader");
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Color.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return null;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Form.VirtualFormDescriptor vform = (Form.VirtualFormDescriptor)VirtualFormsCustomizerPanel.this.vformsList.get(rowIndex);
            if (vform != null) {
                switch (columnIndex) {
                    case 0: {
                        String vfName = vform.getName();
                        String key = VirtualFormsCustomizerPanel.this.getColorKey(vfName);
                        return ComponentGroupHelper.getMappedColor((String)key, (Map)VirtualFormsCustomizerPanel.this.colorMap);
                    }
                    case 1: {
                        return vform.getName();
                    }
                }
            }
            return null;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Form.VirtualFormDescriptor vform = (Form.VirtualFormDescriptor)VirtualFormsCustomizerPanel.this.vformsList.get(rowIndex);
            if (vform != null) {
                switch (columnIndex) {
                    case 0: {
                        String vfName = vform.getName();
                        String colorKey = VirtualFormsCustomizerPanel.this.getColorKey(vfName);
                        VirtualFormsCustomizerPanel.this.colorMap.put(colorKey, aValue);
                        VirtualFormsCustomizerPanel.this.customizer.setModified(true);
                        return;
                    }
                    case 1: {
                        String name = aValue.toString();
                        name = name.trim();
                        name = name.replaceAll("\\|", "_");
                        name = name.replaceAll(",", "_");
                        if (name.length() < 1) {
                            name = VirtualFormsHelper.getNewVirtualFormName(VirtualFormsCustomizerPanel.this.vformsList);
                        }
                        String vfName = vform.getName();
                        String colorKey = VirtualFormsCustomizerPanel.this.getColorKey(vfName);
                        Color c = (Color)VirtualFormsCustomizerPanel.this.colorMap.get(colorKey);
                        VirtualFormsCustomizerPanel.this.colorMap.remove(colorKey);
                        vform.setName(name);
                        colorKey = VirtualFormsCustomizerPanel.this.getColorKey(name);
                        VirtualFormsCustomizerPanel.this.colorMap.put(colorKey, c);
                        VirtualFormsCustomizerPanel.this.customizer.setModified(true);
                        return;
                    }
                }
            }
        }
    }
}

