/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.TreeNode;
import com.sun.webui.jsf.component.util.DesignMessageUtil;
import com.sun.webui.jsf.renderkit.html.AbstractDesignTimeRenderer;
import com.sun.webui.jsf.renderkit.html.TreeNodeRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;

public class TreeNodeDesignTimeRenderer
extends AbstractDesignTimeRenderer {
    protected static String STYLE_CLASS_PROP = "styleClass";
    boolean isTextSet;
    boolean isStyleSet;

    public TreeNodeDesignTimeRenderer() {
        super((Renderer)new TreeNodeRenderer());
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (TreeNode.class.isAssignableFrom(component.getClass())) {
            ValueBinding valueBinding = component.getValueBinding("text");
            TreeNode treeNode = (TreeNode)component;
            String text = treeNode.getText();
            if (valueBinding != null && (text == null || text.toString().length() == 0)) {
                Object dummyText = TreeNodeDesignTimeRenderer.getDummyData(context, valueBinding);
                if (dummyText == null) {
                    treeNode.setText("");
                } else {
                    treeNode.setText(dummyText.toString());
                }
                this.isTextSet = true;
            } else if (treeNode.getText() == null) {
                treeNode.setText(DesignMessageUtil.getMessage(TreeNodeDesignTimeRenderer.class, "treeNode.label"));
                String styleClass = (String)component.getAttributes().get(STYLE_CLASS_PROP);
                component.getAttributes().put(STYLE_CLASS_PROP, TreeNodeDesignTimeRenderer.addStyleClass(styleClass, UNINITITIALIZED_STYLE_CLASS));
                this.isTextSet = true;
                this.isStyleSet = true;
            }
        }
        super.encodeBegin(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        if (this.isTextSet) {
            TreeNode treeNode = (TreeNode)component;
            treeNode.setText(null);
            this.isTextSet = false;
        }
        if (this.isStyleSet) {
            String styleClass = (String)component.getAttributes().get(STYLE_CLASS_PROP);
            component.getAttributes().put(STYLE_CLASS_PROP, TreeNodeDesignTimeRenderer.removeStyleClass(styleClass, UNINITITIALIZED_STYLE_CLASS));
            this.isStyleSet = false;
        }
    }
}

