/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.actions.schema;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.All;
import org.netbeans.modules.xml.schema.model.AnyAttribute;
import org.netbeans.modules.xml.schema.model.AnyElement;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.AttributeGroupReference;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.Choice;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.Enumeration;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.GroupReference;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.LocalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.Sequence;
import org.netbeans.modules.xml.schema.model.SimpleContent;
import org.netbeans.modules.xml.schema.model.SimpleContentRestriction;
import org.netbeans.modules.xml.schema.model.SimpleExtension;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.schema.model.SimpleTypeRestriction;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.ActionHelper;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.schema.visitor.AbstractXSDVisitor;
import org.netbeans.modules.xml.wsdl.ui.spi.ExtensibilityElementConfigurator;
import org.netbeans.modules.xml.wsdl.ui.spi.ExtensibilityElementConfiguratorFactory;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.util.NbBundle;

public class ExtensibilityElementCreatorVisitor
extends AbstractXSDVisitor {
    private WSDLComponent mComponent;
    private WSDLModel mModel;
    private Definitions mDefinitions;
    private Stack<WSDLComponent> mStack = new Stack();
    private ExtensibilityElement mRootExtensibilityElement;

    public ExtensibilityElementCreatorVisitor(WSDLComponent wSDLComponent) {
        this.mComponent = wSDLComponent;
        this.push(this.mComponent);
        this.mModel = wSDLComponent.getModel();
        this.mDefinitions = this.mModel.getDefinitions();
    }

    public ExtensibilityElement getRootExtensibilittElement() {
        return this.mRootExtensibilityElement;
    }

    public void visit(LocalAttribute localAttribute) {
        Attribute.Use use = localAttribute.getUseEffective();
        if (use.equals((Object)Attribute.Use.REQUIRED)) {
            NamedComponentReference namedComponentReference = localAttribute.getType();
            if (namedComponentReference != null) {
                this.visitAttribute((Attribute)localAttribute, localAttribute.getName(), (SimpleType)namedComponentReference.get());
            } else {
                this.visitAttribute((Attribute)localAttribute, localAttribute.getName(), (SimpleType)localAttribute.getInlineType());
            }
        }
    }

    public void visit(AttributeReference attributeReference) {
        NamedComponentReference namedComponentReference;
        Attribute.Use use = attributeReference.getUseEffective();
        if (use.equals((Object)Attribute.Use.REQUIRED) && (namedComponentReference = attributeReference.getRef()) != null) {
            this.visit((GlobalAttribute)namedComponentReference.get());
        }
    }

    public void visit(GlobalAttribute globalAttribute) {
        NamedComponentReference namedComponentReference = globalAttribute.getType();
        if (namedComponentReference != null) {
            this.visitAttribute((Attribute)globalAttribute, globalAttribute.getName(), (SimpleType)namedComponentReference.get());
        } else {
            this.visitAttribute((Attribute)globalAttribute, globalAttribute.getName(), (SimpleType)globalAttribute.getInlineType());
        }
    }

    public void visit(AttributeGroupReference attributeGroupReference) {
        NamedComponentReference namedComponentReference = attributeGroupReference.getGroup();
        if (namedComponentReference != null) {
            this.visit((GlobalAttributeGroup)namedComponentReference.get());
        }
    }

    public void visit(GlobalAttributeGroup globalAttributeGroup) {
        List list = globalAttributeGroup.getChildren();
        for (SchemaComponent schemaComponent : list) {
            if (schemaComponent instanceof LocalAttribute) {
                this.visit((LocalAttribute)schemaComponent);
                continue;
            }
            if (schemaComponent instanceof AttributeReference) {
                this.visit((AttributeReference)schemaComponent);
                continue;
            }
            if (!(schemaComponent instanceof AttributeGroupReference)) continue;
            this.visit((AttributeGroupReference)schemaComponent);
        }
    }

    public void visit(ElementReference elementReference) {
        NamedComponentReference namedComponentReference;
        int n = elementReference.getMinOccursEffective();
        if ((this.mStack.size() == 1 || n > 0) && (namedComponentReference = elementReference.getRef()) != null && namedComponentReference.get() != null) {
            this.visit((GlobalElement)namedComponentReference.get());
        }
    }

    public void visit(LocalElement localElement) {
        int n = localElement.getMinOccursEffective();
        if (this.mStack.size() == 1 || n > 0) {
            String string = localElement.getModel().getSchema().getTargetNamespace();
            this.visit((TypeContainer)localElement, localElement.getName(), string);
        }
    }

    public void visit(GlobalElement globalElement) {
        String string = globalElement.getModel().getSchema().getTargetNamespace();
        this.visit((TypeContainer)globalElement, globalElement.getName(), string);
    }

    public void visit(All all) {
        Collection collection3;
        Collection collection2 = all.getElements();
        for (Collection collection3 : collection2) {
            this.visit((LocalElement)collection3);
        }
        collection3 = all.getElementReferences();
        for (ElementReference elementReference : collection3) {
            this.visit(elementReference);
        }
    }

    public void visit(AnyAttribute anyAttribute) {
    }

    public void visit(AnyElement anyElement) {
    }

    public void visit(Choice choice) {
        List list = choice.getChildren();
        for (SchemaComponent schemaComponent : list) {
            if (schemaComponent instanceof AnyElement) {
                this.visit((AnyElement)schemaComponent);
                continue;
            }
            if (schemaComponent instanceof Choice) {
                this.visit((Choice)schemaComponent);
                continue;
            }
            if (schemaComponent instanceof ElementReference) {
                this.visit((ElementReference)schemaComponent);
                continue;
            }
            if (schemaComponent instanceof GroupReference) {
                this.visit((GroupReference)schemaComponent);
                continue;
            }
            if (schemaComponent instanceof LocalElement) {
                this.visit((LocalElement)schemaComponent);
                continue;
            }
            if (!(schemaComponent instanceof Sequence)) continue;
            this.visit((Sequence)schemaComponent);
        }
    }

    public void visit(GroupReference groupReference) {
        NamedComponentReference namedComponentReference = groupReference.getRef();
        if (namedComponentReference != null) {
            this.visit((GlobalGroup)namedComponentReference.get());
        }
    }

    public void visit(SimpleContent simpleContent) {
    }

    public void visit(SimpleContentRestriction simpleContentRestriction) {
    }

    public void visit(SimpleExtension simpleExtension) {
    }

    public void visit(SimpleTypeRestriction simpleTypeRestriction) {
    }

    private void visit(TypeContainer typeContainer, String string, String string2) {
        String string3;
        String string4 = this.createNamespacePrefix(string2);
        ExtensibilityElement extensibilityElement = this.createExtensibilityElement(string, string4, string2, this.peek());
        this.addExtensibilityElement(this.peek(), extensibilityElement);
        ExtensibilityElementConfigurator extensibilityElementConfigurator = ExtensibilityElementConfiguratorFactory.getDefault().getExtensibilityElementConfigurator(new QName(string2, string));
        if (extensibilityElementConfigurator != null && (string3 = extensibilityElementConfigurator.getDisplayAttributeName(extensibilityElement, extensibilityElement.getQName())) != null && extensibilityElement.getAttribute(string3) == null) {
            String string5 = null;
            string5 = extensibilityElementConfigurator.getAttributeUniqueValuePrefix(extensibilityElement, extensibilityElement.getQName(), string3);
            if (string5 != null) {
                boolean bl = Utility.startTransaction(extensibilityElement.getModel());
                extensibilityElement.setAttribute(string3, NameGenerator.generateUniqueValueForKeyAttribute((WSDLComponent)extensibilityElement, string3, extensibilityElement.getQName(), string5));
                Utility.endTransaction(extensibilityElement.getModel(), bl);
            }
        }
        if (this.mRootExtensibilityElement == null) {
            this.mRootExtensibilityElement = extensibilityElement;
        }
        this.push((WSDLComponent)extensibilityElement);
        if (typeContainer.getType() != null) {
            string3 = (GlobalType)typeContainer.getType().get();
            if (string3 != null) {
                this.visit((GlobalType)string3);
            }
        } else {
            string3 = typeContainer.getInlineType();
            this.visit((LocalType)string3);
        }
        this.pop();
    }

    private void visitAttribute(Attribute attribute, String string, SimpleType simpleType) {
        String string2 = attribute.getDefault();
        String string3 = attribute.getFixed();
        ExtensibilityElement extensibilityElement = (ExtensibilityElement)this.peek();
        String string4 = null;
        if (extensibilityElement.getAttribute(string) != null) {
            return;
        }
        if (string2 != null) {
            string4 = string2;
        } else if (string3 != null) {
            string4 = string3;
        } else {
            QName qName = new QName(attribute.getModel().getSchema().getTargetNamespace(), extensibilityElement.getQName().getLocalPart());
            ExtensibilityElementConfigurator extensibilityElementConfigurator = ExtensibilityElementConfiguratorFactory.getDefault().getExtensibilityElementConfigurator(qName);
            if (simpleType != null) {
                SimpleTypeRestriction simpleTypeRestriction;
                Collection collection;
                String string5 = null;
                if (simpleType instanceof GlobalSimpleType) {
                    string5 = ((GlobalSimpleType)simpleType).getName();
                }
                String string6 = simpleType.getModel().getSchema().getTargetNamespace();
                SchemaModel schemaModel = SchemaModelFactory.getDefault().getPrimitiveTypesModel();
                String string7 = schemaModel.getSchema().getTargetNamespace();
                if (string6 != null && string6.equals(string7) && string5 != null && string5.equals("boolean")) {
                    if (extensibilityElementConfigurator != null) {
                        string4 = extensibilityElementConfigurator.getDefaultValue(extensibilityElement, extensibilityElement.getQName(), string);
                    }
                    if (string4 == null) {
                        string4 = "true";
                        this.addAttributeToExtensibilityElement(extensibilityElement, string, string4);
                        return;
                    }
                } else if (simpleType.getDefinition() instanceof SimpleTypeRestriction && (collection = (simpleTypeRestriction = (SimpleTypeRestriction)simpleType.getDefinition()).getEnumerations()) != null && collection != null) {
                    Iterator iterator;
                    if (extensibilityElementConfigurator != null) {
                        string4 = extensibilityElementConfigurator.getDefaultValue(extensibilityElement, extensibilityElement.getQName(), string);
                    }
                    if (string4 == null && (iterator = collection.iterator()).hasNext()) {
                        Enumeration enumeration = (Enumeration)iterator.next();
                        string4 = enumeration.getValue();
                        this.addAttributeToExtensibilityElement(extensibilityElement, string, string4);
                        return;
                    }
                }
            }
            if (string4 == null && (extensibilityElementConfigurator == null || (string4 = extensibilityElementConfigurator.getDefaultValue(extensibilityElement, extensibilityElement.getQName(), string)) == null)) {
                string4 = NbBundle.getMessage(ExtensibilityElementCreatorVisitor.class, (String)"REQUIRED_PROPERTY_DEFAULT_VALUE");
            }
        }
        this.addAttributeToExtensibilityElement(extensibilityElement, string, string4);
    }

    private String createNamespacePrefix(String string) {
        String string2 = Utility.getNamespacePrefix(string, this.mModel);
        if (string2 == null) {
            string2 = NameGenerator.getInstance().generateNamespacePrefix(null, (WSDLComponent)this.mDefinitions);
            boolean bl = Utility.startTransaction(this.mModel);
            ((AbstractDocumentComponent)this.mDefinitions).addPrefix(string2, string);
            Utility.endTransaction(this.mModel, bl);
        }
        return string2;
    }

    private ExtensibilityElement createExtensibilityElement(String string, String string2, String string3, WSDLComponent wSDLComponent) {
        QName qName = null;
        qName = string2 != null ? new QName(string3, string, string2) : new QName(string3, string);
        ExtensibilityElement extensibilityElement = (ExtensibilityElement)this.mModel.getFactory().create(wSDLComponent, qName);
        return extensibilityElement;
    }

    private void addExtensibilityElement(WSDLComponent wSDLComponent, ExtensibilityElement extensibilityElement) {
        boolean bl = Utility.startTransaction(this.mModel);
        final ExtensibilityElement extensibilityElement2 = extensibilityElement;
        wSDLComponent.addExtensibilityElement(extensibilityElement);
        Utility.endTransaction(this.mModel, bl);
        Runnable runnable = new Runnable(){

            public void run() {
                ActionHelper.selectNode((WSDLComponent)extensibilityElement2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void addAttributeToExtensibilityElement(ExtensibilityElement extensibilityElement, String string, String string2) {
        boolean bl = Utility.startTransaction(this.mModel);
        extensibilityElement.setAttribute(string, string2);
        Utility.endTransaction(this.mModel, bl);
    }

    private void push(WSDLComponent wSDLComponent) {
        this.mStack.push(wSDLComponent);
    }

    private void pop() {
        if (!this.mStack.empty()) {
            this.mStack.pop();
        }
    }

    private WSDLComponent peek() {
        if (!this.mStack.empty()) {
            return this.mStack.peek();
        }
        return null;
    }
}

