/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.api.property;

import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;

public class ElementOrType {
    GlobalElement mElement;
    GlobalType mType;
    QName mQName;
    boolean isElement;
    WSDLModel mModel;

    public ElementOrType(GlobalElement globalElement, WSDLModel wSDLModel) {
        this.mElement = globalElement;
        this.mModel = wSDLModel;
    }

    public ElementOrType(GlobalType globalType, WSDLModel wSDLModel) {
        this.mType = globalType;
        this.mModel = wSDLModel;
    }

    public ElementOrType(QName qName, WSDLModel wSDLModel, boolean bl) {
        this.isElement = bl;
        this.mQName = qName;
        this.mModel = wSDLModel;
        if (bl) {
            this.mElement = Utility.findGlobalElement(wSDLModel, this.mQName);
        } else {
            this.mType = Utility.findGlobalType(wSDLModel, this.mQName);
        }
    }

    public boolean isElement() {
        return this.isElement || this.mElement != null;
    }

    public GlobalElement getElement() {
        return this.mElement;
    }

    public GlobalType getType() {
        return this.mType;
    }

    public String toString() {
        if (this.mQName != null) {
            return Utility.fromQNameToString(this.mQName);
        }
        String string = null;
        String string2 = null;
        if (this.mElement != null) {
            string = this.mElement.getModel().getSchema().getTargetNamespace();
            string2 = this.mElement.getName();
        }
        if (this.mType != null) {
            string = this.mType.getModel().getSchema().getTargetNamespace();
            string2 = this.mType.getName();
        }
        if (string == null) {
            return string2;
        }
        if (this.mModel == null) {
            return new QName(string, string2).toString();
        }
        String string3 = Utility.getNamespacePrefix(string, this.mModel);
        if (string3 == null) {
            string3 = NameGenerator.getInstance().generateNamespacePrefix(null, this.mModel);
            boolean bl = Utility.startTransaction(this.mModel);
            ((AbstractDocumentComponent)this.mModel.getDefinitions()).addPrefix(string3, string);
            Utility.endTransaction(this.mModel, bl);
        }
        return string3 + ":" + string2;
    }
}

