/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.api.property;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategorizedSchemaNodeFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.api.property.ChooserHelper;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.NodesFactory;
import org.netbeans.modules.xml.wsdl.ui.wsdl.nodes.BuiltInTypeFolderNode;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.ui.customizer.FolderNode;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementOrTypeChooserHelper
extends ChooserHelper<SchemaComponent> {
    private Node inlineSchemaFolderNode;
    private Node builtinSchemaFolderNode;
    private Node projectsFolderNode;
    private WSDLModel model;
    private List<Class<? extends SchemaComponent>> filters;
    private Project project;
    public static final String SCHEMA_FILE_EXTENSION = "xsd";

    public ElementOrTypeChooserHelper(WSDLModel wSDLModel) {
        this.model = wSDLModel;
    }

    public ElementOrTypeChooserHelper(Project project, WSDLModel wSDLModel) {
        this.model = wSDLModel;
        this.project = project;
    }

    @Override
    public void populateNodes(Node node) {
        List list;
        DefaultProjectCatalogSupport defaultProjectCatalogSupport;
        ArrayList<ChooserHelper.EnabledNode> arrayList;
        FileObject fileObject;
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        this.filters = new ArrayList<Class<? extends SchemaComponent>>();
        this.filters.add(GlobalSimpleType.class);
        this.filters.add(GlobalComplexType.class);
        this.filters.add(GlobalElement.class);
        if (this.project == null && (fileObject = (FileObject)this.model.getModelSource().getLookup().lookup(FileObject.class)) != null) {
            this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        if (this.project != null) {
            this.projectsFolderNode = new FolderNode((Children)new Children.Array());
            this.projectsFolderNode.setDisplayName(NbBundle.getMessage(ElementOrTypeChooserHelper.class, (String)"LBL_ByFile_DisplayName"));
            fileObject = (LogicalViewProvider)this.project.getLookup().lookup(LogicalViewProvider.class);
            arrayList = new ArrayList<ChooserHelper.EnabledNode>();
            arrayList.add(new ChooserHelper.EnabledNode((Node)new SchemaProjectFolderNode(fileObject.createLogicalView(), this.project, this.filters)));
            defaultProjectCatalogSupport = new DefaultProjectCatalogSupport(this.project);
            Set set = defaultProjectCatalogSupport.getProjectReferences();
            if (set != null && set.size() > 0) {
                Iterator object = set.iterator();
                while (object.hasNext()) {
                    list = object.next();
                    Project project = (Project)list;
                    fileObject = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
                    arrayList.add(new ChooserHelper.EnabledNode((Node)new SchemaProjectFolderNode(fileObject.createLogicalView(), project, this.filters)));
                }
            }
            this.projectsFolderNode.getChildren().add(arrayList.toArray(new Node[arrayList.size()]));
        }
        if (this.model != null && (fileObject = this.model.getDefinitions()).getTypes() != null && (arrayList = fileObject.getTypes().getSchemas()) != null && !arrayList.isEmpty()) {
            defaultProjectCatalogSupport = new ArrayList();
            block1: for (Schema schema : arrayList) {
                list = schema.getChildren();
                for (SchemaComponent schemaComponent : list) {
                    boolean bl = false;
                    for (Class<? extends SchemaComponent> clazz : this.filters) {
                        if (!clazz.isInstance(schemaComponent)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    defaultProjectCatalogSupport.add(schema);
                    continue block1;
                }
            }
            if (defaultProjectCatalogSupport.size() > 0) {
                this.inlineSchemaFolderNode = new InlineTypesFolderNode(NodesFactory.getInstance().create((WSDLComponent)fileObject.getTypes()), (Collection<Schema>)defaultProjectCatalogSupport, this.filters);
            }
        }
        this.builtinSchemaFolderNode = new BuiltInTypeFolderNode();
        if (this.projectsFolderNode != null) {
            arrayList2.add(this.projectsFolderNode);
        }
        if (this.inlineSchemaFolderNode != null) {
            arrayList2.add(this.inlineSchemaFolderNode);
        }
        arrayList2.add(this.builtinSchemaFolderNode);
        node.getChildren().add(arrayList2.toArray(new Node[arrayList2.size()]));
    }

    @Override
    public Node selectNode(SchemaComponent schemaComponent) {
        if (schemaComponent == null) {
            return null;
        }
        Node node = null;
        if (schemaComponent != null) {
            String string = schemaComponent.getModel().getSchema().getTargetNamespace();
            if (string != null) {
                if ("http://www.w3.org/2001/XMLSchema".equals(string)) {
                    node = this.selectNode(this.builtinSchemaFolderNode, schemaComponent);
                } else if (this.inlineSchemaFolderNode == null || (node = this.selectNode(this.inlineSchemaFolderNode, schemaComponent)) == null) {
                    node = this.projectsFolderNode != null ? this.selectNode(this.projectsFolderNode, schemaComponent) : null;
                }
            } else if (this.inlineSchemaFolderNode != null) {
                node = this.selectNode(this.inlineSchemaFolderNode, schemaComponent);
            }
        }
        return node;
    }

    private Node selectNode(Node node, SchemaComponent schemaComponent) {
        Children children = node.getChildren();
        for (Node node2 : children.getNodes()) {
            SchemaComponent schemaComponent2 = null;
            SchemaComponentReference schemaComponentReference = (SchemaComponentReference)node2.getLookup().lookup(SchemaComponentReference.class);
            if (schemaComponentReference != null) {
                schemaComponent2 = schemaComponentReference.get();
            }
            if (schemaComponent2 == null) {
                schemaComponent2 = (SchemaComponent)node2.getLookup().lookup(SchemaComponent.class);
            }
            if (schemaComponent2 == schemaComponent) {
                return node2;
            }
            Node node3 = null;
            node3 = this.selectNode(node2, schemaComponent);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InlineTypesFolderNode
    extends FilterNode {
        private Collection<Schema> mSchemas;
        private List<Class<? extends SchemaComponent>> filters;

        public InlineTypesFolderNode(Node node, Collection<Schema> collection, List<Class<? extends SchemaComponent>> list) {
            super(node);
            this.mSchemas = collection;
            this.filters = list;
            this.setDisplayName(NbBundle.getMessage(ElementOrTypeChooserHelper.class, (String)"INLINE_SCHEMATYPE_NAME"));
            this.setChildren((Children)new TypesChildren());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TypesChildren
        extends Children.Keys<Schema> {
            Set<Schema> set = Collections.emptySet();

            protected Node[] createNodes(Schema schema) {
                CategorizedSchemaNodeFactory categorizedSchemaNodeFactory = new CategorizedSchemaNodeFactory(schema.getModel(), InlineTypesFolderNode.this.filters, Lookup.EMPTY);
                Node node = categorizedSchemaNodeFactory.createNode((SchemaComponent)schema);
                return new Node[]{node};
            }

            protected void addNotify() {
                this.resetKeys();
            }

            protected void removeNotify() {
                this.setKeys(this.set);
            }

            private void resetKeys() {
                this.setKeys(InlineTypesFolderNode.this.mSchemas);
            }
        }
    }

    static class SchemaFileFilter
    implements FileFilter {
        SchemaFileFilter() {
        }

        public boolean accept(File file) {
            boolean bl = false;
            String string = file.getName();
            String string2 = null;
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string2 = string.substring(n + 1);
            }
            if (string2 != null && string2.equalsIgnoreCase(ElementOrTypeChooserHelper.SCHEMA_FILE_EXTENSION)) {
                bl = true;
            }
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SchemaProjectFolderChildren
    extends Children.Keys<FileObject> {
        private final FileObject projectDir;
        private final Project wsdlProject;
        private final List<Class<? extends SchemaComponent>> schemaComponentFilters;
        private Set<FileObject> emptySet = Collections.emptySet();

        public SchemaProjectFolderChildren(Project project, List<Class<? extends SchemaComponent>> list) {
            this.wsdlProject = project;
            this.schemaComponentFilters = list;
            this.projectDir = project.getProjectDirectory();
        }

        public Node[] createNodes(FileObject fileObject) {
            ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)false);
            SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
            CategorizedSchemaNodeFactory categorizedSchemaNodeFactory = new CategorizedSchemaNodeFactory(schemaModel, this.schemaComponentFilters, Lookup.EMPTY);
            return new Node[]{new ChooserHelper.FileNode(categorizedSchemaNodeFactory.createNode((SchemaComponent)schemaModel.getSchema()), FileUtil.getRelativePath((FileObject)this.projectDir, (FileObject)fileObject))};
        }

        protected void addNotify() {
            this.resetKeys();
        }

        protected void removeNotify() {
            this.setKeys(this.emptySet);
        }

        private void resetKeys() {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            LogicalViewProvider logicalViewProvider = (LogicalViewProvider)this.wsdlProject.getLookup().lookup(LogicalViewProvider.class);
            Node node = logicalViewProvider.createLogicalView();
            Children children = node.getChildren();
            for (Node node2 : children.getNodes()) {
                File[] fileArray;
                DataObject dataObject = (DataObject)node2.getCookie(DataObject.class);
                if (dataObject == null) continue;
                for (File file : fileArray = ElementOrTypeChooserHelper.this.recursiveListFiles(FileUtil.toFile((FileObject)dataObject.getPrimaryFile()), new SchemaFileFilter())) {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)false);
                    SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
                    if (schemaModel == null || schemaModel.getState() != Model.State.VALID || schemaModel.getSchema().getTargetNamespace() == null) continue;
                    arrayList.add(fileObject);
                }
            }
            this.setKeys(arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SchemaProjectFolderNode
    extends FilterNode {
        public SchemaProjectFolderNode(Node node, Project project, List<Class<? extends SchemaComponent>> list) {
            super(node, (Children)new SchemaProjectFolderChildren(project, list));
        }
    }
}

