/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.fastmodel.impl;

import java.io.File;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.xml.wsdl.ui.fastmodel.FastSchema;
import org.netbeans.modules.xml.wsdl.ui.fastmodel.FastSchemaFactory;
import org.netbeans.modules.xml.wsdl.ui.fastmodel.impl.FastSchemaImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FastSchemaFactoryImpl
extends FastSchemaFactory {
    private boolean mParseImports = false;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public FastSchema newFastSchema(InputStream inputStream, boolean bl) {
        this.mParseImports = bl;
        FastSchemaImpl fastSchemaImpl = new FastSchemaImpl();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            FastWSDLDefinitionsHandler fastWSDLDefinitionsHandler = new FastWSDLDefinitionsHandler(fastSchemaImpl);
            sAXParser.parse(inputStream, (DefaultHandler)fastWSDLDefinitionsHandler);
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Failed to parse schema", exception);
            fastSchemaImpl.setParseErrorMessage(exception.getMessage());
        }
        return fastSchemaImpl;
    }

    public FastSchema newFastSchema(String string) {
        return this.newFastSchema(string, false);
    }

    public FastSchema newFastSchema(String string, boolean bl) {
        File file = new File(string);
        return this.newFastSchema(file, bl);
    }

    public FastSchema newFastSchema(File file) {
        return this.newFastSchema(file, false);
    }

    public FastSchema newFastSchema(File file, boolean bl) {
        this.mParseImports = bl;
        FastSchemaImpl fastSchemaImpl = new FastSchemaImpl();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            FastWSDLDefinitionsHandler fastWSDLDefinitionsHandler = new FastWSDLDefinitionsHandler(fastSchemaImpl);
            sAXParser.parse(file, (DefaultHandler)fastWSDLDefinitionsHandler);
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Failed to parse " + file.getAbsolutePath(), exception);
            fastSchemaImpl.setParseErrorMessage(exception.getMessage());
        }
        return fastSchemaImpl;
    }

    public class FastWSDLDefinitionsHandler
    extends DefaultHandler {
        private String targetNamespace;
        private FastSchema mDef;

        public FastWSDLDefinitionsHandler(FastSchema fastSchema) {
            this.mDef = fastSchema;
        }

        public String getTargetNamespace() {
            return this.targetNamespace;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.endsWith("schema")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string4 = attributes.getQName(i);
                    if (!string4.endsWith("targetNamespace")) continue;
                    this.targetNamespace = attributes.getValue(i);
                    this.mDef.setTargetNamespace(this.targetNamespace);
                    break;
                }
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
        }
    }
}

